/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.filesystem;

import java.util.Collections;
import java.util.List;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;
import org.eclipse.fx.ui.controls.filesystem.DirectoryTreeView;
import org.eclipse.fx.ui.controls.filesystem.DirectoryView;
import org.eclipse.fx.ui.controls.filesystem.ResourceItem;
import org.eclipse.jdt.annotation.NonNull;

public class ResourceEvent<@NonNull T extends ResourceItem>
extends Event {
    private static final EventType<?> OPEN_RESOURCE = new EventType("EFX_CONTROL_OPEN_RESOURCE");
    private final List<ResourceItem> resourceItems;
    private static final long serialVersionUID = 1L;

    public static <T extends ResourceItem> EventType<ResourceEvent<T>> openResourceEvent() {
        return OPEN_RESOURCE;
    }

    ResourceEvent(Object source, EventTarget target, EventType<ResourceEvent<T>> type, List<T> resourceItems) {
        super(source, target, type);
        this.resourceItems = Collections.unmodifiableList(resourceItems);
    }

    public static <T extends ResourceItem> ResourceEvent<T> createOpenResource(DirectoryView view, List<T> resourceItems) {
        return new ResourceEvent<T>((Object)view, (EventTarget)view, ResourceEvent.openResourceEvent(), resourceItems);
    }

    public static <T extends ResourceItem> ResourceEvent<T> createOpenResource(DirectoryTreeView view, List<T> resourceItems) {
        return new ResourceEvent<T>((Object)view, (EventTarget)view, ResourceEvent.openResourceEvent(), resourceItems);
    }

    public List<ResourceItem> getResourceItems() {
        return this.resourceItems;
    }
}

