/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.fx.ui.panes.GridData;
import org.eclipse.fx.ui.panes.GridLayoutPane;
import org.eclipse.fx.ui.workbench.renderers.base.BaseSashRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WSash;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWidget;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.WLayoutedWidgetImpl;

public class DefSashRenderer
extends BaseSashRenderer<Node> {
    protected Class<? extends WSash<Node>> getWidgetClass(MPartSashContainer container) {
        if (container.getTags().contains("fx_fixedLayout")) {
            return WFixedSashImpl.class;
        }
        return WResizableSashImpl.class;
    }

    public static class WFixedSashImpl
    extends WLayoutedWidgetImpl<GridLayoutPane, Node, MPartSashContainer>
    implements WSash<Node> {
        private static GridData toGridData(Map<String, String> dataMap) {
            GridData gd = new GridData();
            if (dataMap.containsKey("fx_layout_width")) {
                gd.widthHint.set(Integer.parseInt(dataMap.get("fx_layout_width")));
                if (!dataMap.containsKey("fx_layout_height")) {
                    gd.grabExcessVerticalSpace.set(true);
                    gd.verticalAlignment.set((Object)GridData.Alignment.FILL);
                }
            }
            if (dataMap.containsKey("fx_layout_height")) {
                gd.heightHint.set(Integer.parseInt(dataMap.get("fx_layout_height")));
                if (!dataMap.containsKey("fx_layout_width")) {
                    gd.grabExcessHorizontalSpace.set(true);
                    gd.horizontalAlignment.set((Object)GridData.Alignment.FILL);
                }
            }
            if (dataMap.containsKey("fx_layout_grab_horizontal")) {
                gd.grabExcessHorizontalSpace.set(Boolean.parseBoolean(dataMap.get("fx_layout_grab_horizontal")));
                gd.horizontalAlignment.set((Object)GridData.Alignment.FILL);
            }
            if (dataMap.containsKey("fx_layout_grab_vertical")) {
                gd.grabExcessVerticalSpace.set(Boolean.parseBoolean(dataMap.get("fx_layout_grab_vertical")));
                gd.verticalAlignment.set((Object)GridData.Alignment.FILL);
            }
            return gd;
        }

        public void addItem(WLayoutedWidget<MPartSashContainerElement> widget) {
            Node n = (Node)widget.getStaticLayoutNode();
            GridLayoutPane p = (GridLayoutPane)this.getWidget();
            if (((MPartSashContainer)this.getDomElement()).isHorizontal()) {
                p.setNumColumns(p.getNumColumns() + 1);
            }
            GridData gd = WFixedSashImpl.toGridData(((MPartSashContainerElement)widget.getDomElement()).getPersistedState());
            GridLayoutPane.setConstraint((Node)n, (GridData)gd);
            p.getChildren().add((Object)n);
        }

        public int getItemCount() {
            return ((GridLayoutPane)this.getWidget()).getChildren().size();
        }

        public void addItems(List<WLayoutedWidget<MPartSashContainerElement>> list) {
            ArrayList<Node> nodeList = new ArrayList<Node>();
            GridLayoutPane p = (GridLayoutPane)this.getWidget();
            for (WLayoutedWidget<MPartSashContainerElement> w : list) {
                Node n = (Node)w.getStaticLayoutNode();
                GridData gd = WFixedSashImpl.toGridData(((MPartSashContainerElement)w.getDomElement()).getPersistedState());
                GridLayoutPane.setConstraint((Node)n, (GridData)gd);
                nodeList.add(n);
            }
            if (((MPartSashContainer)this.getDomElement()).isHorizontal()) {
                p.setNumColumns(p.getNumColumns() + nodeList.size());
            }
            p.getChildren().addAll(nodeList);
        }

        public void addItems(int index, List<WLayoutedWidget<MPartSashContainerElement>> list) {
            ArrayList<Node> nodeList = new ArrayList<Node>();
            GridLayoutPane p = (GridLayoutPane)this.getWidget();
            for (WLayoutedWidget<MPartSashContainerElement> w : list) {
                Node n = (Node)w.getStaticLayoutNode();
                GridData gd = WFixedSashImpl.toGridData(((MPartSashContainerElement)w.getDomElement()).getPersistedState());
                GridLayoutPane.setConstraint((Node)n, (GridData)gd);
                nodeList.add(n);
            }
            if (((MPartSashContainer)this.getDomElement()).isHorizontal()) {
                p.setNumColumns(p.getNumColumns() + nodeList.size());
            }
            p.getChildren().addAll(index, nodeList);
        }

        public void removeItem(WLayoutedWidget<MPartSashContainerElement> widget) {
            Node n = (Node)widget.getStaticLayoutNode();
            GridLayoutPane p = (GridLayoutPane)this.getWidget();
            p.setNumColumns(p.getNumColumns() - 1);
            p.getChildren().remove((Object)n);
        }

        @Override
        protected GridLayoutPane getWidgetNode() {
            return (GridLayoutPane)this.getWidget();
        }

        @Override
        protected GridLayoutPane createWidget() {
            GridLayoutPane p = new GridLayoutPane();
            p.setMarginWidth(0);
            p.setMarginHeight(0);
            p.setHorizontalSpacing(0);
            p.setVerticalSpacing(0);
            return p;
        }
    }

    public static class WResizableSashImpl
    extends WLayoutedWidgetImpl<SplitPane, SplitPane, MPartSashContainer>
    implements WSash<Node> {
        private List<WLayoutedWidget<MPartSashContainerElement>> items = new ArrayList<WLayoutedWidget<MPartSashContainerElement>>();
        private ChangeListener<Number> listener = new ChangeListener<Number>(){
            private boolean queueing;

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (!this.queueing) {
                    this.queueing = true;
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            WResizableSashImpl.this.recalcWeight();
                            queueing = false;
                        }
                    });
                }
            }
        };

        private void recalcWeight() {
            if (this.state != WWidget.WidgetState.CREATED) {
                return;
            }
            double prev = 0.0;
            int idx = 0;
            if (this.items.isEmpty()) {
                return;
            }
            double[] dArray = ((SplitPane)this.getWidget()).getDividerPositions();
            int n = dArray.length;
            int n2 = 0;
            while (n2 < n) {
                double d = dArray[n2];
                ((MPartSashContainerElement)this.items.get(idx++).getDomElement()).setContainerData(String.valueOf((d - prev) * 10.0));
                prev = d;
                ++n2;
            }
            ((MPartSashContainerElement)this.items.get(this.items.size() - 1).getDomElement()).setContainerData(String.valueOf((1.0 - prev) * 10.0));
        }

        @Override
        protected void bindProperties(SplitPane widget) {
            super.bindProperties(widget);
            widget.getDividers().addListener((ListChangeListener)new ListChangeListener<SplitPane.Divider>(){

                public void onChanged(ListChangeListener.Change<? extends SplitPane.Divider> c) {
                    while (c.next()) {
                        for (SplitPane.Divider d : c.getAddedSubList()) {
                            d.positionProperty().addListener(WResizableSashImpl.this.listener);
                        }
                        for (SplitPane.Divider d : c.getRemoved()) {
                            d.positionProperty().removeListener(WResizableSashImpl.this.listener);
                        }
                    }
                }
            });
            for (SplitPane.Divider d : widget.getDividers()) {
                d.positionProperty().addListener(this.listener);
            }
        }

        @Override
        protected SplitPane createWidget() {
            SplitPane p = new SplitPane();
            return p;
        }

        @Inject
        void setOrientation(@Named(value="horizontal") boolean horizontal) {
            ((SplitPane)this.getWidget()).setOrientation(horizontal ? Orientation.HORIZONTAL : Orientation.VERTICAL);
        }

        @Override
        protected SplitPane getWidgetNode() {
            return (SplitPane)this.getWidget();
        }

        public void addItem(WLayoutedWidget<MPartSashContainerElement> widget) {
            SplitPane p = (SplitPane)this.getWidget();
            p.getItems().add((Object)((Node)widget.getStaticLayoutNode()));
            this.items.add(widget);
            this.updateDividers();
        }

        public void addItems(int index, List<WLayoutedWidget<MPartSashContainerElement>> list) {
            SplitPane p = (SplitPane)this.getWidget();
            ArrayList<Node> l = new ArrayList<Node>();
            for (WLayoutedWidget<MPartSashContainerElement> i : list) {
                l.add((Node)i.getStaticLayoutNode());
            }
            p.getItems().addAll(index, l);
            this.items.addAll(index, list);
            this.updateDividers();
        }

        public void addItems(List<WLayoutedWidget<MPartSashContainerElement>> list) {
            SplitPane p = (SplitPane)this.getWidget();
            ArrayList<Node> l = new ArrayList<Node>();
            for (WLayoutedWidget<MPartSashContainerElement> i : list) {
                l.add((Node)i.getStaticLayoutNode());
            }
            p.getItems().addAll(l);
            this.items.addAll(list);
            this.updateDividers();
        }

        @Override
        public void setWidgetState(WWidget.WidgetState state) {
            super.setWidgetState(state);
            if (state == WWidget.WidgetState.CREATED) {
                this.updateDividers();
            }
        }

        public void removeItem(WLayoutedWidget<MPartSashContainerElement> widget) {
            SplitPane p = (SplitPane)this.getWidget();
            p.getItems().remove(widget.getStaticLayoutNode());
            this.items.remove(widget);
            this.updateDividers();
        }

        @Override
        protected void doCleanup() {
            super.doCleanup();
            this.items.clear();
        }

        private void updateDividers() {
            if (this.items.size() <= 1) {
                return;
            }
            if (this.state != WWidget.WidgetState.CREATED) {
                return;
            }
            double total = 0.0;
            for (WLayoutedWidget<MPartSashContainerElement> w : this.items) {
                total += w.getWeight();
            }
            double[] deviders = new double[this.items.size() - 1];
            int i = 0;
            while (i < this.items.size() - 1) {
                deviders[i] = (i == 0 ? 0.0 : deviders[i - 1]) + this.items.get(i).getWeight() / total;
                ++i;
            }
            ((SplitPane)this.getWidget()).setDividerPositions(deviders);
        }

        public int getItemCount() {
            return ((SplitPane)this.getWidget()).getItems().size();
        }
    }
}

