/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.configuration.common.ui.page.overview;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.efm.execution.configuration.common.ui.api.AbstractConfigurationPage;
import org.eclipse.efm.execution.configuration.common.ui.api.AbstractConfigurationProfile;
import org.eclipse.efm.execution.configuration.common.ui.api.IWidgetToolkit;
import org.eclipse.efm.execution.configuration.common.ui.editors.BooleanFieldEditor;
import org.eclipse.efm.execution.configuration.common.ui.editors.StringFieldEditor;
import org.eclipse.efm.execution.core.Activator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class OverviewTestOfflineConfigurationProfile
extends AbstractConfigurationProfile {
    private Text fTracePathText;
    private Button fTraceWorkspaceBrowse;
    private Text fTestPurposePathText;
    private Button fTestPurposeWorkspaceBrowse;
    private BooleanFieldEditor fEnabledTraceConfigurationBooleanField;
    private Group fGroupObservable;
    private Group fGroupControllable;
    private ModifyListener fBasicModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent evt) {
            OverviewTestOfflineConfigurationProfile.this.fConfigurationPage.propagateUpdateJobScheduling();
        }
    };

    public OverviewTestOfflineConfigurationProfile(AbstractConfigurationPage configurationPage) {
        super(configurationPage);
    }

    IDialogSettings getDialogBoundsSettings(String id) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(id);
        if (section == null) {
            section = settings.addNewSection(id);
        }
        return section;
    }

    @Override
    public String getSectionTitle() {
        return "Offline Testing";
    }

    @Override
    public String getSectionDescription() {
        return "Offline Testing, configuration section";
    }

    @Override
    protected void createContent(Composite parent, IWidgetToolkit widgetToolkit) {
        Group group = widgetToolkit.createGroup(parent, "&Trace File Selection", 1, 1, 768);
        Composite comp = widgetToolkit.createComposite((Composite)group, 3, 1, 768);
        this.fTracePathText = widgetToolkit.createSingleText(comp, 1);
        this.fTracePathText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = "Trace File";
            }
        });
        this.fTracePathText.addModifyListener(this.fBasicModifyListener);
        this.fTraceWorkspaceBrowse = widgetToolkit.createPushButton(comp, "&Workspace...", null);
        this.fTraceWorkspaceBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IResource resource;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(OverviewTestOfflineConfigurationProfile.this.fCompositeParent.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle("Select a Resource");
                dialog.setMessage("Select a resource to redirect output to:");
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                dialog.setDialogBoundsSettings(OverviewTestOfflineConfigurationProfile.this.getDialogBoundsSettings("org.eclipse.efm.execution.core.WORKSPACE_SELECTION_DIALOG"), 2);
                if (dialog.open() == 0 && (resource = (IResource)dialog.getFirstResult()) != null) {
                    String arg = resource.getLocation().toString();
                    OverviewTestOfflineConfigurationProfile.this.fTracePathText.setText(arg);
                }
            }
        });
        group = widgetToolkit.createGroup(parent, "&Test Purpose File Selection", 1, 1, 768);
        comp = widgetToolkit.createComposite((Composite)group, 2, 1, 768);
        this.fTestPurposePathText = widgetToolkit.createSingleText(comp, 1);
        this.fTestPurposePathText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = "Test Purpose File";
            }
        });
        this.fTestPurposePathText.addModifyListener(this.fBasicModifyListener);
        this.fTestPurposeWorkspaceBrowse = widgetToolkit.createPushButton(comp, "&Workspace...", null);
        this.fTestPurposeWorkspaceBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IResource resource;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(OverviewTestOfflineConfigurationProfile.this.fCompositeParent.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle("Select a Resource");
                dialog.setMessage("Select a resource to redirect output to:");
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                dialog.setDialogBoundsSettings(OverviewTestOfflineConfigurationProfile.this.getDialogBoundsSettings("org.eclipse.efm.execution.core.WORKSPACE_SELECTION_DIALOG"), 2);
                if (dialog.open() == 0 && (resource = (IResource)dialog.getFirstResult()) != null) {
                    String arg = resource.getLocation().toString();
                    OverviewTestOfflineConfigurationProfile.this.fTestPurposePathText.setText(arg);
                }
            }
        });
        comp = widgetToolkit.createComposite(parent, 1, 1, 768);
        this.fEnabledTraceConfigurationBooleanField = new BooleanFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_TEST_OFFLINE_ENABLED_TRACE_CONFIGURATION", "&Enable Observable / Controllable Configuration", comp, false);
        this.fEnabledTraceConfigurationBooleanField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OverviewTestOfflineConfigurationProfile.this.handleEnablingTraceConfiguration();
            }
        });
        this.fGroupObservable = widgetToolkit.createGroup(parent, "&Observable", 1, 1, 768);
        this.fGroupObservable.setToolTipText("Selection of Observable Element");
        StringFieldEditor textStringField = new StringFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_TEST_OFFLINE_OBSERVABLE_TRACE", "", (Composite)this.fGroupObservable, "//[*] , use for ANY element w.r.t. the kind\n//com_element_id ::= <port_name_id> | <signal_name_id>\n//com = <machine_name_id> -> <com_element_id>\n//input = <machine_name_id> -> <com_element_id>\n//output = <machine_name_id> -> <com_element_id>", 578);
        this.addField(textStringField);
        this.fGroupControllable = widgetToolkit.createGroup(parent, "&Controllable", 1, 1, 768);
        this.fGroupControllable.setToolTipText("Selection of Controllable Element");
        textStringField = new StringFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_TEST_OFFLINE_CONTROLLABLE_TRACE", "", (Composite)this.fGroupControllable, "input#env = [*]", 578);
        this.addField(textStringField);
    }

    private void handleEnablingTraceConfiguration() {
        boolean enabled = this.fEnabledTraceConfigurationBooleanField.getBooleanValue();
        this.fConfigurationPage.propagateVisibility((Composite)this.fGroupObservable, enabled);
        this.fConfigurationPage.propagateVisibility((Composite)this.fGroupControllable, enabled);
    }

    @Override
    protected void setDefaultsImpl(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRACE_FILE_LOCATION", "<merge-trace-file-path>");
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TEST_PURPOSE_FILE_LOCATION", "<test-purpose-file-path>");
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TEST_OFFLINE_ENABLED_TRACE_CONFIGURATION", false);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TEST_OFFLINE_OBSERVABLE_TRACE", "//[*] , use for ANY element w.r.t. the kind\n//com_element_id ::= <port_name_id> | <signal_name_id>\n//com = <machine_name_id> -> <com_element_id>\n//input = <machine_name_id> -> <com_element_id>\n//output = <machine_name_id> -> <com_element_id>");
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TEST_OFFLINE_CONTROLLABLE_TRACE", "input#env = [*]");
    }

    @Override
    protected void initializeFromImpl(ILaunchConfiguration configuration) {
        String testPurposeFile;
        String traceFile;
        try {
            traceFile = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_TRACE_FILE_LOCATION", "<merge-trace-file-path>");
        }
        catch (CoreException e) {
            e.printStackTrace();
            traceFile = "<merge-trace-file-path>";
        }
        this.fTracePathText.setText(traceFile);
        try {
            testPurposeFile = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_TEST_PURPOSE_FILE_LOCATION", "<test-purpose-file-path>");
        }
        catch (CoreException e) {
            e.printStackTrace();
            testPurposeFile = "<test-purpose-file-path>";
        }
        this.fTestPurposePathText.setText(testPurposeFile);
        this.handleEnablingTraceConfiguration();
    }

    @Override
    protected void performApplyImpl(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TRACE_FILE_LOCATION", this.fTracePathText.getText());
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TEST_PURPOSE_FILE_LOCATION", this.fTestPurposePathText.getText());
    }

    @Override
    protected boolean isValidImpl(ILaunchConfiguration launchConfig) {
        String filePath = this.fTracePathText.getText();
        if (filePath == null || filePath.isEmpty()) {
            this.setWarningMessage("The ressource Test Offline trace file path is empty (or null)");
            return false;
        }
        if (!new File(filePath).exists()) {
            this.setWarningMessage("The ressource Test Offline trace file \"" + filePath + "\" does not exist.");
            return false;
        }
        filePath = this.fTestPurposePathText.getText();
        if (filePath == null || filePath.isEmpty()) {
            this.setWarningMessage("The ressource Test Offline test purpose file path is empty (or null)");
            return false;
        }
        if (!filePath.equals("<test-purpose-file-path>") && !new File(filePath).isFile()) {
            this.setWarningMessage("The ressource Test Offline test purpose file \"" + filePath + "\" does not exist.");
            return false;
        }
        return true;
    }
}

