/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.views.markers.MarkerFieldFilterGroup;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;
import org.eclipse.ui.views.tasklist.ITaskListResourceAdapter;

class MarkerResourceUtil {
    static final IProject[] EMPTY_PROJECT_ARRAY = new IProject[0];

    MarkerResourceUtil() {
    }

    static Set<IResource> computeResources(IResource[] selectedResources, Collection<MarkerFieldFilterGroup> enabledFilters, boolean andFilters) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (enabledFilters == null || enabledFilters.size() == 0) {
            HashSet<IResource> set = new HashSet<IResource>(1);
            set.add((IResource)root);
            return set;
        }
        Set<IResource> resourceSet = andFilters ? MarkerResourceUtil.getResourcesFiltersAnded(enabledFilters, selectedResources, root) : MarkerResourceUtil.getResourcesFiltersOred(enabledFilters, selectedResources, root);
        return MarkerResourceUtil.trim2ParentResources(root, resourceSet);
    }

    static Set<IResource> trim2ParentResources(IWorkspaceRoot root, Set<IResource> resourceSet) {
        if (resourceSet.isEmpty() || resourceSet.size() == 1) {
            return resourceSet;
        }
        if (resourceSet.contains(root)) {
            resourceSet.clear();
            resourceSet.add((IResource)root);
            return resourceSet;
        }
        Object[] objectArray = resourceSet.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object clone = objectArray[n2];
            IResource resource = (IResource)clone;
            Iterator<IResource> iterator = resourceSet.iterator();
            while (iterator.hasNext()) {
                IResource resToRemove = iterator.next();
                if (resToRemove.equals((Object)root)) {
                    resourceSet.clear();
                    resourceSet.add((IResource)root);
                    return resourceSet;
                }
                if (resource.equals((Object)resToRemove) || !resource.getFullPath().isPrefixOf(resToRemove.getFullPath())) continue;
                iterator.remove();
            }
            ++n2;
        }
        return resourceSet;
    }

    static Set<IResource> getResourcesFiltersOred(Collection<MarkerFieldFilterGroup> enabledFilters, IResource[] selectedResources, IWorkspaceRoot root) {
        if (enabledFilters == null || enabledFilters.size() == 0) {
            HashSet<IResource> set = new HashSet<IResource>(1);
            set.add((IResource)root);
            return set;
        }
        HashSet<IResource> resourceSet = new HashSet<IResource>();
        for (MarkerFieldFilterGroup group : enabledFilters) {
            Set<IResource> set = MarkerResourceUtil.getResourcesForFilter(group, selectedResources, root);
            resourceSet.addAll(set);
            if (!resourceSet.contains(root)) continue;
            set = new HashSet<IResource>(1);
            set.add((IResource)root);
            return set;
        }
        return resourceSet;
    }

    static Set<IResource> getResourcesFiltersAnded(Collection<MarkerFieldFilterGroup> enabledFilters, IResource[] selectedResources, IWorkspaceRoot root) {
        if (enabledFilters == null || enabledFilters.size() == 0) {
            HashSet<IResource> set = new HashSet<IResource>(1);
            set.add((IResource)root);
            return set;
        }
        HashSet<IResource> resourceSet = new HashSet<IResource>();
        Iterator<MarkerFieldFilterGroup> filtersIterator = enabledFilters.iterator();
        HashSet<IResource> removeMain = new HashSet<IResource>();
        while (filtersIterator.hasNext()) {
            MarkerFieldFilterGroup group = filtersIterator.next();
            Set<IResource> set = MarkerResourceUtil.getResourcesForFilter(group, selectedResources, root);
            if (resourceSet.isEmpty()) {
                resourceSet.addAll(set);
                continue;
            }
            Iterator resIterator = resourceSet.iterator();
            while (resIterator.hasNext()) {
                boolean remove = true;
                IResource mainRes = (IResource)resIterator.next();
                Iterator<IResource> iterator = set.iterator();
                while (iterator.hasNext() && remove) {
                    IResource grpRes = iterator.next();
                    boolean bl = remove = !grpRes.equals((Object)mainRes);
                    if (remove && grpRes.getFullPath().isPrefixOf(mainRes.getFullPath())) {
                        remove = false;
                        continue;
                    }
                    if (!remove || !mainRes.getFullPath().isPrefixOf(grpRes.getFullPath())) continue;
                    remove = false;
                    removeMain.add(mainRes);
                }
                if (!remove) continue;
                resIterator.remove();
            }
            Iterator<IResource> iterator = set.iterator();
            while (iterator.hasNext()) {
                boolean remove = true;
                IResource grpRes = iterator.next();
                resIterator = resourceSet.iterator();
                while (resIterator.hasNext() && remove) {
                    IResource mainRes = (IResource)resIterator.next();
                    boolean bl = remove = !grpRes.equals((Object)mainRes);
                    if (!remove || !mainRes.getFullPath().isPrefixOf(grpRes.getFullPath())) continue;
                    remove = false;
                }
                if (!remove) continue;
                iterator.remove();
            }
            resourceSet.addAll(set);
            resourceSet.removeAll(removeMain);
            removeMain.clear();
            if (!resourceSet.isEmpty()) continue;
            return resourceSet;
        }
        return resourceSet;
    }

    static Set<IResource> getResourcesForFilter(MarkerFieldFilterGroup group, IResource[] selectedResources, IWorkspaceRoot root) {
        HashSet<IResource> resourceSet = new HashSet<IResource>();
        switch (group.getScope()) {
            case 0: {
                resourceSet.add((IResource)root);
                break;
            }
            case 1: 
            case 2: {
                IResource[] iResourceArray = selectedResources;
                int n = selectedResources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource selectedResource = iResourceArray[n2];
                    resourceSet.add(selectedResource);
                    ++n2;
                }
                break;
            }
            case 3: {
                IProject[] iProjectArray = MarkerResourceUtil.getProjects(selectedResources);
                int n = iProjectArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IProject resource = iProjectArray[n3];
                    resourceSet.add((IResource)resource);
                    ++n3;
                }
                break;
            }
            case 4: {
                group.refresh();
                IResource[] iResourceArray = group.getResourcesInWorkingSet();
                int n = iResourceArray.length;
                int n4 = 0;
                while (n4 < n) {
                    IResource resource = iResourceArray[n4];
                    resourceSet.add(resource);
                    ++n4;
                }
                break;
            }
        }
        return resourceSet;
    }

    static IProject[] getProjects(IResource[] resources) {
        if (resources == null) {
            return EMPTY_PROJECT_ARRAY;
        }
        Collection<IProject> projects = MarkerResourceUtil.getProjectsAsCollection(resources);
        return projects.toArray(new IProject[projects.size()]);
    }

    static Collection<IProject> getProjectsAsCollection(Object[] elements) {
        HashSet<IProject> projects = new HashSet<IProject>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IResource) {
                projects.add(((IResource)element).getProject());
            } else {
                IProject[] iProjectArray = ((ResourceMapping)element).getProjects();
                int n3 = iProjectArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProject mappingProject = iProjectArray[n4];
                    projects.add(mappingProject);
                    ++n4;
                }
            }
            ++n2;
        }
        return projects;
    }

    static void addResources(Collection<IResource> resourceCollection, ResourceMapping resourceMapping) {
        try {
            ResourceTraversal[] traversals;
            ResourceTraversal[] resourceTraversalArray = traversals = resourceMapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, (IProgressMonitor)new NullProgressMonitor());
            int n = traversals.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceTraversal traversal = resourceTraversalArray[n2];
                IResource[] iResourceArray = traversal.getResources();
                int n3 = iResourceArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IResource resource = iResourceArray[n4];
                    resourceCollection.add(resource);
                    ++n4;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Policy.handle(e);
        }
    }

    static Object adapt2ResourceElement(Object object) {
        ITaskListResourceAdapter adapter;
        IResource resource = null;
        if (object instanceof IAdaptable && (adapter = (ITaskListResourceAdapter)Adapters.adapt((Object)object, ITaskListResourceAdapter.class)) != null) {
            resource = adapter.getAffectedResource((IAdaptable)object);
        }
        if (resource == null) {
            resource = (IResource)Adapters.adapt((Object)object, IResource.class);
        }
        if (resource == null) {
            resource = (IResource)Adapters.adapt((Object)object, IFile.class);
        }
        if (resource == null) {
            ResourceMapping mapping = (ResourceMapping)Adapters.adapt((Object)object, ResourceMapping.class);
            if (mapping != null) {
                return mapping;
            }
        } else {
            return resource;
        }
        return null;
    }

    static String[] getAllSubTypesIds(String[] typeIds) {
        HashSet<MarkerType> set = MarkerResourceUtil.getAllSubTypes(typeIds);
        return MarkerResourceUtil.toTypeStrings(set);
    }

    static HashSet<MarkerType> getAllSubTypes(String[] typeIds) {
        HashSet<MarkerType> set = new HashSet<MarkerType>();
        MarkerTypesModel typesModel = MarkerTypesModel.getInstance();
        String[] stringArray = typeIds;
        int n = typeIds.length;
        int n2 = 0;
        while (n2 < n) {
            String typeId = stringArray[n2];
            MarkerType type = typesModel.getType(typeId);
            set.add(type);
            MarkerType[] markerTypeArray = type.getAllSubTypes();
            int n3 = markerTypeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                MarkerType sub = markerTypeArray[n4];
                set.add(sub);
                ++n4;
            }
            ++n2;
        }
        return set;
    }

    static String[] getMutuallyExclusiveSupersIds(String[] typeIds) {
        HashSet<MarkerType> set = MarkerResourceUtil.getMutuallyExclusiveSupers(typeIds);
        return MarkerResourceUtil.toTypeStrings(set);
    }

    static HashSet<MarkerType> getMutuallyExclusiveSupers(String[] typeIds) {
        MarkerType type;
        String typeId;
        HashSet<MarkerType> set = new HashSet<MarkerType>();
        MarkerTypesModel typesModel = MarkerTypesModel.getInstance();
        String[] stringArray = typeIds;
        int n = typeIds.length;
        int n2 = 0;
        while (n2 < n) {
            typeId = stringArray[n2];
            type = typesModel.getType(typeId);
            set.add(type);
            ++n2;
        }
        stringArray = typeIds;
        n = typeIds.length;
        n2 = 0;
        while (n2 < n) {
            typeId = stringArray[n2];
            type = typesModel.getType(typeId);
            MarkerType[] subs = type.getAllSubTypes();
            HashSet<MarkerType> subsOnly = new HashSet<MarkerType>(Arrays.asList(subs));
            subsOnly.remove(type);
            set.removeAll(subsOnly);
            ++n2;
        }
        return set;
    }

    private static String[] toTypeStrings(Collection<MarkerType> collection) {
        HashSet<String> ids = new HashSet<String>();
        for (MarkerType type : collection) {
            ids.add(type.getId());
        }
        return ids.toArray(new String[ids.size()]);
    }
}

