/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import fr.inria.zvtm.animation.Animation;
import fr.inria.zvtm.animation.AnimationManager;
import fr.inria.zvtm.animation.EndAction;
import fr.inria.zvtm.animation.interpolation.IdentityInterpolator;
import fr.inria.zvtm.animation.interpolation.SlowInSlowOutInterpolator;
import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.Java2DPainter;
import fr.inria.zvtm.engine.Location;
import fr.inria.zvtm.engine.Transitions;
import fr.inria.zvtm.engine.VCursor;
import fr.inria.zvtm.engine.View;
import fr.inria.zvtm.engine.VirtualSpace;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.engine.portals.DraggableCameraPortal;
import fr.inria.zvtm.event.CameraListener;
import fr.inria.zvtm.event.PortalListener;
import fr.inria.zvtm.event.ViewListener;
import fr.inria.zvtm.glyphs.ClosedShape;
import fr.inria.zvtm.glyphs.DPath;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.SICircle;
import fr.inria.zvtm.glyphs.SIRectangle;
import fr.inria.zvtm.glyphs.Translucent;
import fr.inria.zvtm.glyphs.VRectangle;
import fr.inria.zvtm.glyphs.VRectangleOr;
import fr.inria.zvtm.glyphs.VShape;
import fr.inria.zvtm.glyphs.VText;
import fr.inria.zvtm.lens.FSGaussianLens;
import fr.inria.zvtm.lens.FixedSizeLens;
import fr.inria.zvtm.lens.LInfSCBLens;
import fr.inria.zvtm.lens.Lens;
import fr.inria.zvtm.lens.SCBLens;
import fr.inria.zvtm.svg.Metadata;
import fr.inria.zvtm.widgets.FontDialog;
import java.awt.AWTException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Shape;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.claribole.zgrviewer.AppletUtils;
import net.claribole.zgrviewer.BaseEventHandler;
import net.claribole.zgrviewer.BroughtElement;
import net.claribole.zgrviewer.ConfigManager;
import net.claribole.zgrviewer.DistanceComparator;
import net.claribole.zgrviewer.GeometryEditor;
import net.claribole.zgrviewer.LEdge;
import net.claribole.zgrviewer.LElem;
import net.claribole.zgrviewer.LNode;
import net.claribole.zgrviewer.LinkSliderCalc;
import net.claribole.zgrviewer.LogicalStructure;
import net.claribole.zgrviewer.PeriodicActionManager;
import net.claribole.zgrviewer.RadarEvtHdlr;
import net.claribole.zgrviewer.Ring;
import net.claribole.zgrviewer.RingManager;
import net.claribole.zgrviewer.ToolPalette;
import net.claribole.zgrviewer.Utils;
import net.claribole.zgrviewer.ZGRApplication;
import net.claribole.zgrviewer.ZGRGlassPane;
import net.claribole.zgrviewer.ZP2LensAction;

public class GraphicsManager
implements ComponentListener,
CameraListener,
Java2DPainter {
    static final Color FADE_COLOR = Color.WHITE;
    public VirtualSpaceManager vsm;
    AnimationManager animator;
    VirtualSpace mSpace;
    VirtualSpace mnSpace;
    VirtualSpace rSpace;
    static final String mainSpaceName = "graphSpace";
    static final String menuSpace = "menuSpace";
    static final String rdRegionVirtualSpaceName = "radarSpace";
    VRectangle observedRegion;
    public View mainView;
    View rView;
    static final String RADAR_VIEW_NAME = "Overview";
    Camera mainCamera;
    JPanel mainViewPanel;
    PeriodicActionManager paMngr;
    GeometryEditor geom;
    int panelWidth;
    int panelHeight;
    Lens lens;
    SCBLens fLens;
    public static final int LENS_R1 = 100;
    public static final int LENS_R2 = 50;
    public static final int WHEEL_ANIM_TIME = 50;
    public static final int LENS_ANIM_TIME = 300;
    public static final double DEFAULT_MAG_FACTOR = 4.0;
    static double MAG_FACTOR = 4.0;
    static double INV_MAG_FACTOR = 1.0 / MAG_FACTOR;
    public static final float WHEEL_MM_STEP = 1.0f;
    public static final float MAX_MAG_FACTOR = 12.0f;
    public static final int DM_PORTAL_WIDTH = 200;
    public static final int DM_PORTAL_HEIGHT = 200;
    public static final int DM_PORTAL_INITIAL_X_OFFSET = 150;
    public static final int DM_PORTAL_INITIAL_Y_OFFSET = 150;
    public static final int DM_PORTAL_ANIM_TIME = 150;
    public static final Color DM_COLOR = Color.RED;
    Camera dmCamera;
    DraggableCameraPortal dmPortal;
    VRectangle magWindow;
    int magWindowW;
    int magWindowN;
    int magWindowE;
    int magWindowS;
    boolean paintLinks = false;
    static final float FLOOR_ALTITUDE = -90.0f;
    public static final short MOVE_UP = 0;
    public static final short MOVE_DOWN = 1;
    public static final short MOVE_LEFT = 2;
    public static final short MOVE_RIGHT = 3;
    public static final short MOVE_UP_LEFT = 4;
    public static final short MOVE_UP_RIGHT = 5;
    public static final short MOVE_DOWN_LEFT = 6;
    public static final short MOVE_DOWN_RIGHT = 7;
    ToolPalette tp;
    BaseEventHandler meh;
    RadarEvtHdlr reh;
    ConfigManager cfgMngr;
    static final int MAX_PREV_LOC = 10;
    Vector previousLocations;
    public static final int NO_LENS = 0;
    public static final int ZOOMIN_LENS = 1;
    public static final int ZOOMOUT_LENS = -1;
    int lensType = 0;
    int searchIndex = 0;
    String lastSearchedString = "";
    Vector matchingList = new Vector();
    VRectangleOr boundingBox;
    ZGRGlassPane gp;
    ZGRApplication zapp;
    LogicalStructure lstruct = null;
    double[] dmwnes = new double[4];
    Glyph highlightedLabel;
    Color originalHighlightedLabelColor;
    static final float[] TRIANGLE_VERTICES = new float[]{1.0f, 1.0f, 1.0f};
    static final BasicStroke HIGHLIGHT_STROKE = new BasicStroke(2.0f);
    Vector highlightedEdges = new Vector();
    Vector originalEdgeColor = new Vector();
    Vector originalEdgeBorderColor = new Vector();
    Vector originalEdgeStroke = new Vector();
    Vector highlightedNodes = new Vector();
    Vector originalNodeBorderColor = new Vector();
    Vector originalNodeFillColor = new Vector();
    Vector originalNodeStroke = new Vector();
    int highlightLevel;
    int highlightDir;
    HashMap highlightNodesDone = new HashMap(1000);
    final int highlightTimeStampTimeout = 5;
    Calendar highlightTimeStamp = Calendar.getInstance();
    Vector highlightNodes = new Vector();
    Vector highlightLevels = new Vector();
    Vector highlightDirections = new Vector();
    static final int BRING_ANIM_DURATION = 300;
    static final double BRING_DISTANCE_FACTOR = 1.5;
    static final float FADED_ELEMENTS_TRANSLUCENCY = 0.1f;
    static final float SECOND_STEP_TRANSLUCENCY = 0.3f;
    boolean isBringingAndGoing = false;
    Vector broughtElements = new Vector();
    Vector elementsToFade;
    float[] alphaOfElementsToFade;
    static final int SLIDER_CURSOR_SIZE = 6;
    static final Color SLIDER_CURSOR_FILL = Color.WHITE;
    static final int SELECTION_RADIUS = 200;
    static final Color SELECTION_RADIUS_COLOR = Color.RED;
    boolean isLinkSliding = false;
    LinkSliderCalc[] lscs;
    int lsci = -1;
    DPath slidingLink;
    Color slidingLinkActualColor = null;
    Point2D mPos = new Point2D.Double();
    SICircle slideCursor;
    SICircle selectionRadius;
    Point2D cPos;
    LNode closestNode;
    int screen_cursor_x;
    int screen_cursor_y;
    Robot awtRobot;
    Point2D mtPos = new Point2D.Double();

    public int getPanelWidth() {
        return this.panelWidth;
    }

    public int getPanelHeight() {
        return this.panelHeight;
    }

    GraphicsManager(ZGRApplication za) {
        this.zapp = za;
        this.geom = new GeometryEditor(this);
    }

    Vector createZVTMelements(boolean applet) {
        this.vsm = VirtualSpaceManager.INSTANCE;
        VText.setMainFont(ConfigManager.defaultFont);
        Glyph.setDefaultCursorInsideHighlightColor(ConfigManager.HIGHLIGHT_COLOR);
        this.animator = this.vsm.getAnimationManager();
        this.mSpace = this.vsm.addVirtualSpace(mainSpaceName);
        this.mainCamera = this.mSpace.addCamera();
        this.mainCamera.setZoomFloor(-90.0);
        this.mSpace.addCamera();
        this.mnSpace = this.vsm.addVirtualSpace(menuSpace);
        this.mnSpace.addCamera().setAltitude(10.0);
        this.rSpace = this.vsm.addVirtualSpace(rdRegionVirtualSpaceName);
        this.rSpace.addCamera();
        this.dmCamera = this.mSpace.addCamera();
        this.observedRegion = new VRectangle(0.0, 0.0, 0, 10.0, 10.0, ConfigManager.OBSERVED_REGION_COLOR, ConfigManager.OBSERVED_REGION_CROSSHAIR_COLOR, 0.5f);
        SIRectangle seg1 = new SIRectangle(0.0, 0.0, 0, 0.0, 500.0, ConfigManager.OBSERVED_REGION_CROSSHAIR_COLOR);
        SIRectangle seg2 = new SIRectangle(0.0, 0.0, 0, 500.0, 0.0, ConfigManager.OBSERVED_REGION_CROSSHAIR_COLOR);
        if (!Utils.osIsWindows() && !Utils.osIsMacOS()) {
            this.observedRegion.setFilled(false);
        }
        this.rSpace.addGlyph(this.observedRegion);
        this.rSpace.addGlyph(seg1);
        this.rSpace.addGlyph(seg2);
        Glyph.stickToGlyph(seg1, this.observedRegion);
        Glyph.stickToGlyph(seg2, this.observedRegion);
        this.observedRegion.setSensitivity(false);
        this.tp = new ToolPalette(this);
        Vector<Camera> cameras = new Vector<Camera>();
        cameras.add(this.mSpace.getCamera(0));
        cameras.add(this.mnSpace.getCamera(0));
        cameras.add(this.tp.getPaletteCamera());
        return cameras;
    }

    void createFrameView(Vector cameras, String vt, JMenuBar jmb) {
        this.mainView = this.vsm.addFrameView(cameras, "ZGRViewer", vt, ConfigManager.mainViewW, ConfigManager.mainViewH, true, false, true, jmb);
        this.mainView.setLocation(ConfigManager.mainViewX, ConfigManager.mainViewY);
        this.mainView.getFrame().addComponentListener(this);
        this.gp = new ZGRGlassPane(this);
        ((JFrame)this.mainView.getFrame()).setGlassPane(this.gp);
    }

    JPanel createPanelView(Vector cameras, int w, int h) {
        this.vsm.addPanelView(cameras, "ZGRViewer", "std", w, h);
        this.mainView = this.vsm.getView("ZGRViewer");
        return (JPanel)this.mainView.getPanel().getComponent();
    }

    public VirtualSpace getGraphSpace() {
        return this.mSpace;
    }

    public VirtualSpace getMenuSpace() {
        return this.mnSpace;
    }

    public View getView() {
        return this.mainView;
    }

    public Camera getGraphCamera() {
        return this.mainCamera;
    }

    public Camera getMenuCamera() {
        return this.mnSpace.getCamera(0);
    }

    public BaseEventHandler getViewListener() {
        return this.meh;
    }

    public ToolPalette getToolPalette() {
        return this.tp;
    }

    public VRectangle getMagWindow() {
        return this.magWindow;
    }

    public VRectangleOr getBoundingBox() {
        return this.boundingBox;
    }

    void parameterizeView(BaseEventHandler eh) {
        this.paMngr = new PeriodicActionManager(this);
        this.mainView.setBackgroundColor(this.cfgMngr.backgroundColor);
        this.meh = eh;
        this.mainView.setListener((ViewListener)((Object)eh), 0);
        this.mainView.setListener((ViewListener)((Object)eh), 1);
        this.mainView.setListener((ViewListener)((Object)eh), 2);
        this.mainView.setNotifyCursorMoved(true);
        this.mainCamera.addListener(this);
        this.mainView.setVisible(true);
        this.mainView.getPanel().getComponent().addMouseMotionListener(this.paMngr);
        this.paMngr.start();
        this.mainView.setJava2DPainter(this.paMngr, (short)3);
        this.mainView.setJava2DPainter(this, (short)1);
        this.activateDynaSpot(ConfigManager.DYNASPOT, false);
        this.mainView.getCursor().getDynaPicker().setDynaSpotColor(Color.RED);
        this.mainViewPanel = (JPanel)this.mainView.getPanel().getComponent();
        this.setAntialiasing(ConfigManager.ANTIALIASING);
        this.initDM();
        this.updatePanelSize();
        this.previousLocations = new Vector();
    }

    void activateDynaSpot(boolean b, boolean updatePrefs) {
        if (updatePrefs) {
            ConfigManager.DYNASPOT = b;
        }
        this.mainView.getCursor().getDynaPicker().activateDynaSpot(b);
    }

    void setConfigManager(ConfigManager cm) {
        this.cfgMngr = cm;
    }

    void reset() {
        this.mSpace.removeAllGlyphs();
        this.mSpace.addGlyph(this.magWindow);
        this.mSpace.hide(this.magWindow);
        this.previousLocations.removeAllElements();
        this.highlightedEdges.removeAllElements();
        this.highlightedNodes.removeAllElements();
        this.originalEdgeColor.removeAllElements();
        this.originalNodeFillColor.removeAllElements();
        this.originalNodeBorderColor.removeAllElements();
    }

    void initDM() {
        this.magWindow = new VRectangle(0.0, 0.0, 0, 1.0, 1.0, DM_COLOR);
        this.magWindow.setFilled(false);
        this.magWindow.setBorderColor(DM_COLOR);
        this.mSpace.addGlyph(this.magWindow);
        this.mSpace.hide(this.magWindow);
    }

    void seekBoundingBox() {
        int i;
        Vector<Glyph> v = this.mSpace.getAllGlyphs();
        VRectangleOr largestRectangle = null;
        int lri = -1;
        for (i = 0; i < v.size(); ++i) {
            if (!(v.elementAt(i) instanceof VRectangleOr)) continue;
            VRectangleOr r = (VRectangleOr)v.elementAt(i);
            if (largestRectangle != null && !this.bigger(r, largestRectangle)) continue;
            largestRectangle = r;
            lri = i;
        }
        if (lri == -1) {
            return;
        }
        for (i = lri + 1; i < v.size(); ++i) {
            if (this.containedIn(v.elementAt(i), largestRectangle)) continue;
            return;
        }
        this.boundingBox = largestRectangle;
        this.boundingBox.setVisible(false);
        this.boundingBox.setSensitivity(false);
    }

    boolean bigger(VRectangleOr r1, VRectangleOr r2) {
        return r1.getWidth() * r1.getHeight() > r2.getWidth() * r2.getHeight();
    }

    boolean containedIn(Glyph g, VRectangle r) {
        if (g instanceof DPath || g instanceof VText) {
            return true;
        }
        return g.vx > r.vx - r.getWidth() && g.vx < r.vx + r.getWidth() && g.vy > r.vy - r.getHeight() && g.vy < r.vy + r.getHeight();
    }

    void setAntialiasing(boolean b) {
        ConfigManager.ANTIALIASING = b;
        this.mainView.setAntialiasing(ConfigManager.ANTIALIASING);
    }

    void updatePanelSize() {
        this.tp.displayPalette(false);
        try {
            this.panelWidth = this.mainViewPanel.getWidth();
            this.panelHeight = this.mainViewPanel.getHeight();
            this.paMngr.requestToolPaletteRelocation();
            this.cfgMngr.notifyPlugins((short)4);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void reveal() {
        Camera c = this.mSpace.getCamera(0);
        Location l = this.mainView.getGlobalView(c);
        c.vx = l.vx;
        c.vy = l.vy;
        c.setAltitude(l.alt - c.getFocal());
        this.rememberLocation(this.mSpace.getCamera(0).getLocation());
        Transitions.fadeIn(this.mainView, 500);
        this.getGlobalView();
    }

    public void getGlobalView() {
        Location l = this.mainView.getGlobalView(this.mSpace.getCamera(0), 300);
        this.rememberLocation(this.mSpace.getCamera(0).getLocation());
    }

    public void getHigherView() {
        Camera c = this.mainView.getCameraNumber(0);
        this.rememberLocation(c.getLocation());
        Float alt = new Float(c.getAltitude() + c.getFocal());
        Animation a = this.animator.getAnimationFactory().createCameraAltAnim(300, c, alt.floatValue(), true, SlowInSlowOutInterpolator.getInstance(), null);
        this.animator.startAnimation(a, false);
    }

    public void getLowerView() {
        Camera c = this.mainView.getCameraNumber(0);
        this.rememberLocation(c.getLocation());
        Float alt = new Float(-(c.getAltitude() + c.getFocal()) / 2.0);
        Animation a = this.animator.getAnimationFactory().createCameraAltAnim(300, c, alt.floatValue(), true, SlowInSlowOutInterpolator.getInstance(), null);
        this.animator.startAnimation(a, false);
    }

    public void translateView(short direction) {
        Point2D.Double trans;
        double qt;
        Camera c = this.mainView.getCameraNumber(0);
        this.rememberLocation(c.getLocation());
        double[] rb = this.mainView.getVisibleRegion(c);
        if (direction == 0) {
            qt = (rb[1] - rb[3]) / 2.4;
            trans = new Point2D.Double(0.0, qt);
        } else if (direction == 1) {
            qt = (rb[3] - rb[1]) / 2.4;
            trans = new Point2D.Double(0.0, qt);
        } else if (direction == 3) {
            qt = (rb[2] - rb[0]) / 2.4;
            trans = new Point2D.Double(qt, 0.0);
        } else if (direction == 2) {
            qt = (rb[0] - rb[2]) / 2.4;
            trans = new Point2D.Double(qt, 0.0);
        } else if (direction == 4) {
            qt = (rb[3] - rb[1]) / 2.4;
            double qt2 = (rb[2] - rb[0]) / 2.4;
            trans = new Point2D.Double(qt, qt2);
        } else if (direction == 5) {
            qt = (rb[1] - rb[3]) / 2.4;
            double qt2 = (rb[2] - rb[0]) / 2.4;
            trans = new Point2D.Double(qt, qt2);
        } else if (direction == 7) {
            qt = (rb[1] - rb[3]) / 2.4;
            double qt2 = (rb[0] - rb[2]) / 2.4;
            trans = new Point2D.Double(qt, qt2);
        } else {
            qt = (rb[3] - rb[1]) / 2.4;
            double qt2 = (rb[0] - rb[2]) / 2.4;
            trans = new Point2D.Double(qt, qt2);
        }
        Animation a = this.animator.getAnimationFactory().createCameraTranslation(300, c, trans, true, SlowInSlowOutInterpolator.getInstance(), null);
        this.animator.startAnimation(a, false);
    }

    public void rememberLocation(Location l) {
        if (this.previousLocations.size() >= 10) {
            this.previousLocations.removeElementAt(0);
        }
        if (this.previousLocations.size() > 0) {
            if (!Location.equals((Location)this.previousLocations.lastElement(), l)) {
                this.previousLocations.add(l);
            }
        } else {
            this.previousLocations.add(l);
        }
    }

    public void moveBack() {
        if (this.previousLocations.size() > 0) {
            this.goTo((Location)this.previousLocations.lastElement());
        }
    }

    public void goTo(Location l) {
        Vector animParams = Location.getDifference(this.mSpace.getCamera(0).getLocation(), l);
        Animation at = this.animator.getAnimationFactory().createCameraTranslation(300, this.mSpace.getCamera(0), (Point2D.Double)animParams.elementAt(1), true, SlowInSlowOutInterpolator.getInstance(), null);
        Animation aa = this.animator.getAnimationFactory().createCameraAltAnim(300, this.mSpace.getCamera(0), (Double)animParams.elementAt(0), true, SlowInSlowOutInterpolator.getInstance(), null);
        this.animator.startAnimation(at, false);
        this.animator.startAnimation(aa, false);
    }

    public void showRadarView(boolean b) {
        if (b) {
            if (this.rView == null) {
                Vector<Camera> cameras = new Vector<Camera>();
                cameras.add(this.mSpace.getCamera(1));
                cameras.add(this.rSpace.getCamera(0));
                this.vsm.addFrameView(cameras, RADAR_VIEW_NAME, "std", ConfigManager.rdW, ConfigManager.rdH, true);
                this.reh = new RadarEvtHdlr(this);
                this.rView = this.vsm.getView(RADAR_VIEW_NAME);
                this.rView.getFrame().addComponentListener(this);
                this.rView.setBackgroundColor(this.cfgMngr.backgroundColor);
                this.rView.setListener((ViewListener)this.reh, 0);
                this.rView.setListener((ViewListener)this.reh, 1);
                this.rView.setResizable(true);
                this.rView.setActiveLayer(1);
                this.rView.setCursorIcon(13);
                this.mSpace.getCamera(1).setLocation(this.rView.getGlobalView(this.mSpace.getCamera(1)));
                this.cameraMoved(null, null, 0.0);
                this.vsm.repaint();
            } else {
                ((JFrame)this.rView.getFrame()).toFront();
            }
        }
    }

    public void cameraMoved(Camera cam, Point2D.Double coord, double alt) {
        if (this.rView != null) {
            Camera c0 = this.mSpace.getCamera(1);
            Camera c1 = this.rSpace.getCamera(0);
            c1.vx = c0.vx;
            c1.vy = c0.vy;
            c1.focal = c0.focal;
            c1.altitude = c0.altitude;
            double[] wnes = this.mainView.getVisibleRegion(this.mSpace.getCamera(0));
            this.observedRegion.moveTo((wnes[0] + wnes[2]) / 2.0, (wnes[3] + wnes[1]) / 2.0);
            this.observedRegion.setWidth(wnes[2] - wnes[0]);
            this.observedRegion.setHeight(wnes[1] - wnes[3]);
        }
        this.vsm.repaint();
    }

    public void updateMainViewFromRadar() {
        Camera c0 = this.mSpace.getCamera(0);
        c0.vx = this.observedRegion.vx;
        c0.vy = this.observedRegion.vy;
        this.vsm.repaint();
    }

    public void setLens(int t) {
        this.lensType = t;
    }

    public int getLensType() {
        return this.lensType;
    }

    public void moveLens(int x, int y, long absTime) {
        if (this.fLens != null) {
            this.fLens.setAbsolutePosition(x, y, absTime);
        } else {
            this.lens.setAbsolutePosition(x, y);
        }
        this.vsm.repaint();
    }

    public Lens getLens() {
        return this.lens;
    }

    public void zoomInPhase1(int x, int y) {
        if (this.lens == null) {
            this.lens = this.mainView.setLens(this.getLensDefinition(x, y));
            this.lens.setBufferThreshold(1.5f);
        }
        Animation a = this.animator.getAnimationFactory().createLensMagAnim(300, (FixedSizeLens)this.lens, new Float(MAG_FACTOR - 1.0).floatValue(), true, IdentityInterpolator.getInstance(), null);
        this.animator.startAnimation(a, false);
        this.setLens(1);
    }

    public void zoomInPhase2(double mx, double my) {
        double cameraAbsAlt = this.mainCamera.getAltitude() + this.mainCamera.getFocal();
        double c2x = mx - INV_MAG_FACTOR * (mx - this.mainCamera.vx);
        double c2y = my - INV_MAG_FACTOR * (my - this.mainCamera.vy);
        Double deltAlt = new Double(cameraAbsAlt * (1.0 - MAG_FACTOR) / MAG_FACTOR);
        if (cameraAbsAlt + (double)deltAlt.floatValue() > -90.0) {
            Animation al = this.animator.getAnimationFactory().createLensMagAnim(300, (FixedSizeLens)this.lens, new Float(-MAG_FACTOR + 1.0).floatValue(), true, IdentityInterpolator.getInstance(), new ZP2LensAction(this));
            Animation at = this.animator.getAnimationFactory().createCameraTranslation(300, this.mainCamera, new Point2D.Double(c2x - this.mainCamera.vx, c2y - this.mainCamera.vy), true, IdentityInterpolator.getInstance(), null);
            Animation aa = this.animator.getAnimationFactory().createCameraAltAnim(300, this.mainCamera, deltAlt, true, IdentityInterpolator.getInstance(), null);
            this.animator.startAnimation(al, false);
            this.animator.startAnimation(at, false);
            this.animator.startAnimation(aa, false);
        } else {
            Double actualDeltAlt = new Double(-90.0 - cameraAbsAlt);
            double ratio = actualDeltAlt / deltAlt;
            Animation al = this.animator.getAnimationFactory().createLensMagAnim(300, (FixedSizeLens)this.lens, new Float(-MAG_FACTOR + 1.0).floatValue(), true, IdentityInterpolator.getInstance(), new ZP2LensAction(this));
            Animation at = this.animator.getAnimationFactory().createCameraTranslation(300, this.mainCamera, new Point2D.Double((c2x - this.mainCamera.vx) * ratio, (c2y - this.mainCamera.vy) * ratio), true, IdentityInterpolator.getInstance(), null);
            Animation aa = this.animator.getAnimationFactory().createCameraAltAnim(300, this.mainCamera, actualDeltAlt, true, IdentityInterpolator.getInstance(), null);
            this.animator.startAnimation(al, false);
            this.animator.startAnimation(at, false);
            this.animator.startAnimation(aa, false);
        }
    }

    public void zoomOutPhase1(int x, int y, double mx, double my) {
        double cameraAbsAlt = this.mainCamera.getAltitude() + this.mainCamera.getFocal();
        double c2x = mx - MAG_FACTOR * (mx - this.mainCamera.vx);
        double c2y = my - MAG_FACTOR * (my - this.mainCamera.vy);
        if (this.lens == null) {
            this.lens = this.mainView.setLens(this.getLensDefinition(x, y));
            this.lens.setBufferThreshold(1.5f);
        }
        Animation al = this.animator.getAnimationFactory().createLensMagAnim(300, (FixedSizeLens)this.lens, new Float(MAG_FACTOR - 1.0).floatValue(), true, IdentityInterpolator.getInstance(), null);
        Animation at = this.animator.getAnimationFactory().createCameraTranslation(300, this.mainCamera, new Point2D.Double(c2x - this.mainCamera.vx, c2y - this.mainCamera.vy), true, IdentityInterpolator.getInstance(), null);
        Animation aa = this.animator.getAnimationFactory().createCameraAltAnim(300, this.mainCamera, new Double(cameraAbsAlt * (MAG_FACTOR - 1.0)), true, IdentityInterpolator.getInstance(), null);
        this.animator.startAnimation(al, false);
        this.animator.startAnimation(at, false);
        this.animator.startAnimation(aa, false);
        this.setLens(-1);
    }

    public void zoomOutPhase2() {
        Animation a = this.animator.getAnimationFactory().createLensMagAnim(300, (FixedSizeLens)this.lens, new Float(-MAG_FACTOR + 1.0).floatValue(), true, IdentityInterpolator.getInstance(), new ZP2LensAction(this));
        this.animator.startAnimation(a, false);
    }

    public void setMagFactor(double m) {
        MAG_FACTOR = m;
        INV_MAG_FACTOR = 1.0 / MAG_FACTOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void magnifyFocus(double magOffset, int zooming, Camera ca) {
        Lens lens = this.lens;
        synchronized (lens) {
            double nmf = MAG_FACTOR + magOffset;
            if (nmf <= 12.0 && nmf > 1.0) {
                this.setMagFactor(nmf);
                if (zooming == -1) {
                    double a1 = this.mainCamera.getAltitude();
                    this.lens.setMaximumMagnification((float)nmf, true);
                    this.mainCamera.altitudeOffset((a1 + this.mainCamera.getFocal()) * magOffset / (MAG_FACTOR - magOffset));
                    this.mainCamera.move(a1 - this.mainCamera.getAltitude() / this.mainCamera.getFocal() * (double)this.lens.lx, -(a1 - this.mainCamera.getAltitude() / this.mainCamera.getFocal() * (double)this.lens.ly));
                } else {
                    Animation a = this.animator.getAnimationFactory().createLensMagAnim(50, (FixedSizeLens)this.lens, new Float(magOffset).floatValue(), true, IdentityInterpolator.getInstance(), null);
                    this.animator.startAnimation(a, false);
                }
            }
        }
    }

    Lens getLensDefinition(int x, int y) {
        FixedSizeLens res;
        if (this.tp.isFadingLensNavMode()) {
            this.fLens = new LInfSCBLens(1.0f, 0.0f, 0.95f, 100, x - this.panelWidth / 2, y - this.panelHeight / 2);
            res = this.fLens;
        } else {
            res = new FSGaussianLens(1.0f, 100, 50, x - this.panelWidth / 2, y - this.panelHeight / 2);
            this.fLens = null;
        }
        return res;
    }

    public Camera getDragMagCamera() {
        return this.dmCamera;
    }

    public DraggableCameraPortal getDragMagPortal() {
        return this.dmPortal;
    }

    public void triggerDM(int x, int y, PortalListener pl) {
        if (this.dmPortal != null) {
            this.killDM();
        } else {
            this.createDM(x, y, pl);
        }
    }

    void createDM(int x, int y, PortalListener pl) {
        this.dmPortal = new DraggableCameraPortal(x, y, 200, 200, this.dmCamera);
        this.dmPortal.setPortalListener(pl);
        this.dmPortal.setBackgroundColor(this.mainView.getBackgroundColor());
        this.vsm.addPortal(this.dmPortal, this.mainView);
        this.dmPortal.setBorder(DM_COLOR);
        Location l = this.dmPortal.getSeamlessView(this.mainCamera);
        this.dmCamera.moveTo(l.vx, l.vy);
        this.dmCamera.setAltitude((this.mainCamera.getAltitude() + this.mainCamera.getFocal()) / 4.0 - this.mainCamera.getFocal());
        this.updateMagWindow();
        int w = (int)Math.round(this.magWindow.getWidth() * this.mainCamera.getFocal() / (double)((float)(this.mainCamera.getFocal() + this.mainCamera.getAltitude())));
        int h = (int)Math.round(this.magWindow.getHeight() * this.mainCamera.getFocal() / (double)((float)(this.mainCamera.getFocal() + this.mainCamera.getAltitude())));
        this.dmPortal.sizeTo(w, h);
        this.mSpace.onTop(this.magWindow);
        this.mSpace.show(this.magWindow);
        this.paintLinks = true;
        Animation as = this.animator.getAnimationFactory().createPortalSizeAnim(150, this.dmPortal, 200 - w, 200 - h, true, IdentityInterpolator.getInstance(), null);
        Animation at = this.animator.getAnimationFactory().createPortalTranslation(150, this.dmPortal, new Point(150 - w / 2, 150 - h / 2), true, IdentityInterpolator.getInstance(), null);
        this.animator.startAnimation(as, false);
        this.animator.startAnimation(at, false);
    }

    void killDM() {
        if (this.dmPortal != null) {
            this.vsm.destroyPortal(this.dmPortal);
            this.dmPortal = null;
            this.mSpace.hide(this.magWindow);
            this.paintLinks = false;
        }
        this.meh.resetDragMagInteraction();
    }

    public void updateMagWindow() {
        if (this.dmPortal == null) {
            return;
        }
        this.dmPortal.getVisibleRegion(this.dmwnes);
        this.magWindow.moveTo(this.dmCamera.vx, this.dmCamera.vy);
        this.magWindow.setWidth(this.dmwnes[2] - this.dmwnes[0] + 1.0);
        this.magWindow.setHeight(this.dmwnes[1] - this.dmwnes[3] + 1.0);
    }

    public void updateZoomWindow() {
        this.dmCamera.moveTo(this.magWindow.vx, this.magWindow.vy);
    }

    public void paint(Graphics2D g2d, int viewWidth, int viewHeight) {
        if (this.paintLinks) {
            double coef = this.mainCamera.focal / (this.mainCamera.focal + this.mainCamera.altitude);
            int magWindowX = (int)Math.round((double)(viewWidth / 2) + (this.magWindow.vx - this.mainCamera.vx) * coef);
            int magWindowY = (int)Math.round((double)(viewHeight / 2) - (this.magWindow.vy - this.mainCamera.vy) * coef);
            int magWindowW = (int)Math.round(this.magWindow.getWidth() * coef / 2.0);
            int magWindowH = (int)Math.round(this.magWindow.getHeight() * coef / 2.0);
            g2d.setColor(DM_COLOR);
            g2d.drawLine(magWindowX - magWindowW, magWindowY - magWindowH, this.dmPortal.x, this.dmPortal.y);
            g2d.drawLine(magWindowX + magWindowW, magWindowY - magWindowH, this.dmPortal.x + this.dmPortal.w, this.dmPortal.y);
            g2d.drawLine(magWindowX - magWindowW, magWindowY + magWindowH, this.dmPortal.x, this.dmPortal.y + this.dmPortal.h);
            g2d.drawLine(magWindowX + magWindowW, magWindowY + magWindowH, this.dmPortal.x + this.dmPortal.w, this.dmPortal.y + this.dmPortal.h);
        }
        g2d.setFont(ConfigManager.SMALL_FONT);
        if (this.tp.isHighlightMode()) {
            g2d.drawString("HL = " + this.highlightLevel, viewWidth - 50, 20);
        }
    }

    void search(String s, int direction) {
        if (s.length() > 0) {
            int matchSize;
            if (!s.toLowerCase().equals(this.lastSearchedString)) {
                this.resetSearch(s);
                Glyph[] gl = this.mSpace.getVisibleGlyphsList();
                for (int i = 0; i < gl.length; ++i) {
                    if (!(gl[i] instanceof VText) || ((VText)gl[i]).getText() == null || ((VText)gl[i]).getText().toLowerCase().indexOf(this.lastSearchedString) == -1) continue;
                    this.matchingList.add(gl[i]);
                }
            }
            if ((matchSize = this.matchingList.size()) > 0) {
                this.searchIndex += direction;
                if (this.searchIndex < 0) {
                    this.searchIndex = matchSize - 1;
                } else if (this.searchIndex >= matchSize) {
                    this.searchIndex = 0;
                }
                if (matchSize > 1) {
                    this.zapp.setStatusBarText(AppletUtils.rankString(this.searchIndex + 1) + " of " + matchSize + " matches");
                } else {
                    this.zapp.setStatusBarText("1 match");
                }
                Glyph g = (Glyph)this.matchingList.elementAt(this.searchIndex);
                this.mainView.centerOnGlyph(g, this.mSpace.getCamera(0), 300, true, ConfigManager.MAG_FACTOR * 1.5f);
                this.highlight(g);
                this.vsm.repaint();
            } else {
                this.zapp.setStatusBarText("No match");
            }
        }
    }

    void resetSearch(String s) {
        this.searchIndex = -1;
        this.lastSearchedString = s.toLowerCase();
        this.matchingList.removeAllElements();
        if (this.highlightedLabel != null) {
            this.highlightedLabel.setColor(this.originalHighlightedLabelColor);
            this.highlightedLabel = null;
        }
    }

    void highlight(Glyph g) {
        if (this.highlightedLabel != null) {
            this.highlightedLabel.setColor(this.originalHighlightedLabelColor);
        }
        this.highlightedLabel = g;
        this.originalHighlightedLabelColor = this.highlightedLabel.getColor();
        this.highlightedLabel.setColor(ConfigManager.HIGHLIGHT_COLOR);
    }

    void assignFontToGraph() {
        Font f = FontDialog.getFontDialog((JFrame)this.mainView.getFrame(), ConfigManager.defaultFont);
        if (f != null) {
            ConfigManager.defaultFont = f;
            Vector<Glyph> glyphs = this.mSpace.getAllGlyphs();
            for (int i = 0; i < glyphs.size(); ++i) {
                Glyph g = glyphs.elementAt(i);
                if (!(g instanceof VText)) continue;
                ((VText)g).setFont(null);
            }
            VText.setMainFont(ConfigManager.defaultFont);
        }
    }

    public void componentResized(ComponentEvent e) {
        if (e.getSource() == this.mainView.getFrame()) {
            this.updatePanelSize();
            this.cameraMoved(null, null, 0.0);
            Dimension sz = this.mainView.getFrame().getSize();
            this.cfgMngr.setSDZoomThreshold(0.3 * Math.sqrt(sz.width * sz.width + sz.height * sz.height));
        } else if (e.getSource() == this.rView.getFrame()) {
            this.mSpace.getCamera(1).setLocation(this.rView.getGlobalView(this.mSpace.getCamera(1)));
            this.cameraMoved(null, null, 0.0);
            this.vsm.repaint();
        }
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    void buildLogicalStructure() {
        Vector<Glyph> glyphs = (Vector<Glyph>)this.mSpace.getAllGlyphs().clone();
        glyphs.remove(this.magWindow);
        glyphs.remove(this.boundingBox);
        this.lstruct = LogicalStructure.build(glyphs, this.mSpace);
        if (this.lstruct == null) {
            this.mainView.setStatusBarText("Failed to build logical structure. Some tools are disabled.");
        }
        glyphs = this.mSpace.getAllGlyphs();
        for (int i = 0; i < glyphs.size(); ++i) {
            Glyph g = glyphs.elementAt(i);
            if (g.getOwner() == null || !(g.getOwner() instanceof Metadata)) continue;
            g.setOwner(new LElem((Metadata)g.getOwner()));
        }
        this.cfgMngr.notifyPlugins((short)0);
    }

    public LEdge addEdge(Glyph sn, Glyph en, String title, boolean directed) {
        LNode s = LogicalStructure.getNode(sn);
        LNode e = LogicalStructure.getNode(en);
        if (s != null && e != null) {
            return this.addEdge(s, e, title, directed);
        }
        return null;
    }

    public LEdge addEdge(LNode sn, LNode en, String title, boolean directed) {
        ClosedShape sns = sn.getShape();
        ClosedShape ens = en.getShape();
        BasicStroke st = new BasicStroke(0.2f);
        Shape snsh = st.createStrokedShape(sns.getJava2DShape());
        Shape ensh = st.createStrokedShape(ens.getJava2DShape());
        Area edgeseg = new Area(st.createStrokedShape(new Line2D.Double(sns.vx, sns.vy, ens.vx, ens.vy)));
        Area intersectStart = new Area(snsh);
        intersectStart.intersect(edgeseg);
        Area intersectEnd = new Area(ensh);
        intersectEnd.intersect(edgeseg);
        Rectangle2D spc = intersectStart.getBounds2D();
        Rectangle2D epc = intersectEnd.getBounds2D();
        Point2D.Double cpqd1 = new Point2D.Double((3.0 * spc.getCenterX() + epc.getCenterX()) / 4.0, (3.0 * spc.getCenterY() + epc.getCenterY()) / 4.0);
        Point2D.Double jp = new Point2D.Double((spc.getCenterX() + epc.getCenterX()) / 2.0, (spc.getCenterY() + epc.getCenterY()) / 2.0);
        Point2D.Double cpqd2 = new Point2D.Double((spc.getCenterX() + 3.0 * epc.getCenterX()) / 4.0, (spc.getCenterY() + 3.0 * epc.getCenterY()) / 4.0);
        final DPath spline = new DPath(spc.getCenterX(), spc.getCenterY(), 0, Color.BLACK);
        spline.addQdCurve(jp.x, jp.y, cpqd1.x, cpqd1.y, true);
        spline.addQdCurve(epc.getCenterX(), epc.getCenterY(), cpqd2.x, cpqd2.y, true);
        double theta = Math.atan2(epc.getCenterY() - spc.getCenterY(), epc.getCenterX() - spc.getCenterX());
        final VShape arrowHead = new VShape(epc.getCenterX(), epc.getCenterY(), 0, ens.getSize() / 10.0, TRIANGLE_VERTICES, Color.BLACK, theta);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GraphicsManager.this.mSpace.addGlyph(spline);
                GraphicsManager.this.mSpace.addGlyph(arrowHead);
            }
        });
        Vector<Glyph> glyphs = new Vector<Glyph>(2);
        glyphs.add(spline);
        glyphs.add(arrowHead);
        LEdge res = new LEdge(glyphs);
        res.setDirected(directed);
        res.setTail(sn);
        res.setHead(en);
        this.lstruct.addEdge(res);
        return res;
    }

    public void removeEdge(final LEdge e) {
        this.lstruct.removeEdge(e);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (Glyph g : e.getGlyphs()) {
                    GraphicsManager.this.mSpace.removeGlyph(g, false);
                }
                VirtualSpaceManager.INSTANCE.repaint();
            }
        });
    }

    public void highlightElement(Glyph g, Camera cam, VCursor cursor, boolean highlight, int moreLess, boolean fixNode, int dir) {
        Object o = null;
        if (g != null && g != this.boundingBox) {
            o = g.getOwner();
        } else {
            Vector<Glyph> otherGlyphs = cursor.getPicker().getIntersectingGlyphs(cam);
            if (otherGlyphs != null && otherGlyphs.size() > 0) {
                g = otherGlyphs.firstElement();
                if (g.getOwner() != null) {
                    o = g.getOwner();
                }
            } else {
                this.unhighlightAll();
            }
        }
        if (o != null) {
            if (fixNode) {
                int indexNode = this.highlightNodes.indexOf(o);
                if (indexNode >= 0) {
                    this.highlightNodes.remove(indexNode);
                    this.highlightLevels.remove(indexNode);
                    this.highlightDirections.remove(indexNode);
                    this.unhighlightAll();
                } else {
                    this.highlightNodes.add(o);
                    this.highlightLevels.add(new Integer(this.highlightLevel));
                    this.highlightDirections.add(new Integer(this.highlightDir));
                }
                return;
            }
            if (moreLess == 0) {
                this.highlightLevel = 1;
                this.highlightDir = -1;
            } else {
                this.highlightLevel = Math.max(this.highlightLevel + moreLess, 0);
                this.highlightDir = dir;
            }
            this.unhighlightAll();
            if (o instanceof LNode) {
                this.highlightNodeInOut(o, highlight, this.highlightLevel, dir);
            } else if (o instanceof LEdge) {
                this.highlightEdge(o, highlight);
            }
        }
    }

    public void highlightPermanent() {
        for (int indexNode = 0; indexNode < this.highlightNodes.size(); ++indexNode) {
            LNode n = (LNode)this.highlightNodes.get(indexNode);
            Integer level = (Integer)this.highlightLevels.get(indexNode);
            Integer dir = (Integer)this.highlightDirections.get(indexNode);
            this.highlightNodeInOut(n, true, level, dir);
        }
    }

    synchronized void highlightNodeInOut(LNode n, boolean highlight, int highlightLevel, int dir) {
        this.highlightNodesDone.clear();
        this.highlightTimeStamp = Calendar.getInstance();
        this.highlightTimeStamp.add(13, 5);
        if (dir == 0) {
            this.highlightNode(n, highlight, (short)0, highlightLevel);
        } else {
            if (dir != 2) {
                this.highlightNode(n, highlight, (short)1, highlightLevel);
            }
            this.highlightNodesDone.clear();
            this.highlightTimeStamp = Calendar.getInstance();
            this.highlightTimeStamp.add(13, 5);
            if (dir != 1) {
                this.highlightNode(n, highlight, (short)2, highlightLevel);
            }
        }
    }

    synchronized void highlightNode(LNode n, boolean highlight, short dir, int levelCnt) {
        if (highlight) {
            Glyph g;
            int i;
            if (Calendar.getInstance().after(this.highlightTimeStamp)) {
                this.unhighlightAll();
                return;
            }
            Integer nodeLevel = (Integer)this.highlightNodesDone.get(n);
            if (nodeLevel != null && nodeLevel >= levelCnt) {
                return;
            }
            this.highlightNodesDone.put(n, new Integer(levelCnt));
            for (i = 0; i < n.glyphs.length; ++i) {
                g = n.glyphs[i];
                if (this.highlightedNodes.contains(g)) continue;
                this.highlightedNodes.add(g);
                this.highlightNodeGlyph(g);
            }
            if (levelCnt <= 0) {
                return;
            }
            for (i = 0; i < n.edges.length; ++i) {
                if (dir != 0 && dir != n.edgeDirections[i] && n.edges[i].isDirected()) continue;
                for (int j = 0; j < n.edges[i].glyphs.length; ++j) {
                    g = n.edges[i].glyphs[j];
                    if (this.highlightedEdges.contains(g)) continue;
                    this.highlightedEdges.add(g);
                    this.highlightEdgeGlyph(g);
                }
                this.highlightNode(n.edges[i].getOtherEnd(n), highlight, dir, levelCnt - 1);
            }
        } else {
            this.unhighlightAll();
        }
    }

    synchronized void highlightEdge(LEdge e, boolean highlight) {
        if (highlight) {
            Glyph g;
            int i;
            for (i = 0; i < e.glyphs.length; ++i) {
                g = e.glyphs[i];
                if (this.highlightedEdges.contains(g)) continue;
                this.highlightedEdges.add(g);
                this.highlightEdgeGlyph(g);
            }
            for (i = 0; i < e.tail.glyphs.length; ++i) {
                g = e.tail.glyphs[i];
                if (this.highlightedNodes.contains(g)) continue;
                this.highlightedNodes.add(g);
                this.highlightNodeGlyph(g);
            }
            for (i = 0; i < e.head.glyphs.length; ++i) {
                g = e.head.glyphs[i];
                if (this.highlightedNodes.contains(g)) continue;
                this.highlightedNodes.add(g);
                this.highlightNodeGlyph(g);
            }
        } else {
            this.unhighlightAll();
        }
    }

    void highlightNodeGlyph(Glyph g) {
        this.originalNodeStroke.add(g.getStroke());
        if (g instanceof ClosedShape) {
            this.originalNodeFillColor.add(null);
            this.originalNodeBorderColor.add(((ClosedShape)g).getDefaultBorderColor());
            if (g.isBorderDrawn()) {
                g.setBorderColor(ConfigManager.HIGHLIGHT_COLOR);
            }
        } else {
            this.originalNodeFillColor.add(null);
            this.originalNodeBorderColor.add(g.getDefaultColor());
            g.setColor(ConfigManager.HIGHLIGHT_COLOR);
        }
        g.setStroke(HIGHLIGHT_STROKE);
    }

    void highlightEdgeGlyph(Glyph g) {
        this.originalEdgeColor.add(g.getDefaultColor());
        this.originalEdgeStroke.add(g.getStroke());
        if (g instanceof ClosedShape) {
            this.originalEdgeBorderColor.add(((ClosedShape)g).getDefaultBorderColor());
            if (g.isFilled()) {
                g.setColor(ConfigManager.HIGHLIGHT_COLOR);
            }
            if (g.isBorderDrawn()) {
                g.setBorderColor(ConfigManager.HIGHLIGHT_COLOR);
            }
        } else {
            this.originalEdgeBorderColor.add(Color.BLACK);
            g.setColor(ConfigManager.HIGHLIGHT_COLOR);
        }
        g.setStroke(HIGHLIGHT_STROKE);
    }

    public void unhighlightAll() {
        this.unhighlightAllEdges();
        this.unhighlightAllNodes();
        this.highlightPermanent();
    }

    void unhighlightAllNodes() {
        for (int i = 0; i < this.highlightedNodes.size(); ++i) {
            Glyph g = (Glyph)this.highlightedNodes.elementAt(i);
            if (g instanceof ClosedShape) {
                if (g.isBorderDrawn()) {
                    g.setBorderColor((Color)this.originalNodeBorderColor.elementAt(i));
                }
            } else {
                g.setColor((Color)this.originalNodeBorderColor.elementAt(i));
            }
            g.setStroke((BasicStroke)this.originalNodeStroke.elementAt(i));
        }
        this.highlightedNodes.removeAllElements();
        this.originalNodeBorderColor.removeAllElements();
        this.originalNodeFillColor.removeAllElements();
        this.originalNodeStroke.removeAllElements();
    }

    void unhighlightAllEdges() {
        for (int i = 0; i < this.highlightedEdges.size(); ++i) {
            Glyph g = (Glyph)this.highlightedEdges.elementAt(i);
            if (g instanceof ClosedShape) {
                if (g.isFilled()) {
                    g.setColor((Color)this.originalEdgeColor.elementAt(i));
                }
                if (g.isBorderDrawn()) {
                    g.setBorderColor((Color)this.originalEdgeBorderColor.elementAt(i));
                }
            } else {
                g.setColor((Color)this.originalEdgeColor.elementAt(i));
            }
            g.setStroke((BasicStroke)this.originalEdgeStroke.elementAt(i));
        }
        this.highlightedEdges.removeAllElements();
        this.originalEdgeColor.removeAllElements();
        this.originalEdgeBorderColor.removeAllElements();
        this.originalEdgeStroke.removeAllElements();
    }

    public boolean isBringingAndGoing() {
        return this.isBringingAndGoing;
    }

    void enterBringAndGoMode() {
    }

    void exitBringAndGoMode() {
    }

    void startBringAndGo(Glyph g) {
        ClosedShape otherEndShape;
        LNode otherEnd;
        int i;
        this.isBringingAndGoing = true;
        LNode n = LogicalStructure.getNode(g);
        if (n == null) {
            return;
        }
        this.elementsToFade = (Vector)this.mSpace.getAllGlyphs().clone();
        this.elementsToFade.remove(this.magWindow);
        ClosedShape thisEndShape = n.getShape();
        Glyph[] glyphs = n.getGlyphs();
        for (int i2 = 0; i2 < glyphs.length; ++i2) {
            this.elementsToFade.remove(glyphs[i2]);
        }
        double thisEndBoundingCircleRadius = thisEndShape.getSize();
        double RING_STEP = 2.0 * thisEndBoundingCircleRadius;
        LEdge[] arcs = n.getAllArcs();
        Arrays.sort(arcs, new DistanceComparator(n));
        Hashtable<LNode, Point2D.Double> node2broughtPosition = new Hashtable<LNode, Point2D.Double>();
        RingManager rm = new RingManager();
        for (i = 0; i < arcs.length; ++i) {
            if (arcs[i].isLoop()) continue;
            otherEnd = arcs[i].getOtherEnd(n);
            otherEndShape = otherEnd.getShape();
            double d = Math.sqrt((otherEndShape.vx - thisEndShape.vx) * (otherEndShape.vx - thisEndShape.vx) + (otherEndShape.vy - thisEndShape.vy) * (otherEndShape.vy - thisEndShape.vy));
            Ring ring = rm.getRing(Math.atan2(otherEndShape.vy - thisEndShape.vy, otherEndShape.vx - thisEndShape.vx), thisEndShape.getSize(), RING_STEP);
            double bd = (double)ring.rank * RING_STEP;
            double ratio = bd / d;
            double bx = thisEndShape.vx + ratio * (otherEndShape.vx - thisEndShape.vx);
            double by = thisEndShape.vy + ratio * (otherEndShape.vy - thisEndShape.vy);
            node2broughtPosition.put(otherEnd, new Point2D.Double(bx, by));
        }
        for (i = 0; i < arcs.length; ++i) {
            if (arcs[i].isLoop()) continue;
            otherEnd = arcs[i].getOtherEnd(n);
            otherEndShape = otherEnd.getShape();
            this.bring(arcs[i], otherEnd, thisEndShape.vx, thisEndShape.vy, otherEndShape.vx, otherEndShape.vy, thisEndShape.getSize(), node2broughtPosition);
        }
        this.alphaOfElementsToFade = new float[this.elementsToFade.size()];
        for (i = 0; i < this.elementsToFade.size(); ++i) {
            try {
                Translucent t = (Translucent)this.elementsToFade.elementAt(i);
                this.alphaOfElementsToFade[i] = t.getTranslucencyValue();
                Animation a = this.animator.getAnimationFactory().createTranslucencyAnim(300, t, 0.1f, false, IdentityInterpolator.getInstance(), null);
                this.animator.startAnimation(a, true);
                continue;
            }
            catch (ClassCastException e) {
                e.printStackTrace();
            }
        }
    }

    void endBringAndGo(Glyph g) {
        int i;
        this.isBringingAndGoing = false;
        if (this.elementsToFade == null) {
            return;
        }
        Point2D.Double newCameraLocation = null;
        if (!this.broughtElements.isEmpty()) {
            for (i = this.broughtElements.size() - 1; i >= 0; --i) {
                Point2D.Double l = this.sendBack((BroughtElement)this.broughtElements.elementAt(i), g);
                if (l == null) continue;
                newCameraLocation = l;
            }
        }
        for (i = 0; i < this.elementsToFade.size(); ++i) {
            try {
                Animation a = this.animator.getAnimationFactory().createTranslucencyAnim(300, (Translucent)this.elementsToFade.elementAt(i), this.alphaOfElementsToFade[i], false, IdentityInterpolator.getInstance(), null);
                this.animator.startAnimation(a, true);
                continue;
            }
            catch (ClassCastException e) {
                e.printStackTrace();
            }
        }
        this.elementsToFade.clear();
        if (newCameraLocation != null) {
            Animation a = this.animator.getAnimationFactory().createCameraTranslation(300, this.mainCamera, newCameraLocation, false, SlowInSlowOutInterpolator.getInstance(), null);
            this.animator.startAnimation(a, true);
        }
    }

    void bring(LEdge arc, LNode node, double sx, double sy, double ex, double ey, double size, Hashtable node2broughtPosition) {
        Point2D.Double ep;
        Point2D.Double sp;
        this.broughtElements.add(BroughtElement.rememberPreviousState(node));
        this.broughtElements.add(BroughtElement.rememberPreviousState(arc));
        ClosedShape nodeShape = node.getShape();
        if (size < nodeShape.getSize()) {
            Animation szAnim = this.animator.getAnimationFactory().createGlyphSizeAnim(300, nodeShape, size, false, SlowInSlowOutInterpolator.getInstance(), null);
            this.animator.startAnimation(szAnim, true);
            VText label = node.getLabel();
            if (label != null) {
                label.setScale((float)(size / nodeShape.getSize()));
            }
        }
        this.elementsToFade.remove(nodeShape);
        Point2D.Double bposition = (Point2D.Double)node2broughtPosition.get(node);
        Point2D.Double translation = new Point2D.Double(bposition.x - nodeShape.vx, bposition.y - nodeShape.vy);
        Glyph[] glyphs = node.getGlyphs();
        for (int i = 0; i < glyphs.length; ++i) {
            this.elementsToFade.remove(glyphs[i]);
            Animation posAnim = this.animator.getAnimationFactory().createGlyphTranslation(300, glyphs[i], translation, true, SlowInSlowOutInterpolator.getInstance(), null);
            this.animator.startAnimation(posAnim, true);
        }
        DPath spline = arc.getSpline();
        this.elementsToFade.remove(spline);
        Point2D.Double asp = spline.getStartPoint();
        Point2D.Double aep = spline.getEndPoint();
        if (Math.sqrt((asp.x - ex) * (asp.x - ex) + (asp.y - ey) * (asp.y - ey)) < Math.sqrt((asp.x - sx) * (asp.x - sx) + (asp.y - sy) * (asp.y - sy))) {
            sp = new Point2D.Double(bposition.x, bposition.y);
            ep = new Point2D.Double(sx, sy);
        } else {
            sp = new Point2D.Double(sx, sy);
            ep = new Point2D.Double(bposition.x, bposition.y);
        }
        this.mSpace.above(spline, this.boundingBox);
        Point2D.Double[] flatCoords = DPath.getFlattenedCoordinates(spline, sp, ep, true);
        Animation a = this.animator.getAnimationFactory().createPathAnim(300, spline, flatCoords, false, SlowInSlowOutInterpolator.getInstance(), null);
        this.animator.startAnimation(a, true);
        glyphs = arc.getGlyphs();
        for (int i = 0; i < glyphs.length; ++i) {
            if (glyphs[i] == spline) continue;
            this.elementsToFade.remove(glyphs[i]);
            if (glyphs[i] instanceof VText) {
                a = this.animator.getAnimationFactory().createGlyphTranslation(300, glyphs[i], new Point2D.Double(bposition.x - sx, bposition.y - sy), true, SlowInSlowOutInterpolator.getInstance(), null);
                this.animator.startAnimation(a, true);
                continue;
            }
            glyphs[i].setVisible(false);
        }
        LEdge[] otherArcs = node.getOtherArcs(arc);
        for (int i = 0; i < otherArcs.length; ++i) {
            this.broughtElements.add(BroughtElement.rememberPreviousState(otherArcs[i]));
            spline = otherArcs[i].getSpline();
            this.elementsToFade.remove(spline);
            asp = spline.getStartPoint();
            aep = spline.getEndPoint();
            if (node2broughtPosition.containsKey(otherArcs[i].getTail()) && node2broughtPosition.containsKey(otherArcs[i].getHead())) {
                sp = (Point2D.Double)node2broughtPosition.get(otherArcs[i].getTail());
                ep = (Point2D.Double)node2broughtPosition.get(otherArcs[i].getHead());
            } else {
                ClosedShape oe = otherArcs[i].getOtherEnd(node).getShape();
                if (Math.sqrt((asp.x - ex) * (asp.x - ex) + (asp.y - ey) * (asp.y - ey)) <= Math.sqrt((aep.x - ex) * (aep.x - ex) + (aep.y - ey) * (aep.y - ey))) {
                    sp = new Point2D.Double(bposition.x, bposition.y);
                    ep = oe.getLocation();
                } else {
                    sp = oe.getLocation();
                    ep = new Point2D.Double(bposition.x, bposition.y);
                }
            }
            flatCoords = DPath.getFlattenedCoordinates(spline, sp, ep, true);
            this.mSpace.above(spline, this.boundingBox);
            a = this.animator.getAnimationFactory().createPathAnim(300, spline, flatCoords, false, SlowInSlowOutInterpolator.getInstance(), null);
            this.animator.startAnimation(a, true);
            spline.setTranslucencyValue(0.3f);
        }
    }

    Point2D.Double sendBack(BroughtElement be, Glyph g) {
        this.broughtElements.remove(be);
        return be.restorePreviousState(300, g);
    }

    public boolean isLinkSliding() {
        return this.isLinkSliding;
    }

    public void attemptLinkSliding(double press_vx, double press_vy, int scr_x, int scr_y) {
        double vieww = this.mainView.getVisibleRegionWidth(this.mainCamera);
        this.lsci = 0;
        if (this.lstruct != null) {
            double distance;
            this.closestNode = this.lstruct.nodes[0];
            ClosedShape nodeShape = this.closestNode.getShape();
            double shortestDistance = Math.sqrt((nodeShape.vx - press_vx) * (nodeShape.vx - press_vx) + (nodeShape.vy - press_vy) * (nodeShape.vy - press_vy));
            for (int i = 1; i < this.lstruct.nodes.length; ++i) {
                nodeShape = this.lstruct.nodes[i].getShape();
                distance = Math.sqrt((nodeShape.vx - press_vx) * (nodeShape.vx - press_vx) + (nodeShape.vy - press_vy) * (nodeShape.vy - press_vy));
                if (!(distance < shortestDistance)) continue;
                this.closestNode = this.lstruct.nodes[i];
                shortestDistance = distance;
            }
            if (shortestDistance < 2.0 * this.closestNode.getShape().getSize()) {
                LEdge[] arcs = this.closestNode.getAllArcs();
                if (arcs.length == 0) {
                    return;
                }
                this.lscs = new LinkSliderCalc[arcs.length];
                this.slidingLink = arcs[0].getSpline();
                this.lscs[0] = new LinkSliderCalc(this.slidingLink, vieww);
                this.mPos.setLocation(press_vx, press_vy);
                this.lscs[0].updateMousePosition(this.mPos);
                this.cPos = this.lscs[0].getPositionAlongPath();
                shortestDistance = Math.sqrt((this.cPos.getX() - this.mPos.getX()) * (this.cPos.getX() - this.mPos.getX()) + (this.cPos.getY() - this.mPos.getY()) * (this.cPos.getY() - this.mPos.getY()));
                for (int i = 1; i < arcs.length; ++i) {
                    this.lscs[i] = new LinkSliderCalc(arcs[i].getSpline(), vieww);
                    this.lscs[i].updateMousePosition(this.mPos);
                    this.cPos = this.lscs[i].getPositionAlongPath();
                    distance = Math.sqrt((this.cPos.getX() - this.mPos.getX()) * (this.cPos.getX() - this.mPos.getX()) + (this.cPos.getY() - this.mPos.getY()) * (this.cPos.getY() - this.mPos.getY()));
                    if (!(distance < shortestDistance)) continue;
                    shortestDistance = distance;
                    this.slidingLink = arcs[i].getSpline();
                    this.lsci = i;
                }
                this.startLinkSliding(press_vx, press_vy, scr_x, scr_y);
                return;
            }
        }
        this.closestNode = null;
        Vector<DPath> pum = this.mainView.getCursor().getPicker().getIntersectingPaths(this.mainCamera, 10);
        if (pum.size() > 0) {
            this.slidingLink = pum.firstElement();
            this.lscs = new LinkSliderCalc[1];
            this.lscs[this.lsci] = new LinkSliderCalc(this.slidingLink, vieww);
            this.startLinkSliding(press_vx, press_vy, scr_x, scr_y);
        }
    }

    public void startLinkSliding(final double press_vx, final double press_vy, int px, int py) {
        this.mainView.getCursor().setVisibility(false);
        this.isLinkSliding = true;
        this.screen_cursor_x = px + this.panelWidth / 2;
        this.screen_cursor_y = py + this.panelHeight / 2;
        this.mainView.getPanel().setNoEventCoordinates(this.panelWidth / 2, this.panelHeight / 2);
        try {
            this.awtRobot = new Robot();
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
        this.slidingLinkActualColor = this.slidingLink.getColor();
        this.slidingLink.setColor(ConfigManager.HIGHLIGHT_COLOR);
        this.slideCursor = new SICircle(press_vx, press_vy, 0, 6.0, SLIDER_CURSOR_FILL, ConfigManager.HIGHLIGHT_COLOR);
        this.slideCursor.setStroke(new BasicStroke(2.0f));
        this.mSpace.addGlyph(this.slideCursor);
        if (this.closestNode != null) {
            this.selectionRadius = new SICircle(this.closestNode.getShape().vx, this.closestNode.getShape().vy, 0, 200.0, Color.WHITE, SELECTION_RADIUS_COLOR);
            this.selectionRadius.setFilled(false);
            this.selectionRadius.setStroke(new BasicStroke(2.0f));
            this.mSpace.addGlyph(this.selectionRadius);
        }
        Animation a = this.animator.getAnimationFactory().createCameraTranslation(200, this.mainCamera, new Point2D.Double(press_vx, press_vy), false, SlowInSlowOutInterpolator.getInstance(), new EndAction(){

            public void execute(Object subject, Animation.Dimension dimension) {
                GraphicsManager.this.linkSlider(press_vx, press_vy, true);
            }
        });
        this.animator.startAnimation(a, false);
    }

    public void linkSlider(double vx, double vy, boolean centerCursor) {
        if (this.lscs == null) {
            return;
        }
        boolean withinSelectionRadius = this.mainView.getCursor().getPicker().isPicked(this.selectionRadius);
        this.mPos.setLocation(vx, vy);
        this.lscs[this.lsci].updateMousePosition(this.mPos);
        if (!withinSelectionRadius || centerCursor) {
            this.awtRobot.mouseMove(this.screen_cursor_x, this.screen_cursor_y);
        } else {
            double distance;
            int i;
            this.mtPos.setLocation(vx, vy);
            int newlsci = this.lsci;
            Point2D tPos = this.lscs[this.lsci].getPositionAlongPath();
            double shortestDistance = Math.sqrt((tPos.getX() - this.mtPos.getX()) * (tPos.getX() - this.mtPos.getX()) + (this.cPos.getY() - this.mtPos.getY()) * (this.cPos.getY() - this.mtPos.getY()));
            for (i = 0; i < this.lsci; ++i) {
                this.lscs[i].updateMousePosition(this.mtPos);
                tPos = this.lscs[i].getPositionAlongPath();
                distance = Math.sqrt((tPos.getX() - this.mtPos.getX()) * (tPos.getX() - this.mtPos.getX()) + (this.cPos.getY() - this.mtPos.getY()) * (this.cPos.getY() - this.mtPos.getY()));
                if (!(distance < shortestDistance)) continue;
                shortestDistance = distance;
                newlsci = i;
            }
            for (i = this.lsci + 1; i < this.lscs.length; ++i) {
                this.lscs[i].updateMousePosition(this.mtPos);
                tPos = this.lscs[i].getPositionAlongPath();
                distance = Math.sqrt((tPos.getX() - this.mtPos.getX()) * (tPos.getX() - this.mtPos.getX()) + (this.cPos.getY() - this.mtPos.getY()) * (this.cPos.getY() - this.mtPos.getY()));
                if (!(distance < shortestDistance)) continue;
                shortestDistance = distance;
                newlsci = i;
            }
            if (newlsci != this.lsci) {
                this.slidingLink.setColor(this.slidingLinkActualColor);
                this.lsci = newlsci;
                this.slidingLink = this.lscs[this.lsci].getPath();
                this.slidingLinkActualColor = this.slidingLink.getColor();
                this.slidingLink.setColor(ConfigManager.HIGHLIGHT_COLOR);
            }
        }
        this.cPos = this.lscs[this.lsci].getPositionAlongPath();
        this.slideCursor.moveTo(Math.round(this.cPos.getX()), Math.round(this.cPos.getY()));
        this.mainCamera.moveTo(Math.round(this.cPos.getX()), Math.round(this.cPos.getY()));
    }

    public void endLinkSliding() {
        this.mainView.getPanel().setNoEventCoordinates(-1, -1);
        this.mainView.getCursor().setVisibility(true);
        this.mSpace.removeGlyph(this.slideCursor);
        if (this.selectionRadius != null) {
            this.mSpace.removeGlyph(this.selectionRadius);
            this.selectionRadius = null;
        }
        this.slidingLink.setColor(this.slidingLinkActualColor);
        this.slidingLink = null;
        this.closestNode = null;
        this.isLinkSliding = false;
        this.lscs = null;
        this.lsci = -1;
        this.awtRobot = null;
    }
}

