/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.VPolygon;
import fr.inria.zvtm.glyphs.projection.ProjPolygon;
import java.awt.Color;
import java.awt.geom.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VPolygonOr<T>
extends VPolygon {
    ProjPolygon[] pc;
    double[] oxcoords;
    double[] oycoords;

    public VPolygonOr(Point2D.Double[] v, int z, Color c, double or) {
        this(v, z, c, Color.BLACK, or, 1.0f);
    }

    public VPolygonOr(Point2D.Double[] v, int z, Color c, Color bc, double or) {
        this(v, z, c, bc, or, 1.0f);
    }

    public VPolygonOr(Point2D.Double[] v, int z, Color c, Color bc, double or, float alpha) {
        super(v, z, c, bc, alpha);
        this.oxcoords = new double[this.xcoords.length];
        this.oycoords = new double[this.ycoords.length];
        System.arraycopy(this.xcoords, 0, this.oxcoords, 0, this.xcoords.length);
        System.arraycopy(this.ycoords, 0, this.oycoords, 0, this.ycoords.length);
        this.orientTo(or);
    }

    @Override
    public double getOrient() {
        return this.orient;
    }

    @Override
    public void orientTo(double angle) {
        this.orient = angle;
        for (int i = 0; i < this.xcoords.length; ++i) {
            this.xcoords[i] = this.oxcoords[i] * Math.cos(this.orient) - this.oycoords[i] * Math.sin(this.orient);
            this.ycoords[i] = this.oxcoords[i] * Math.sin(this.orient) + this.oycoords[i] * Math.cos(this.orient);
        }
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public Object clone() {
        Point2D.Double[] lps = new Point2D.Double[this.oxcoords.length];
        for (int i = 0; i < lps.length; ++i) {
            lps[i] = new Point2D.Double(this.oxcoords[i] + this.vx, this.oycoords[i] + this.vy);
        }
        VPolygonOr<T> res = new VPolygonOr<T>(lps, this.getZindex(), this.color, this.borderColor, this.orient, this.alphaC != null ? this.alphaC.getAlpha() : 1.0f);
        res.borderColor = this.borderColor;
        res.cursorInsideColor = this.cursorInsideColor;
        res.bColor = this.bColor;
        return res;
    }
}

