/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.projection.ProjectedCoords;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VPoint<T>
extends Glyph {
    ProjectedCoords[] pc;

    public VPoint() {
        this(0.0, 0.0, 0, Color.BLACK, 1.0f);
    }

    public VPoint(double x, double y, Color c) {
        this(x, y, 0, c, 1.0f);
    }

    public VPoint(double x, double y, int z, Color c) {
        this(x, y, z, c, 1.0f);
    }

    public VPoint(double x, double y, int z, Color c, float alpha) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.size = 1.0;
        this.setColor(c);
        this.setTranslucencyValue(alpha);
    }

    @Override
    public void initCams(int nbCam) {
        this.pc = new ProjectedCoords[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new ProjectedCoords();
        }
    }

    @Override
    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                ProjectedCoords[] ta = this.pc;
                this.pc = new ProjectedCoords[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new ProjectedCoords();
            } else {
                System.err.println("VPoint:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new ProjectedCoords[1];
            this.pc[0] = new ProjectedCoords();
        } else {
            System.err.println("VPoint:Error while adding camera " + verifIndex);
        }
    }

    @Override
    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    @Override
    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    @Override
    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
    }

    @Override
    public void sizeTo(double s) {
    }

    @Override
    public void reSize(double factor) {
    }

    @Override
    public void orientTo(double angle) {
    }

    @Override
    public double getSize() {
        return 1.0;
    }

    @Override
    public double getOrient() {
        return 0.0;
    }

    @Override
    public boolean fillsView(double w, double h, int camIndex) {
        return false;
    }

    @Override
    public boolean coordInside(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        return jpx == this.pc[camIndex].cx && jpy == this.pc[camIndex].cy;
    }

    @Override
    public boolean visibleInDisc(double dvx, double dvy, double dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return Math.sqrt((this.vx - dvx) * (this.vx - dvx) + (this.vy - dvy) * (this.vy - dvy)) <= dvr;
    }

    @Override
    public short mouseInOut(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        if (this.coordInside(jpx, jpy, camIndex, cvx, cvy)) {
            if (!this.pc[camIndex].prevMouseIn) {
                this.pc[camIndex].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[camIndex].prevMouseIn) {
            this.pc[camIndex].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    @Override
    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = (int)Math.round((double)(d.width / 2) + (this.vx - c.vx) * this.coef);
        this.pc[i].cy = (int)Math.round((double)(d.height / 2) - (this.vy - c.vy) * this.coef);
    }

    @Override
    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, double lensx, double lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * (double)lensMag;
        this.pc[i].lcx = (int)Math.round((double)(lensWidth / 2) + (this.vx - lensx) * this.coef);
        this.pc[i].lcy = (int)Math.round((double)(lensHeight / 2) - (this.vy - lensy) * this.coef);
    }

    @Override
    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null) {
            if (this.alphaC.getAlpha() == 0.0f) {
                return;
            }
            g.setColor(this.color);
            g.setComposite(this.alphaC);
            g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
            g.setComposite(acO);
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
        }
    }

    @Override
    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null) {
            if (this.alphaC.getAlpha() == 0.0f) {
                return;
            }
            g.setColor(this.color);
            g.setComposite(this.alphaC);
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
            g.setComposite(acO);
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    @Override
    public Shape getJava2DShape() {
        return new Rectangle2D.Double(this.vx, this.vy, 1.0, 1.0);
    }

    @Override
    public Object clone() {
        VPoint<T> res = new VPoint<T>(this.vx, this.vy, this.vz, this.color, this.alphaC != null ? this.alphaC.getAlpha() : 1.0f);
        res.cursorInsideColor = this.cursorInsideColor;
        return res;
    }

    @Override
    public void highlight(boolean b, Color selectedColor) {
        boolean update = false;
        if (b) {
            if (this.cursorInsideColor != null) {
                this.color = this.cursorInsideColor;
                update = true;
            }
        } else if (this.isSelected() && selectedColor != null) {
            this.color = selectedColor;
            update = true;
        } else if (this.cursorInsideColor != null) {
            this.color = this.fColor;
            update = true;
        }
        if (update) {
            VirtualSpaceManager.INSTANCE.repaint();
        }
    }
}

