/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import com.google.common.base.Objects;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Module;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.concurrent.Future;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.xtext.ide.server.LanguageServerImpl;
import org.eclipse.xtext.ide.server.ServerModule;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ServerLauncher {
    private static boolean IS_DEBUG = false;
    @Inject
    private LanguageServerImpl languageServer;

    public static void main(String[] args) {
        Functions.Function1 _function = it -> Objects.equal((Object)it, (Object)"debug");
        IS_DEBUG = IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)args)), (Functions.Function1)_function);
        InputStream stdin = System.in;
        PrintStream stdout = System.out;
        ServerLauncher.redirectStandardStreams();
        ServerModule _serverModule = new ServerModule();
        ServerLauncher launcher = (ServerLauncher)Guice.createInjector((Module[])new Module[]{_serverModule}).getInstance(ServerLauncher.class);
        launcher.start(stdin, stdout);
    }

    public void start(InputStream in, OutputStream out) {
        try {
            System.err.println("Starting Xtext Language Server.");
            PrintWriter _printWriter = new PrintWriter(System.out);
            Launcher launcher = Launcher.createLauncher((Object)this.languageServer, LanguageClient.class, (InputStream)in, (OutputStream)out, (boolean)true, (PrintWriter)_printWriter);
            this.languageServer.connect((LanguageClient)launcher.getRemoteProxy());
            Future future = launcher.startListening();
            System.err.println("started.");
            while (!future.isDone()) {
                Thread.sleep(10000L);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static void redirectStandardStreams() {
        try {
            byte[] _newByteArrayOfSize = new byte[]{};
            ByteArrayInputStream _byteArrayInputStream = new ByteArrayInputStream(_newByteArrayOfSize);
            System.setIn(_byteArrayInputStream);
            String _name = ServerLauncher.class.getName();
            String _plus = _name + "-";
            long _currentTimeMillis = System.currentTimeMillis();
            Timestamp _timestamp = new Timestamp(_currentTimeMillis);
            String id = (_plus + _timestamp).replace(" ", "_");
            if (IS_DEBUG) {
                FileOutputStream stdFileOut = new FileOutputStream("out-" + id + ".log");
                PrintStream _printStream = new PrintStream(stdFileOut);
                System.setOut(_printStream);
                FileOutputStream stdFileErr = new FileOutputStream("error-" + id + ".log");
                PrintStream _printStream_1 = new PrintStream(stdFileErr);
                System.setErr(_printStream_1);
            } else {
                ByteArrayOutputStream _byteArrayOutputStream = new ByteArrayOutputStream();
                PrintStream _printStream_2 = new PrintStream(_byteArrayOutputStream);
                System.setOut(_printStream_2);
                ByteArrayOutputStream _byteArrayOutputStream_1 = new ByteArrayOutputStream();
                PrintStream _printStream_3 = new PrintStream(_byteArrayOutputStream_1);
                System.setErr(_printStream_3);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

