/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.template.contentassist;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.text.template.contentassist.MultiVariable;
import org.eclipse.jdt.internal.ui.text.template.contentassist.VariablePosition;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class MultiVariableGuess {
    private final Map<MultiVariable, Set<MultiVariable>> fDependencies = new HashMap<MultiVariable, Set<MultiVariable>>();
    private final Map<MultiVariable, MultiVariable> fBackwardDeps = new HashMap<MultiVariable, MultiVariable>();
    private final Map<MultiVariable, VariablePosition> fPositions = new HashMap<MultiVariable, VariablePosition>();

    public ICompletionProposal[] getProposals(final MultiVariable variable, int offset, int length) {
        MultiVariable master = this.fBackwardDeps.get((Object)variable);
        Object[] choices = master == null ? variable.getChoices() : variable.getChoices(master.getCurrentChoice());
        if (choices == null) {
            return null;
        }
        if (this.fDependencies.containsKey((Object)variable)) {
            ICompletionProposal[] ret = new ICompletionProposal[choices.length];
            int i = 0;
            while (i < ret.length) {
                final Object choice = choices[i];
                ret[i] = new Proposal(variable.toString(choice), offset, length, offset + length){

                    @Override
                    public void apply(IDocument document) {
                        super.apply(document);
                        Object oldChoice = variable.getCurrentChoice();
                        variable.setCurrentChoice(choice);
                        MultiVariableGuess.this.updateSlaves(variable, document, oldChoice);
                    }
                };
                ++i;
            }
            return ret;
        }
        if (choices.length < 2) {
            return null;
        }
        ICompletionProposal[] ret = new ICompletionProposal[choices.length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = new Proposal(variable.toString(choices[i]), offset, length, offset + length);
            ++i;
        }
        return ret;
    }

    private void updateSlaves(MultiVariable variable, IDocument document, Object oldChoice) {
        Object choice = variable.getCurrentChoice();
        if (!oldChoice.equals(choice)) {
            Set<MultiVariable> slaves = this.fDependencies.get((Object)variable);
            for (MultiVariable slave : slaves) {
                VariablePosition pos = this.fPositions.get((Object)slave);
                Object slavesOldChoice = slave.getCurrentChoice();
                slave.setKey(choice);
                try {
                    document.replace(pos.getOffset(), pos.getLength(), slave.getDefaultValue());
                }
                catch (BadLocationException badLocationException) {}
                if (!this.fDependencies.containsKey((Object)slave)) continue;
                this.updateSlaves(slave, document, slavesOldChoice);
            }
        }
    }

    public void addSlave(VariablePosition position) {
        this.fPositions.put(position.getVariable(), position);
    }

    public void addDependency(MultiVariable master, MultiVariable slave) {
        if (this.fBackwardDeps.containsKey((Object)slave)) {
            throw new IllegalArgumentException("slave can only serve one master");
        }
        MultiVariable parent = master;
        while (parent != null) {
            if ((parent = this.fBackwardDeps.get((Object)parent)) != slave) continue;
            throw new IllegalArgumentException("cycle detected");
        }
        Set<MultiVariable> slaves = this.fDependencies.get((Object)master);
        if (slaves == null) {
            slaves = new HashSet<MultiVariable>();
            this.fDependencies.put(master, slaves);
        }
        this.fBackwardDeps.put(slave, master);
        slaves.add(slave);
    }

    private static class Proposal
    implements ICompletionProposal,
    ICompletionProposalExtension2 {
        private String fDisplayString;
        String fReplacementString;
        private int fReplacementOffset;
        private int fReplacementLength;
        private int fCursorPosition;
        private Image fImage;
        private IContextInformation fContextInformation;
        private String fAdditionalProposalInfo;

        public Proposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition) {
            this(replacementString, replacementOffset, replacementLength, cursorPosition, null, null, null, null);
        }

        public Proposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
            Assert.isNotNull((Object)replacementString);
            Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
            Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
            Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
            this.fReplacementString = replacementString;
            this.fReplacementOffset = replacementOffset;
            this.fReplacementLength = replacementLength;
            this.fCursorPosition = cursorPosition;
            this.fImage = image;
            this.fDisplayString = displayString;
            this.fContextInformation = contextInformation;
            this.fAdditionalProposalInfo = additionalProposalInfo;
        }

        public void apply(IDocument document) {
            try {
                document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
            }
            catch (BadLocationException badLocationException) {}
        }

        public Point getSelection(IDocument document) {
            return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
        }

        public IContextInformation getContextInformation() {
            return this.fContextInformation;
        }

        public Image getImage() {
            return this.fImage;
        }

        public String getDisplayString() {
            if (this.fDisplayString != null) {
                return this.fDisplayString;
            }
            return this.fReplacementString;
        }

        public String getAdditionalProposalInfo() {
            return this.fAdditionalProposalInfo;
        }

        public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
            this.apply(viewer.getDocument());
        }

        public void selected(ITextViewer viewer, boolean smartToggle) {
        }

        public void unselected(ITextViewer viewer) {
        }

        public boolean validate(IDocument document, int offset, DocumentEvent event) {
            try {
                String content = document.get(this.fReplacementOffset, this.fReplacementLength);
                if (content.startsWith(this.fReplacementString)) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {}
            return false;
        }
    }
}

