/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.dom.VariableDeclarationRewrite;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.LRUMap;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.text.edits.TextEditGroup;

public final class MemberVisibilityAdjustor {
    public static final GroupCategorySet SET_VISIBILITY_ADJUSTMENTS = new GroupCategorySet(new GroupCategory("org.eclipse.jdt.internal.corext.visibilityAdjustments", RefactoringCoreMessages.MemberVisibilityAdjustor_adjustments_name, RefactoringCoreMessages.MemberVisibilityAdjustor_adjustments_description));
    private Map<IMember, IncomingMemberVisibilityAdjustment> fAdjustments = new LinkedHashMap<IMember, IncomingMemberVisibilityAdjustment>();
    private boolean fIncoming = true;
    private boolean fOutgoing = true;
    private final IMember fReferenced;
    private final IJavaElement fReferencing;
    private ASTRewrite fRewrite = null;
    private Map<ICompilationUnit, CompilationUnitRewrite> fRewrites = new HashMap<ICompilationUnit, CompilationUnitRewrite>(3);
    private CompilationUnit fRoot = null;
    private IJavaSearchScope fScope;
    private RefactoringStatus fStatus = new RefactoringStatus();
    private final Map<IType, ITypeHierarchy> fTypeHierarchies = new LRUMap(10);
    private int fVisibilitySeverity = 2;
    private WorkingCopyOwner fOwner = null;

    public static String getLabel(IJavaElement element) {
        Assert.isNotNull((Object)element);
        return JavaElementLabels.getElementLabel(element, JavaElementLabels.ALL_FULLY_QUALIFIED | JavaElementLabels.ALL_DEFAULT);
    }

    public static String getLabel(Modifier.ModifierKeyword keyword) {
        Assert.isTrue((boolean)MemberVisibilityAdjustor.isVisibilityKeyword(keyword));
        if (keyword == null) {
            return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_default;
        }
        if (Modifier.ModifierKeyword.PUBLIC_KEYWORD.equals(keyword)) {
            return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_public;
        }
        if (Modifier.ModifierKeyword.PROTECTED_KEYWORD.equals(keyword)) {
            return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_protected;
        }
        return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_private;
    }

    public static String getMessage(IMember member) {
        Assert.isTrue((member instanceof IType || member instanceof IMethod || member instanceof IField ? 1 : 0) != 0);
        if (member instanceof IType) {
            return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_type_warning;
        }
        if (member instanceof IMethod) {
            return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_method_warning;
        }
        return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_field_warning;
    }

    public static boolean hasLowerVisibility(int modifiers, int threshold) {
        if (Modifier.isPrivate((int)threshold)) {
            return false;
        }
        if (Modifier.isPublic((int)threshold)) {
            return !Modifier.isPublic((int)modifiers);
        }
        if (Modifier.isProtected((int)threshold)) {
            return !Modifier.isProtected((int)modifiers) && !Modifier.isPublic((int)modifiers);
        }
        return Modifier.isPrivate((int)modifiers);
    }

    public static boolean hasLowerVisibility(Modifier.ModifierKeyword keyword, Modifier.ModifierKeyword threshold) {
        Assert.isTrue((boolean)MemberVisibilityAdjustor.isVisibilityKeyword(keyword));
        Assert.isTrue((boolean)MemberVisibilityAdjustor.isVisibilityKeyword(threshold));
        return MemberVisibilityAdjustor.hasLowerVisibility(keyword != null ? keyword.toFlagValue() : 0, threshold != null ? threshold.toFlagValue() : 0);
    }

    private static boolean isStatusSeverity(int severity) {
        return severity == 3 || severity == 4 || severity == 1 || severity == 0 || severity == 2;
    }

    private static boolean isVisibilityKeyword(Modifier.ModifierKeyword keyword) {
        return keyword == null || Modifier.ModifierKeyword.PUBLIC_KEYWORD.equals(keyword) || Modifier.ModifierKeyword.PROTECTED_KEYWORD.equals(keyword) || Modifier.ModifierKeyword.PRIVATE_KEYWORD.equals(keyword);
    }

    private static boolean isVisibilityModifier(int modifier) {
        return modifier == 0 || modifier == 1 || modifier == 4 || modifier == 2;
    }

    private static int keywordToVisibility(Modifier.ModifierKeyword keyword) {
        int visibility = 0;
        if (keyword == Modifier.ModifierKeyword.PUBLIC_KEYWORD) {
            visibility = 1;
        } else if (keyword == Modifier.ModifierKeyword.PRIVATE_KEYWORD) {
            visibility = 2;
        } else if (keyword == Modifier.ModifierKeyword.PROTECTED_KEYWORD) {
            visibility = 4;
        }
        return visibility;
    }

    public static boolean needsVisibilityAdjustments(IMember member, int threshold, Map<IMember, IncomingMemberVisibilityAdjustment> adjustments) {
        Assert.isNotNull((Object)member);
        Assert.isTrue((boolean)MemberVisibilityAdjustor.isVisibilityModifier(threshold));
        Assert.isNotNull(adjustments);
        IncomingMemberVisibilityAdjustment adjustment = adjustments.get(member);
        if (adjustment != null) {
            Modifier.ModifierKeyword keyword = adjustment.getKeyword();
            return MemberVisibilityAdjustor.hasLowerVisibility(keyword == null ? 0 : keyword.toFlagValue(), threshold);
        }
        return true;
    }

    public static boolean needsVisibilityAdjustments(IMember member, Modifier.ModifierKeyword threshold, Map<IMember, IncomingMemberVisibilityAdjustment> adjustments) {
        Assert.isNotNull((Object)member);
        Assert.isNotNull(adjustments);
        IncomingMemberVisibilityAdjustment adjustment = adjustments.get(member);
        if (adjustment != null) {
            return MemberVisibilityAdjustor.hasLowerVisibility(adjustment.getKeyword(), threshold);
        }
        return true;
    }

    public MemberVisibilityAdjustor(IJavaElement referencing, IMember referenced) {
        Assert.isTrue((!(referenced instanceof IInitializer) ? 1 : 0) != 0);
        Assert.isTrue((referencing instanceof ICompilationUnit || referencing instanceof IType || referencing instanceof IPackageFragment ? 1 : 0) != 0);
        this.fScope = RefactoringScopeFactory.createReferencedScope(new IJavaElement[]{referenced}, 11);
        this.fReferencing = referencing;
        this.fReferenced = referenced;
    }

    private void adjustIncomingVisibility(IJavaElement element, IMember referencedMovedElement, IProgressMonitor monitor) throws JavaModelException {
        Modifier.ModifierKeyword threshold = this.getVisibilityThreshold(element, referencedMovedElement, monitor);
        int flags = referencedMovedElement.getFlags();
        IType declaring = referencedMovedElement.getDeclaringType();
        if (declaring != null && declaring.isInterface() || referencedMovedElement instanceof IField && Flags.isEnum((int)referencedMovedElement.getFlags())) {
            return;
        }
        if (MemberVisibilityAdjustor.hasLowerVisibility(flags, threshold == null ? 0 : threshold.toFlagValue()) && this.needsVisibilityAdjustment(referencedMovedElement, threshold)) {
            this.fAdjustments.put(referencedMovedElement, new IncomingMemberVisibilityAdjustment(referencedMovedElement, threshold, RefactoringStatus.createStatus((int)this.fVisibilitySeverity, (String)Messages.format(MemberVisibilityAdjustor.getMessage(referencedMovedElement), new String[]{MemberVisibilityAdjustor.getLabel((IJavaElement)referencedMovedElement), MemberVisibilityAdjustor.getLabel(threshold)}), (RefactoringStatusContext)JavaStatusContext.create(referencedMovedElement), null, (int)-1, null)));
        }
    }

    private void adjustMemberVisibility(IMember member, IProgressMonitor monitor) throws JavaModelException {
        int i;
        if (member instanceof IType) {
            IJavaElement[] typeMembers = ((IType)member).getChildren();
            i = 0;
            while (i < typeMembers.length) {
                if (!(typeMembers[i] instanceof IInitializer)) {
                    this.adjustMemberVisibility((IMember)typeMembers[i], monitor);
                }
                ++i;
            }
        }
        if (member.equals(this.fReferenced) || Modifier.isPublic((int)member.getFlags())) {
            return;
        }
        SearchResultGroup[] references = this.findReferences(member, monitor);
        i = 0;
        while (i < references.length) {
            SearchMatch[] searchResults = references[i].getSearchResults();
            int k = 0;
            while (k < searchResults.length) {
                IJavaElement referenceToMember = (IJavaElement)searchResults[k].getElement();
                if (this.fAdjustments.get(member) == null && referenceToMember instanceof IMember && !this.isInsideMovedMember(referenceToMember)) {
                    this.adjustIncomingVisibility(this.fReferencing, member, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                ++k;
            }
            ++i;
        }
    }

    private boolean isInsideMovedMember(IJavaElement element) {
        IJavaElement current = element;
        while ((current = current.getParent()) != null) {
            if (!current.equals(this.fReferenced)) continue;
            return true;
        }
        return false;
    }

    private SearchResultGroup[] findReferences(IMember member, IProgressMonitor monitor) throws JavaModelException {
        RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(SearchPattern.createPattern((IJavaElement)member, (int)2, (int)24));
        engine.setOwner(this.fOwner);
        engine.setFiltering(true, true);
        engine.setScope(RefactoringScopeFactory.create((IJavaElement)member));
        engine.searchPattern((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        return (SearchResultGroup[])engine.getResults();
    }

    private void adjustIncomingVisibility(SearchResultGroup[] groups, IProgressMonitor monitor) throws JavaModelException {
        try {
            monitor.beginTask("", groups.length);
            monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_checking);
            SearchMatch[] matches = null;
            boolean adjusted = false;
            int index = 0;
            while (index < groups.length) {
                matches = groups[index].getSearchResults();
                int offset = 0;
                while (offset < matches.length) {
                    Object element = matches[offset].getElement();
                    if (element instanceof IMember && !this.isInsideMovedMember((IJavaElement)((IMember)element))) {
                        this.adjustIncomingVisibility(this.fReferencing, this.fReferenced, monitor);
                        adjusted = true;
                        break;
                    }
                    ++offset;
                }
                if (adjusted) {
                    break;
                }
                monitor.worked(1);
                ++index;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void adjustOutgoingVisibility(IField field, Modifier.ModifierKeyword threshold) throws JavaModelException {
        Assert.isTrue((!field.isBinary() && !field.isReadOnly() ? 1 : 0) != 0);
        IType declaring = field.getDeclaringType();
        if (declaring != null && declaring.equals(this.fReferenced)) {
            return;
        }
        if (MemberVisibilityAdjustor.hasLowerVisibility(field.getFlags(), MemberVisibilityAdjustor.keywordToVisibility(threshold)) && this.needsVisibilityAdjustment((IMember)field, threshold)) {
            this.adjustOutgoingVisibility((IMember)field, threshold, RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_field_warning);
        }
    }

    private void adjustOutgoingVisibility(IMember member, Modifier.ModifierKeyword threshold, String template) throws JavaModelException {
        Assert.isTrue((!member.isBinary() && !member.isReadOnly() ? 1 : 0) != 0);
        boolean adjust = true;
        IType declaring = member.getDeclaringType();
        if (declaring != null && (JavaModelUtil.isInterfaceOrAnnotation((IType)declaring) || member instanceof IField && Flags.isEnum((int)member.getFlags()) || declaring.equals(this.fReferenced))) {
            adjust = false;
        }
        if (adjust && MemberVisibilityAdjustor.hasLowerVisibility(member.getFlags(), MemberVisibilityAdjustor.keywordToVisibility(threshold)) && this.needsVisibilityAdjustment(member, threshold)) {
            this.fAdjustments.put(member, new OutgoingMemberVisibilityAdjustment(member, threshold, RefactoringStatus.createStatus((int)this.fVisibilitySeverity, (String)Messages.format(template, new String[]{JavaElementLabels.getTextLabel(member, 1L | JavaElementLabels.ALL_FULLY_QUALIFIED), MemberVisibilityAdjustor.getLabel(threshold)}), (RefactoringStatusContext)JavaStatusContext.create(member), null, (int)-1, null)));
        }
    }

    private void adjustOutgoingVisibility(SearchMatch match, IProgressMonitor monitor) throws JavaModelException {
        IMember member;
        Object element = match.getElement();
        if (element instanceof IMember && !(member = (IMember)element).isBinary() && !member.isReadOnly() && !this.isInsideMovedMember((IJavaElement)member)) {
            this.adjustOutgoingVisibilityChain(member, monitor);
        }
    }

    private void adjustOutgoingVisibilityChain(IMember member, IProgressMonitor monitor) throws JavaModelException {
        if (!Modifier.isPublic((int)member.getFlags())) {
            Modifier.ModifierKeyword threshold = this.computeOutgoingVisibilityThreshold(this.fReferencing, member, monitor);
            if (member instanceof IMethod) {
                this.adjustOutgoingVisibility(member, threshold, RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_method_warning);
            } else if (member instanceof IField) {
                this.adjustOutgoingVisibility((IField)member, threshold);
            } else if (member instanceof IType) {
                this.adjustOutgoingVisibility(member, threshold, RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_type_warning);
            }
        }
        if (member.getDeclaringType() != null) {
            this.adjustOutgoingVisibilityChain((IMember)member.getDeclaringType(), monitor);
        }
    }

    private void adjustOutgoingVisibility(SearchResultGroup[] groups, IProgressMonitor monitor) throws JavaModelException {
        try {
            monitor.beginTask("", groups.length);
            monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_checking);
            IJavaElement element = null;
            SearchMatch[] matches = null;
            SearchResultGroup group = null;
            int index = 0;
            while (index < groups.length) {
                group = groups[index];
                element = JavaCore.create((IResource)group.getResource());
                if (element instanceof ICompilationUnit) {
                    matches = group.getSearchResults();
                    int offset = 0;
                    while (offset < matches.length) {
                        this.adjustOutgoingVisibility(matches[offset], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        ++offset;
                    }
                }
                monitor.worked(1);
                ++index;
            }
        }
        finally {
            monitor.done();
        }
    }

    public final void adjustVisibility(IProgressMonitor monitor) throws JavaModelException {
        try {
            monitor.beginTask("", 7);
            monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_checking);
            RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(SearchPattern.createPattern((IJavaElement)this.fReferenced, (int)2, (int)24));
            engine.setScope(this.fScope);
            engine.setStatus(this.fStatus);
            engine.setOwner(this.fOwner);
            if (this.fIncoming) {
                engine.searchPattern((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.adjustIncomingVisibility((SearchResultGroup[])engine.getResults(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                engine.clearResults();
                if (this.fReferenced instanceof IType) {
                    IType type = (IType)this.fReferenced;
                    this.adjustMemberVisibility((IMember)type, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
            }
            if (this.fOutgoing) {
                engine.searchReferencedTypes((IJavaElement)this.fReferenced, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                engine.searchReferencedFields((IJavaElement)this.fReferenced, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                engine.searchReferencedMethods((IJavaElement)this.fReferenced, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                this.adjustOutgoingVisibility((SearchResultGroup[])engine.getResults(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    public Modifier.ModifierKeyword getVisibilityThreshold(IJavaElement referencing, IMember referenced, IProgressMonitor monitor) throws JavaModelException {
        Modifier.ModifierKeyword keyword;
        block35: {
            Assert.isTrue((!(referencing instanceof IInitializer) ? 1 : 0) != 0);
            Assert.isTrue((!(referenced instanceof IInitializer) ? 1 : 0) != 0);
            keyword = Modifier.ModifierKeyword.PUBLIC_KEYWORD;
            try {
                monitor.beginTask("", 1);
                monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_checking);
                int referencingType = referencing.getElementType();
                int referencedType = referenced.getElementType();
                switch (referencedType) {
                    case 7: {
                        IType typeReferenced = (IType)referenced;
                        ICompilationUnit referencedUnit = typeReferenced.getCompilationUnit();
                        switch (referencingType) {
                            case 7: {
                                keyword = this.thresholdTypeToType((IType)referencing, typeReferenced, monitor);
                                break;
                            }
                            case 8: 
                            case 9: {
                                IMember member = (IMember)referencing;
                                if (typeReferenced.equals(member.getDeclaringType())) {
                                    keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                    break;
                                }
                                if (referencedUnit != null && referencedUnit.equals(member.getCompilationUnit())) {
                                    keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                    break;
                                }
                                if (typeReferenced.getPackageFragment().equals(member.getDeclaringType().getPackageFragment())) {
                                    keyword = null;
                                    break;
                                }
                                break block35;
                            }
                            case 4: {
                                IPackageFragment fragment = (IPackageFragment)referencing;
                                if (typeReferenced.getPackageFragment().equals(fragment)) {
                                    keyword = null;
                                    break;
                                }
                                break block35;
                            }
                            default: {
                                Assert.isTrue((boolean)false);
                                break;
                            }
                        }
                        break;
                    }
                    case 8: {
                        IField fieldReferenced = (IField)referenced;
                        ICompilationUnit referencedUnit = fieldReferenced.getCompilationUnit();
                        switch (referencingType) {
                            case 7: {
                                keyword = this.thresholdTypeToField((IType)referencing, fieldReferenced, monitor);
                                break;
                            }
                            case 8: 
                            case 9: {
                                IMember member = (IMember)referencing;
                                if (fieldReferenced.getDeclaringType().equals(member.getDeclaringType())) {
                                    keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                    break;
                                }
                                if (referencedUnit != null && referencedUnit.equals(member.getCompilationUnit())) {
                                    keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                    break;
                                }
                                if (fieldReferenced.getDeclaringType().getPackageFragment().equals(member.getDeclaringType().getPackageFragment())) {
                                    keyword = null;
                                    break;
                                }
                                break block35;
                            }
                            case 4: {
                                IPackageFragment fragment = (IPackageFragment)referencing;
                                if (fieldReferenced.getDeclaringType().getPackageFragment().equals(fragment)) {
                                    keyword = null;
                                    break;
                                }
                                break block35;
                            }
                            default: {
                                Assert.isTrue((boolean)false);
                                break;
                            }
                        }
                        break;
                    }
                    case 9: {
                        IMethod methodReferenced = (IMethod)referenced;
                        ICompilationUnit referencedUnit = methodReferenced.getCompilationUnit();
                        switch (referencingType) {
                            case 7: {
                                keyword = this.thresholdTypeToMethod((IType)referencing, methodReferenced, monitor);
                                break;
                            }
                            case 8: 
                            case 9: {
                                IMember member = (IMember)referencing;
                                if (methodReferenced.getDeclaringType().equals(member.getDeclaringType())) {
                                    keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                    break;
                                }
                                if (referencedUnit != null && referencedUnit.equals(member.getCompilationUnit())) {
                                    keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                    break;
                                }
                                if (methodReferenced.getDeclaringType().getPackageFragment().equals(member.getDeclaringType().getPackageFragment())) {
                                    keyword = null;
                                    break;
                                }
                                break block35;
                            }
                            case 4: {
                                IPackageFragment fragment = (IPackageFragment)referencing;
                                if (methodReferenced.getDeclaringType().getPackageFragment().equals(fragment)) {
                                    keyword = null;
                                    break;
                                }
                                break block35;
                            }
                            default: {
                                Assert.isTrue((boolean)false);
                                break;
                            }
                        }
                        break;
                    }
                    default: {
                        Assert.isTrue((boolean)false);
                        break;
                    }
                }
            }
            finally {
                monitor.done();
            }
        }
        return keyword;
    }

    private Modifier.ModifierKeyword computeOutgoingVisibilityThreshold(IJavaElement referencing, IMember referenced, IProgressMonitor monitor) throws JavaModelException {
        Modifier.ModifierKeyword keyword;
        block32: {
            Assert.isTrue((referencing instanceof ICompilationUnit || referencing instanceof IType || referencing instanceof IPackageFragment ? 1 : 0) != 0);
            Assert.isTrue((referenced instanceof IType || referenced instanceof IField || referenced instanceof IMethod ? 1 : 0) != 0);
            keyword = Modifier.ModifierKeyword.PUBLIC_KEYWORD;
            try {
                monitor.beginTask("", 1);
                monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_checking);
                int referencingType = referencing.getElementType();
                int referencedType = referenced.getElementType();
                switch (referencedType) {
                    case 7: {
                        IType typeReferenced = (IType)referenced;
                        switch (referencingType) {
                            case 5: {
                                ICompilationUnit unit = (ICompilationUnit)referencing;
                                ICompilationUnit referencedUnit = typeReferenced.getCompilationUnit();
                                if (referencedUnit != null && referencedUnit.equals(unit)) {
                                    keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                    break;
                                }
                                if (referencedUnit != null && referencedUnit.getParent().equals(unit.getParent())) {
                                    keyword = null;
                                    break;
                                }
                                break block32;
                            }
                            case 7: {
                                keyword = this.thresholdTypeToType((IType)referencing, typeReferenced, monitor);
                                break;
                            }
                            case 4: {
                                IPackageFragment fragment = (IPackageFragment)referencing;
                                if (typeReferenced.getPackageFragment().equals(fragment)) {
                                    keyword = null;
                                    break;
                                }
                                break block32;
                            }
                            default: {
                                Assert.isTrue((boolean)false);
                                break;
                            }
                        }
                        break;
                    }
                    case 8: {
                        IField fieldReferenced = (IField)referenced;
                        ICompilationUnit referencedUnit = fieldReferenced.getCompilationUnit();
                        switch (referencingType) {
                            case 5: {
                                ICompilationUnit unit = (ICompilationUnit)referencing;
                                if (referencedUnit != null && referencedUnit.equals(unit)) {
                                    keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                    break;
                                }
                                if (referencedUnit != null && referencedUnit.getParent().equals(unit.getParent())) {
                                    keyword = null;
                                    break;
                                }
                                break block32;
                            }
                            case 7: {
                                keyword = this.thresholdTypeToField((IType)referencing, fieldReferenced, monitor);
                                break;
                            }
                            case 4: {
                                IPackageFragment fragment = (IPackageFragment)referencing;
                                if (fieldReferenced.getDeclaringType().getPackageFragment().equals(fragment)) {
                                    keyword = null;
                                    break;
                                }
                                break block32;
                            }
                            default: {
                                Assert.isTrue((boolean)false);
                                break;
                            }
                        }
                        break;
                    }
                    case 9: {
                        IMethod methodReferenced = (IMethod)referenced;
                        ICompilationUnit referencedUnit = methodReferenced.getCompilationUnit();
                        switch (referencingType) {
                            case 5: {
                                ICompilationUnit unit = (ICompilationUnit)referencing;
                                if (referencedUnit != null && referencedUnit.equals(unit)) {
                                    keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                    break;
                                }
                                if (referencedUnit != null && referencedUnit.getParent().equals(unit.getParent())) {
                                    keyword = null;
                                    break;
                                }
                                break block32;
                            }
                            case 7: {
                                keyword = this.thresholdTypeToMethod((IType)referencing, methodReferenced, monitor);
                                break;
                            }
                            case 4: {
                                IPackageFragment fragment = (IPackageFragment)referencing;
                                if (methodReferenced.getDeclaringType().getPackageFragment().equals(fragment)) {
                                    keyword = null;
                                    break;
                                }
                                break block32;
                            }
                            default: {
                                Assert.isTrue((boolean)false);
                                break;
                            }
                        }
                        break;
                    }
                    default: {
                        Assert.isTrue((boolean)false);
                        break;
                    }
                }
            }
            finally {
                monitor.done();
            }
        }
        return keyword;
    }

    public final Map<IMember, IncomingMemberVisibilityAdjustment> getAdjustments() {
        return this.fAdjustments;
    }

    private CompilationUnitRewrite getCompilationUnitRewrite(ICompilationUnit unit) {
        CompilationUnitRewrite rewrite = this.fRewrites.get(unit);
        if (rewrite == null) {
            rewrite = this.fOwner == null ? new CompilationUnitRewrite(unit) : new CompilationUnitRewrite(this.fOwner, unit);
            this.fRewrites.put(unit, rewrite);
        }
        return rewrite;
    }

    private ITypeHierarchy getTypeHierarchy(IType type, IProgressMonitor monitor) throws JavaModelException {
        ITypeHierarchy hierarchy = null;
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_checking);
            try {
                hierarchy = this.fTypeHierarchies.get(type);
                if (hierarchy == null) {
                    hierarchy = this.fOwner == null ? type.newSupertypeHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)) : type.newSupertypeHierarchy(this.fOwner, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                    this.fTypeHierarchies.put(type, hierarchy);
                }
            }
            finally {
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return hierarchy;
    }

    private boolean needsVisibilityAdjustment(IMember member, Modifier.ModifierKeyword threshold) {
        Assert.isNotNull((Object)member);
        return MemberVisibilityAdjustor.needsVisibilityAdjustments(member, threshold, this.fAdjustments);
    }

    public final void rewriteVisibility(ICompilationUnit unit, IProgressMonitor monitor) throws JavaModelException {
        try {
            monitor.beginTask("", this.fAdjustments.keySet().size());
            monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_adjusting);
            IMember member2 = null;
            IVisibilityAdjustment adjustment = null;
            for (IMember member2 : this.fAdjustments.keySet()) {
                if (!unit.equals(member2.getCompilationUnit()) || (adjustment = (IVisibilityAdjustment)this.fAdjustments.get(member2)) == null) continue;
                adjustment.rewriteVisibility(this, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            this.fTypeHierarchies.clear();
            monitor.done();
        }
    }

    public final void rewriteVisibility(IProgressMonitor monitor) throws JavaModelException {
        try {
            monitor.beginTask("", this.fAdjustments.keySet().size());
            monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_adjusting);
            IMember member2 = null;
            IVisibilityAdjustment adjustment = null;
            for (IMember member2 : this.fAdjustments.keySet()) {
                adjustment = this.fAdjustments.get(member2);
                if (adjustment != null) {
                    adjustment.rewriteVisibility(this, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                if (!monitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
        }
        finally {
            this.fTypeHierarchies.clear();
            monitor.done();
        }
    }

    public final void setAdjustments(Map<IMember, IncomingMemberVisibilityAdjustment> adjustments) {
        Assert.isNotNull(adjustments);
        this.fAdjustments = adjustments;
    }

    public final void setFailureSeverity(int severity) {
        Assert.isTrue((boolean)MemberVisibilityAdjustor.isStatusSeverity(severity));
    }

    public final void setIncoming(boolean incoming) {
        this.fIncoming = incoming;
    }

    public final void setOutgoing(boolean outgoing) {
        this.fOutgoing = outgoing;
    }

    public final void setRewrite(ASTRewrite rewrite, CompilationUnit root) {
        Assert.isTrue((rewrite == null || root != null ? 1 : 0) != 0);
        this.fRewrite = rewrite;
        this.fRoot = root;
    }

    public final void setRewrites(Map<ICompilationUnit, CompilationUnitRewrite> rewrites) {
        Assert.isNotNull(rewrites);
        this.fRewrites = rewrites;
    }

    public final void setScope(IJavaSearchScope scope) {
        Assert.isNotNull((Object)scope);
        this.fScope = scope;
    }

    public final void setOwner(WorkingCopyOwner owner) {
        this.fOwner = owner;
    }

    public final void setStatus(RefactoringStatus status) {
        Assert.isNotNull((Object)status);
        this.fStatus = status;
    }

    public final void setVisibilitySeverity(int severity) {
        Assert.isTrue((boolean)MemberVisibilityAdjustor.isStatusSeverity(severity));
        this.fVisibilitySeverity = severity;
    }

    private Modifier.ModifierKeyword thresholdTypeToField(IType referencing, IField referenced, IProgressMonitor monitor) throws JavaModelException {
        Modifier.ModifierKeyword keyword = Modifier.ModifierKeyword.PUBLIC_KEYWORD;
        ICompilationUnit referencedUnit = referenced.getCompilationUnit();
        if (referenced.getDeclaringType().equals(referencing)) {
            keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
        } else {
            ITypeHierarchy hierarchy = this.getTypeHierarchy(referencing, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IType[] types = hierarchy.getSupertypes(referencing);
            IType superType = null;
            int index = 0;
            while (index < types.length) {
                superType = types[index];
                if (superType.equals(referenced.getDeclaringType())) {
                    keyword = Modifier.ModifierKeyword.PROTECTED_KEYWORD;
                    return keyword;
                }
                ++index;
            }
        }
        ICompilationUnit typeUnit = referencing.getCompilationUnit();
        if (referencedUnit != null && referencedUnit.equals(typeUnit)) {
            keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
        } else if (referencedUnit != null && typeUnit != null && referencedUnit.getParent().equals(typeUnit.getParent())) {
            keyword = null;
        }
        return keyword;
    }

    private Modifier.ModifierKeyword thresholdTypeToMethod(IType referencing, IMethod referenced, IProgressMonitor monitor) throws JavaModelException {
        ICompilationUnit referencedUnit = referenced.getCompilationUnit();
        Object keyword = Modifier.ModifierKeyword.PUBLIC_KEYWORD;
        if (referenced.getDeclaringType().equals(referencing)) {
            keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
        } else {
            ITypeHierarchy hierarchy = this.getTypeHierarchy(referencing, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IType[] types = hierarchy.getSupertypes(referencing);
            IType superType = null;
            int index = 0;
            while (index < types.length) {
                superType = types[index];
                if (superType.equals(referenced.getDeclaringType())) {
                    keyword = Modifier.ModifierKeyword.PROTECTED_KEYWORD;
                    return keyword;
                }
                ++index;
            }
        }
        ICompilationUnit typeUnit = referencing.getCompilationUnit();
        if (referencedUnit != null && referencedUnit.equals(typeUnit)) {
            keyword = referenced.getDeclaringType().getDeclaringType() != null ? null : Modifier.ModifierKeyword.PRIVATE_KEYWORD;
        } else if (referencedUnit != null && referencedUnit.getParent().equals(typeUnit.getParent())) {
            keyword = null;
        }
        return keyword;
    }

    private Modifier.ModifierKeyword thresholdTypeToType(IType referencing, IType referenced, IProgressMonitor monitor) throws JavaModelException {
        Object keyword = Modifier.ModifierKeyword.PUBLIC_KEYWORD;
        ICompilationUnit referencedUnit = referenced.getCompilationUnit();
        if (referencing.equals(referenced.getDeclaringType())) {
            keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
        } else {
            ITypeHierarchy hierarchy = this.getTypeHierarchy(referencing, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IType[] types = hierarchy.getSupertypes(referencing);
            IType superType = null;
            int index = 0;
            while (index < types.length) {
                superType = types[index];
                if (superType.equals(referenced)) {
                    keyword = null;
                    return keyword;
                }
                ++index;
            }
        }
        ICompilationUnit typeUnit = referencing.getCompilationUnit();
        if (referencedUnit != null && referencedUnit.equals(typeUnit)) {
            keyword = referenced.getDeclaringType() != null ? null : Modifier.ModifierKeyword.PRIVATE_KEYWORD;
        } else if (referencedUnit != null && typeUnit != null && referencedUnit.getParent().equals(typeUnit.getParent())) {
            keyword = null;
        }
        return keyword;
    }

    public static interface IVisibilityAdjustment {
        public void rewriteVisibility(MemberVisibilityAdjustor var1, IProgressMonitor var2) throws JavaModelException;
    }

    public static class IncomingMemberVisibilityAdjustment
    implements IVisibilityAdjustment {
        protected final Modifier.ModifierKeyword fKeyword;
        protected final IMember fMember;
        protected boolean fNeedsRewriting = true;
        protected final RefactoringStatus fRefactoringStatus;

        public IncomingMemberVisibilityAdjustment(IMember member, Modifier.ModifierKeyword keyword, RefactoringStatus status) {
            Assert.isNotNull((Object)member);
            Assert.isTrue((!(member instanceof IInitializer) ? 1 : 0) != 0);
            Assert.isTrue((boolean)MemberVisibilityAdjustor.isVisibilityKeyword(keyword));
            this.fMember = member;
            this.fKeyword = keyword;
            this.fRefactoringStatus = status;
        }

        public final Modifier.ModifierKeyword getKeyword() {
            return this.fKeyword;
        }

        public final IMember getMember() {
            return this.fMember;
        }

        public final RefactoringStatus getStatus() {
            return this.fRefactoringStatus;
        }

        public final boolean needsRewriting() {
            return this.fNeedsRewriting;
        }

        protected final void rewriteVisibility(MemberVisibilityAdjustor adjustor, ASTRewrite rewrite, CompilationUnit root, CategorizedTextEditGroup group, RefactoringStatus status) throws JavaModelException {
            BodyDeclaration declaration;
            int visibility;
            Assert.isNotNull((Object)adjustor);
            Assert.isNotNull((Object)rewrite);
            Assert.isNotNull((Object)root);
            int n = visibility = this.fKeyword != null ? this.fKeyword.toFlagValue() : 0;
            if (this.fMember instanceof IField && !Flags.isEnum((int)this.fMember.getFlags())) {
                VariableDeclarationFragment fragment = ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)this.fMember, root);
                FieldDeclaration declaration2 = (FieldDeclaration)fragment.getParent();
                VariableDeclarationFragment[] fragmentsToChange = new VariableDeclarationFragment[]{fragment};
                VariableDeclarationRewrite.rewriteModifiers(declaration2, fragmentsToChange, visibility, 7, rewrite, (TextEditGroup)group);
                if (status != null) {
                    adjustor.fStatus.merge(status);
                }
            } else if (this.fMember != null && (declaration = ASTNodeSearchUtil.getBodyDeclarationNode(this.fMember, root)) != null) {
                ModifierRewrite.create(rewrite, (ASTNode)declaration).setVisibility(visibility, (TextEditGroup)group);
                if (status != null) {
                    adjustor.fStatus.merge(status);
                }
            }
        }

        @Override
        public void rewriteVisibility(MemberVisibilityAdjustor adjustor, IProgressMonitor monitor) throws JavaModelException {
            Assert.isNotNull((Object)adjustor);
            Assert.isNotNull((Object)monitor);
            try {
                monitor.beginTask("", 1);
                monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_adjusting);
                if (this.fNeedsRewriting) {
                    if (adjustor.fRewrite != null && adjustor.fRoot != null) {
                        this.rewriteVisibility(adjustor, adjustor.fRewrite, adjustor.fRoot, null, this.fRefactoringStatus);
                    } else {
                        CompilationUnitRewrite rewrite = adjustor.getCompilationUnitRewrite(this.fMember.getCompilationUnit());
                        this.rewriteVisibility(adjustor, rewrite.getASTRewrite(), rewrite.getRoot(), rewrite.createCategorizedGroupDescription(Messages.format(RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility, MemberVisibilityAdjustor.getLabel(this.getKeyword())), SET_VISIBILITY_ADJUSTMENTS), this.fRefactoringStatus);
                    }
                } else if (this.fRefactoringStatus != null) {
                    adjustor.fStatus.merge(this.fRefactoringStatus);
                }
                monitor.worked(1);
            }
            finally {
                monitor.done();
            }
        }

        public final void setNeedsRewriting(boolean rewriting) {
            this.fNeedsRewriting = rewriting;
        }
    }

    public static class OutgoingMemberVisibilityAdjustment
    extends IncomingMemberVisibilityAdjustment {
        public OutgoingMemberVisibilityAdjustment(IMember member, Modifier.ModifierKeyword keyword, RefactoringStatus status) {
            super(member, keyword, status);
        }

        @Override
        public void rewriteVisibility(MemberVisibilityAdjustor adjustor, IProgressMonitor monitor) throws JavaModelException {
            Assert.isNotNull((Object)adjustor);
            Assert.isNotNull((Object)monitor);
            try {
                monitor.beginTask("", 1);
                monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_adjusting);
                if (this.fNeedsRewriting) {
                    CompilationUnitRewrite rewrite = adjustor.getCompilationUnitRewrite(this.fMember.getCompilationUnit());
                    this.rewriteVisibility(adjustor, rewrite.getASTRewrite(), rewrite.getRoot(), rewrite.createCategorizedGroupDescription(Messages.format(RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility, MemberVisibilityAdjustor.getLabel(this.getKeyword())), SET_VISIBILITY_ADJUSTMENTS), this.fRefactoringStatus);
                }
                monitor.worked(1);
            }
            finally {
                monitor.done();
            }
        }
    }
}

