/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.services.servlet.proxy;

import eglx.http.HttpUtilities;
import eglx.http.Request;
import eglx.http.Response;
import eglx.json.JsonUtilities;
import eglx.lang.EDictionary;
import eglx.lang.InvocationException;
import eglx.services.ServiceInvocationException;
import eglx.services.ServiceKind;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.Runtime;
import org.eclipse.edt.javart.resources.Trace;
import org.eclipse.edt.javart.services.ServiceUtilities;

public class HttpServiceHandler {
    private static final String SESSION_ID = "JSESSIONID";
    private static final String EGL_SESSION_ID = "egl_statefulsessionid";
    private static final String RESPONSE_CHARSET = "edt.service.response.charset";
    private static final String COOKIE_ID = "SET-COOKIE";

    HttpServiceHandler() {
    }

    Response invokeRestService(Request request, HttpURLConnection connection) throws Throwable {
        Response response;
        EDictionary headers = request.headers;
        try {
            response = new Response();
            try {
                connection.setRequestMethod(HttpUtilities.httpMethodToString(request.method));
                Trace tracer = Runtime.getRunUnit().getTrace();
                if (tracer.traceIsOn(1)) {
                    tracer.put("REST request URL:" + request.uri);
                }
                String contentType = null;
                String responseCharset = null;
                int timeout = 0;
                for (Map.Entry entry : headers.entrySet()) {
                    Object entryValue = entry.getValue();
                    if (entryValue instanceof AnyBoxedObject) {
                        entryValue = ((AnyBoxedObject)entryValue).ezeUnbox();
                    }
                    if (((String)entry.getKey()).equalsIgnoreCase("Content-Type")) {
                        contentType = entryValue.toString();
                    } else if (((String)entry.getKey()).equalsIgnoreCase(RESPONSE_CHARSET)) {
                        responseCharset = entryValue.toString();
                        entryValue = null;
                    } else if (((String)entry.getKey()).equalsIgnoreCase("edt.proxy.invocation.timeout")) {
                        try {
                            timeout = Integer.parseInt(entryValue.toString());
                        }
                        catch (Exception exception) {}
                        entryValue = null;
                    }
                    if (entryValue == null) continue;
                    connection.setRequestProperty((String)entry.getKey(), entryValue.toString());
                }
                if (timeout > 0) {
                    connection.setReadTimeout(timeout * 1000);
                    if (connection.getReadTimeout() != timeout * 1000) {
                        InvocationException ix = new InvocationException();
                        throw ix.fillInMessage("EGL0033E", new Object[0]);
                    }
                }
                String charset = this.getCharSet(contentType);
                byte[] resource = request.body == null ? new byte[]{} : request.body.getBytes(charset == null ? ServiceUtilities.UTF8 : charset);
                connection.setDoInput(true);
                connection.setUseCaches(false);
                long startTime = System.currentTimeMillis();
                if (resource != null && resource.length > 0) {
                    connection.setDoOutput(true);
                    DataOutputStream os = new DataOutputStream(connection.getOutputStream());
                    os.write(resource, 0, resource.length);
                    os.flush();
                    os.close();
                }
                response.body = this.readConnection(connection, responseCharset == null ? ServiceUtilities.UTF8 : responseCharset, request.uri);
                if (tracer.traceIsOn(1)) {
                    tracer.put("Service response time:" + String.valueOf(System.currentTimeMillis() - startTime));
                }
                response.status = connection.getResponseCode();
                response.statusMessage = connection.getResponseMessage();
                Map<String, List<String>> header = connection.getHeaderFields();
                if (header != null) {
                    this.populate(response, header);
                    this.setServiceSessionId(response, header, headers.get((Object)EGL_SESSION_ID));
                }
            }
            catch (Exception e) {
                block33: {
                    boolean useConnection = false;
                    try {
                        useConnection = connection != null && connection.getResponseCode() != -1;
                    }
                    catch (Throwable throwable) {}
                    if (useConnection) {
                        try {
                            response.status = connection.getResponseCode();
                            response.statusMessage = connection.getResponseMessage();
                            String eglException = connection.getHeaderField(JsonUtilities.JSON_RPC_ERROR_NAME_VALUE);
                            if (eglException == null) break block33;
                            try {
                                response.body = eglException = URLDecoder.decode(eglException, ServiceUtilities.UTF8);
                            }
                            catch (Exception exception) {
                            }
                        }
                        catch (IOException iOException) {
                            response.status = 500;
                            response.statusMessage = "FAILED";
                        }
                    } else {
                        response.status = 500;
                        response.statusMessage = "FAILED";
                    }
                }
                if (e instanceof ServiceInvocationException) {
                    response.body = JsonUtilities.createJsonAnyException((ServiceInvocationException)((Object)e));
                }
                if (e instanceof SocketTimeoutException) {
                    connection.disconnect();
                    connection = null;
                    response.body = JsonUtilities.createJsonAnyException(ServiceUtilities.buildServiceInvocationException("EGL0037E", new String[]{request.uri}, null, ServiceKind.REST));
                }
                if (response.body == null || response.body.isEmpty()) {
                    response.body = JsonUtilities.createJsonAnyException(ServiceUtilities.buildServiceInvocationException("EGL0022E", new String[]{request.uri}, e, ServiceKind.REST));
                }
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return response;
    }

    private String readConnection(HttpURLConnection connection, String responseCharset, String uri) throws IOException {
        String string;
        InputStream is;
        block13: {
            is = null;
            try {
                is = connection.getInputStream();
                string = this.readStream(is, connection, responseCharset, uri);
                if (is == null) break block13;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    is.close();
                }
                try {
                    is = connection.getErrorStream();
                    if (is != null) {
                        throw ServiceUtilities.buildInvocationException("EGL0022E", new String[]{uri}, String.valueOf(connection.getResponseCode()), connection.getResponseMessage(), this.readStream(is, connection, responseCharset, uri), null, ServiceKind.REST);
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
                throw throwable;
            }
            is.close();
        }
        try {
            is = connection.getErrorStream();
            if (is != null) {
                throw ServiceUtilities.buildInvocationException("EGL0022E", new String[]{uri}, String.valueOf(connection.getResponseCode()), connection.getResponseMessage(), this.readStream(is, connection, responseCharset, uri), null, ServiceKind.REST);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return string;
    }

    private String readStream(InputStream is, HttpURLConnection connection, String responseCharset, String uri) throws IOException, UnsupportedEncodingException {
        StringBuilder body = new StringBuilder();
        BufferedReader reader = null;
        try {
            try {
                if (responseCharset == null) {
                    responseCharset = this.getCharSet(connection.getContentType());
                }
                reader = new BufferedReader(new InputStreamReader(is, responseCharset));
            }
            catch (Throwable throwable) {}
            if (reader == null) {
                reader = new BufferedReader(new InputStreamReader(is, ServiceUtilities.UTF8));
            }
            int charCnt = 0;
            int nRead = reader.read();
            while (charCnt < Integer.MAX_VALUE && nRead != -1) {
                body.append((char)nRead);
                nRead = reader.read();
                ++charCnt;
            }
        }
        catch (Throwable throwable) {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
                reader = null;
            }
            throw throwable;
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
            reader = null;
        }
        return body.toString();
    }

    private void populate(Response response, Map<String, List<String>> header) {
        for (Map.Entry<String, List<String>> entry : header.entrySet()) {
            response.addHeader(entry.getKey(), entry.getValue());
        }
    }

    private void setServiceSessionId(Response response, Map<String, List<String>> header, Object sessionKey) {
        if (sessionKey == null || sessionKey instanceof String && ((String)sessionKey).length() == 0) {
            sessionKey = SESSION_ID;
        }
        for (Map.Entry<String, List<String>> entry : header.entrySet()) {
            String sessionId;
            if (!(entry.getKey() instanceof String) || !entry.getKey().equalsIgnoreCase(COOKIE_ID) || (sessionId = this.getSessionId(entry.getValue(), sessionKey.toString())) == null) continue;
            response.addHeader(EGL_SESSION_ID, sessionId);
            break;
        }
    }

    private String getSessionId(Object value, String sessionKey) {
        String str;
        block3: {
            block4: {
                str = null;
                if (!(value instanceof Collection)) break block4;
                Iterator itr = ((Collection)value).iterator();
                while (itr.hasNext()) {
                    str = this.getSessionId(itr.next(), sessionKey);
                    if (str == null) {
                        continue;
                    }
                    break block3;
                }
                break block3;
            }
            if (!(value instanceof String) || ((String)value).indexOf(sessionKey) <= -1) break block3;
            StringTokenizer subStrings = new StringTokenizer((String)value, ";");
            while (subStrings.hasMoreElements()) {
                String id = subStrings.nextToken();
                if (id.indexOf(sessionKey) <= -1) continue;
                str = (String)value;
                break;
            }
        }
        return str;
    }

    private String getCharSet(String contentType) {
        int idx;
        if (contentType != null && (idx = contentType.toLowerCase().indexOf("charset=")) != -1) {
            return contentType.substring(idx + 8);
        }
        return null;
    }
}

