/*
 * Decompiled with CFR 0.152.
 */
package eglx.http;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletContext {
    private HttpServletRequest httpServletReq;
    private HttpServletResponse httpServletRes;
    private static ThreadLocal<ServletContext> threadContexts;

    public ServletContext(HttpServletRequest httpServletReq, HttpServletResponse httpServletRes) {
        this.httpServletReq = httpServletReq;
        this.httpServletRes = httpServletRes;
    }

    public static void setThreadRunUnit(ServletContext context) {
        if (threadContexts == null) {
            threadContexts = new ThreadLocal();
        }
        threadContexts.set(context);
    }

    public HttpServletRequest getHttpServletReq() {
        return this.httpServletReq;
    }

    public HttpServletResponse getHttpServletRes() {
        return this.httpServletRes;
    }

    public static HttpServletRequest getHttpServletRequest() {
        if (threadContexts != null && threadContexts.get() != null) {
            return threadContexts.get().getHttpServletReq();
        }
        return null;
    }

    public static HttpServletResponse getHttpServletResponse() {
        if (threadContexts != null && threadContexts.get() != null) {
            return threadContexts.get().getHttpServletRes();
        }
        return null;
    }
}

