package org.eclipse.ebpm.connectors.http.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;

import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.resource.Resource;

public class SpagicHttpWithSSLClient extends HttpClient {
	
	protected SslBean sslBean = null;
	
	public SpagicHttpWithSSLClient(SslBean sslbean){
		super();
		this.sslBean = sslbean;
		//this.setKeyStoreLocation(sslBean.getKeyStore());
	}
	
	protected SSLContext getStrictSSLContext() throws IOException {

        try {
            if (sslBean.getTrustStore() == null) {
            	throw new Exception("Error generating ssl context missing TrustStore!");
//                sslBean.setTrustStore(sslBean.getKeyStore());
//                sslBean.setTrustStoreType(sslBean.getKeyStoreType());
            }

            KeyManager[] keyManagers = null;

            if(sslBean.isNeedClientAuth()){
            	InputStream keystoreInputStream = Resource.newResource(getKeyStoreLocation()).getInputStream();
	            KeyStore keyStore = KeyStore.getInstance(sslBean.getKeyStoreType());
	            keyStore.load(keystoreInputStream,sslBean.getKeyStorePassword()==null?null:sslBean.getKeyStorePassword().toString().toCharArray());
	
	            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(sslBean.getKeyManagerFactoryAlgorithm());
	            if(sslBean.getKeyPassword()!=null){
	            	keyManagerFactory.init(keyStore,sslBean.getKeyPassword().toString().toCharArray());
	            	keyManagers = keyManagerFactory.getKeyManagers();
	            }
            }

            InputStream truststoreInputStream = Resource.newResource(sslBean.getTrustStore()).getInputStream();
            KeyStore trustStore = KeyStore.getInstance(sslBean.getTrustStoreType());
            trustStore.load(truststoreInputStream,sslBean.getTrustStorePassword()==null?null:sslBean.getTrustStorePassword().toString().toCharArray());

            TrustManagerFactory trustManagerFactory=TrustManagerFactory.getInstance(sslBean.getTrustManagerFactoryAlgorithm());
            trustManagerFactory.init(trustStore);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();

            SSLContext context = sslBean.getProvider() == null 
            		? SSLContext.getInstance(sslBean.getProtocol()) 
            	    : SSLContext.getInstance(sslBean.getProtocol(), sslBean.getProvider());
            
            context.init(keyManagers, trustManagers, new SecureRandom());
            return context;
        }
        catch ( Exception e )
        {
            throw new IOException( "error generating ssl context for " + getKeyStoreLocation()  + " " + e.getMessage() );
        }
    }
}
