/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * 			Andrea Zoppello (Engineering Group) - initial API and implementation and/or initial documentation
 * 			Gianfranco Boccalon (Engineering Group) - initial API and implementation and/or initial documentation
 *          Luca Rossato ( Engineering Group ) - initial API and implementation and/or initial documentation
 *          Luca Barozzi ( Engineering Group ) - initial API and implementation and/or initial documentation
 *  		Antonietta Miele ( Engineering Group ) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebpm.connectors.http.servlet;

import java.io.IOException;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.eclipse.ebpm.connectors.http.HTTPServer;

public class SpagicServlet extends HttpServlet{

	/**
	 * 
	 */
	private static final long serialVersionUID = 3374855162684311551L;

	private HTTPServer spagicService = null;
	
	public SpagicServlet(HTTPServer spagicService) {
		super();
		this.spagicService = spagicService;
	}

	public void init(ServletConfig config) throws ServletException {
		super.init(config);
		if (spagicService == null) {			
			spagicService = (HTTPServer) getServletContext().getAttribute("spagicService");
			if (spagicService == null) {
				throw new ServletException("Spagic Service Not Bound");
			}			
		}
	}

	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		try {
			spagicService.processHttp(request, response);
		}catch (IOException e) {
			throw e;
		}catch (RuntimeException e) {
			throw e;
		}catch (Exception e) {
			throw new ServletException("Failed to process request: " + e, e);
		}
	}

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		try {
			spagicService.processHttp(request, response);
		}catch (IOException e) {
			throw e;
		}catch (RuntimeException e) {
			throw e;
		}catch (Exception e) {
			throw new ServletException("Failed to process request: " + e, e);
		}
	}

}
