/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.deployer;

import java.io.InputStream;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.ebpm.core.SpagicNode;
import org.eclipse.ebpm.core.SpagicUtils;
import org.eclipse.ebpm.core.routing.IDynamicRouter;
import org.eclipse.ebpm.deployer.IDeploymentService;
import org.eclipse.ebpm.startup.service.IStartedUpService;
import org.eclipse.ebpm.util.resources.Resource;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentService
implements IDeploymentService {
    private static Logger logger = LoggerFactory.getLogger(DeploymentService.class);
    private static final String DATASOURCE_FACTORY_IDENTIFIER = "spagic3.datasourcefactory";
    private ConcurrentHashMap<String, ServiceReference> factories = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ComponentInstance> componentInstances = new ConcurrentHashMap();
    private ConcurrentHashMap<String, HashMap<String, Hashtable>> pendingDeployments = new ConcurrentHashMap();
    private ComponentContext componentContext = null;
    private AtomicReference<IDynamicRouter> dynamicRouter = new AtomicReference();

    protected void activate(ComponentContext componentContext) {
        logger.info(" Deployment Service - ACTIVATED");
        this.componentContext = componentContext;
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.info(" Deployment Service - DEACTIVATED");
    }

    public void addComponentFactory(ServiceReference componentFactoryReference) {
        String componentFactoryIdentifier = (String)componentFactoryReference.getProperty("component.factory");
        logger.info(" Component Factory [" + componentFactoryIdentifier + "] -- REGISTERED");
        this.factories.put(componentFactoryIdentifier, componentFactoryReference);
        logger.info(" Revamp Pending Deployment for [" + componentFactoryIdentifier + "]");
        HashMap<String, Hashtable> pendingDeploymentForFactory = this.pendingDeployments.remove(componentFactoryIdentifier);
        Hashtable pendingProp = null;
        if (pendingDeploymentForFactory != null) {
            for (String id : pendingDeploymentForFactory.keySet()) {
                pendingProp = pendingDeploymentForFactory.get(id);
                String depType = (String)pendingProp.get("SPAGIC_TYPE");
                if (depType.equalsIgnoreCase("SPAGIC_DATASOURCE") || depType.equalsIgnoreCase("SPAGIC_CONNECTIONFACTORY")) {
                    this.internalDeploy(id, depType, componentFactoryIdentifier, pendingProp, false);
                    continue;
                }
                this.internalDeploy(id, depType, componentFactoryIdentifier, pendingProp, true);
            }
        }
    }

    public void removeComponentFactory(ServiceReference componentFactoryReference) {
        String componentFactoryIdentifier = (String)componentFactoryReference.getProperty("component.factory");
        logger.info(" Component Factory [" + componentFactoryIdentifier + "] -- UNREGISTERED");
        this.factories.remove(componentFactoryIdentifier);
    }

    private void internalDeploy(String id, String spagicType, String factoryName, Hashtable properties, boolean subscribeOnBus) {
        logger.info("Deploying [" + spagicType + "] With ID [" + id + "] using [" + factoryName + "]");
        ServiceReference sr = this.factories.get(factoryName);
        properties.put("SPAGIC_TYPE", spagicType);
        if (sr == null) {
            logger.warn("Cannot Find A Component Factory [" + factoryName + "] for [" + spagicType + "] With ID [" + id + "]");
            if (this.pendingDeployments.get(factoryName) == null) {
                this.pendingDeployments.put(factoryName, new HashMap());
            }
            this.pendingDeployments.get(factoryName).put(id, properties);
        } else {
            ComponentFactory cf = (ComponentFactory)this.componentContext.locateService("cf", sr);
            if (subscribeOnBus) {
                logger.debug("Topic Determination for Node [" + id + "]");
                String topicToSubscribe = SpagicNode.topicForService((String)id);
                logger.debug("Topic To subscribe for Node [" + topicToSubscribe + "]");
                topicToSubscribe = SpagicUtils.normalizeTopic((String)topicToSubscribe);
                properties.put("event.topics", topicToSubscribe);
            }
            properties.put("spagic.id", id);
            ComponentInstance ci = cf.newInstance((Dictionary)properties);
            this.componentInstances.put(id, ci);
            logger.info("[" + spagicType + "] With ID [" + id + "] DEPLOYED ==");
        }
    }

    protected void internalUndeploy(String id) {
        ComponentInstance ci = this.componentInstances.get(id);
        if (ci != null) {
            this.componentInstances.remove(id);
            ci.dispose();
        }
    }

    @Override
    public void deployDatasource(String dataSourceId, Hashtable properties) {
        this.internalDeploy(dataSourceId, "SPAGIC_DATASOURCE", DATASOURCE_FACTORY_IDENTIFIER, properties, false);
    }

    @Override
    public void deployConnector(String spagicId, String factoryName, Hashtable properties) {
        this.resolvePlaceHolders(properties);
        this.internalDeploy(spagicId, "SPAGIC_CONNECTOR", factoryName, properties, true);
    }

    @Override
    public void deployService(String spagicId, String factoryName, Hashtable properties) {
        this.resolvePlaceHolders(properties);
        this.internalDeploy(spagicId, "SPAGIC_SERVICE", factoryName, properties, true);
    }

    @Override
    public void undeployConnector(String spagicId) {
        this.internalUndeploy(spagicId);
    }

    @Override
    public void undeployDatasource(String dataSourceID) {
        this.internalUndeploy(dataSourceID);
    }

    @Override
    public void undeployService(String spagicId) {
        this.internalUndeploy(spagicId);
    }

    @Override
    public void deployRoutes(List<String> updateRoutes, List<String> oldRoutes) {
        this.getDynamicRouter().updateRoutes(updateRoutes, oldRoutes);
    }

    public IDynamicRouter getDynamicRouter() {
        return this.dynamicRouter.get();
    }

    public void bindDynamicRouter(IDynamicRouter dynRouter) {
        this.dynamicRouter.set(dynRouter);
    }

    public void unbindDynamicRouter(IDynamicRouter dynRouter) {
        this.dynamicRouter.compareAndSet(dynRouter, null);
    }

    @Override
    public void deployConnectionFactory(String connectionFactoryID, String factoryName, Hashtable properties) {
        this.internalDeploy(connectionFactoryID, "SPAGIC_CONNECTIONFACTORY", factoryName, properties, false);
    }

    @Override
    public void undeployConnectionFactory(String connectionFactoryID) {
        this.internalUndeploy(connectionFactoryID);
    }

    public void bindStartUpService(IStartedUpService startedUpService) {
        logger.info("STARTUP SERVICE IS OK -> CAN START DEPLOYMENT PHASE");
    }

    public void unbindStartUpService(IStartedUpService startedUpService) {
        logger.info("");
    }

    protected void resolvePlaceHolders(Hashtable properties) {
        Map<String, String> phMaps = this.identifyPlaceHolders(properties);
        if (phMaps != null && phMaps.size() > 0) {
            Properties resolvers = this.loadResolverList();
            for (String phKey : phMaps.keySet()) {
                String pName = phMaps.get(phKey);
                String resolvedPropertyValue = resolvers.getProperty(pName);
                if (resolvedPropertyValue != null) {
                    logger.info("Resolving Property [" + phKey + "] -> Bounded to PlaceHolder [$" + pName + "] to [" + resolvedPropertyValue + "]");
                    properties.put(phKey, resolvedPropertyValue);
                    continue;
                }
                logger.info("Cannot Resolve Property [" + phKey + "] -> Bounded to PlaceHolder [$" + pName + "]");
            }
        }
    }

    public Map<String, String> identifyPlaceHolders(Hashtable properties) {
        HashMap<String, String> phMaps = new HashMap<String, String>();
        for (Object key : properties.keySet()) {
            String value = (String)properties.get(key);
            if (!value.startsWith("$")) continue;
            phMaps.put((String)key, value.substring(1));
        }
        for (String phMapKey : phMaps.keySet()) {
            properties.remove(phMapKey);
        }
        return phMaps;
    }

    public Properties loadResolverList() {
        InputStream is = null;
        Properties resolvedPlaceHolders = new Properties();
        try {
            String propertyResolverValue = System.getProperty("spagic.properties.resolver");
            is = new Resource("properties://spagic.properties").openStream();
            resolvedPlaceHolders.load(is);
            is.close();
            if (propertyResolverValue != null && propertyResolverValue.trim().length() > 0) {
                String[] resolvers = propertyResolverValue.split(",");
                int i = 0;
                while (i < resolvers.length) {
                    resolvers[i] = "properties://" + resolvers[i];
                    ++i;
                }
                i = 0;
                while (i < resolvers.length) {
                    is = new Resource(resolvers[i]).openStream();
                    resolvedPlaceHolders.load(is);
                    is.close();
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {}
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        return resolvedPlaceHolders;
    }
}

