/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.components.javascript;

import java.io.InputStreamReader;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.eclipse.ebpm.core.BaseSpagicService;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.eclipse.ebpm.util.resources.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavascriptComponent
extends BaseSpagicService {
    private ScriptEngine engine;
    private CompiledScript compiledScript;
    protected Logger logger = LoggerFactory.getLogger(JavascriptComponent.class);
    public IResource script = null;

    public void init() {
        try {
            this.logger.debug("Initializing JavascriptComponent with ID [" + this.getSpagicId() + "]");
            this.script = this.propertyConfigurator.getResource("script");
            this.logger.debug("Script Property Is [" + this.script + "]");
            this.engine = this.createScriptEngine();
            this.logger.debug("Engine Created [" + this.script + "]");
            if (this.engine == null) {
                throw new RuntimeException("Engine is Null");
            }
            if (this.engine instanceof Compilable) {
                this.logger.debug("Engine is IstanceOf Compilable [" + this.script + "]");
                Compilable compilable = (Compilable)((Object)this.engine);
                this.logger.debug("Compiling Script [" + this.script + "]");
                this.compileScript(compilable);
                this.logger.debug("Script Compiled [" + this.script + "]");
            }
        }
        catch (Throwable e) {
            this.logger.error(e.getMessage(), e);
            throw new RuntimeException(" Cannot instantiate Groovy Component", e);
        }
    }

    protected void compileScript(Compilable compilable) throws Exception {
        try {
            this.compiledScript = compilable.compile(new InputStreamReader(this.script.openStream()));
        }
        catch (ScriptException e) {
            throw new Exception("Failed to parse compiledScript. Reason:  " + e, e);
        }
    }

    protected ScriptEngine createScriptEngine() {
        ScriptEngineManager factory = new ScriptEngineManager();
        ScriptEngine engine = factory.getEngineByName("JavaScript");
        return engine;
    }

    protected void populateBindings(Bindings bindings, Exchange exchange, Message in, Message out) throws Exception {
        bindings.put("exchange", (Object)exchange);
        bindings.put("inMessage", (Object)in);
        bindings.put("log", (Object)this.logger);
        bindings.put("outMessage", (Object)out);
    }

    public boolean run(Exchange exchange, Message in, Message out) throws Exception {
        this.logger.info(" JavascriptComponent Component -> Run [" + this.getSpagicId() + "]");
        Bindings bindings = null;
        try {
            this.logger.info(" JavascriptComponent Component -> Before Create Bindings [" + this.getSpagicId() + "]");
            bindings = this.engine.createBindings();
            this.logger.info(" JavascriptComponent Component -> Populating Bindings  [" + this.getSpagicId() + "]");
            this.populateBindings(bindings, exchange, in, out);
        }
        catch (Throwable e) {
            this.logger.error(" JavascriptComponent Component Error", e);
        }
        try {
            long startAt = System.currentTimeMillis();
            this.runScript(bindings);
            long endAt = System.currentTimeMillis();
            this.logger.info(" Script[" + this.getSpagicId() + " Script ] |" + (endAt - startAt));
            this.logger.info(" Script Component -> End [" + this.getSpagicId() + "]");
            return true;
        }
        catch (ScriptException e) {
            this.logger.error(" Script Component Error", (Throwable)e);
            throw new Exception("Failed to run compiledScript. Reason: " + e, e);
        }
    }

    protected void runScript(Bindings bindings) throws ScriptException {
        if (this.compiledScript != null) {
            this.compiledScript.eval(bindings);
        }
    }
}

