/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.monitoring;

import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.ebpm.databasemanager.IDatabaseManager;
import org.eclipse.ebpm.metadb.model.Service;
import org.eclipse.ebpm.metadb.model.ServiceInstance;
import org.eclipse.ebpm.monitoring.MonitorService;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorEventConsumer
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(MonitorService.class);
    private BlockingQueue<Event> blockingQueue;
    private String consumerName;
    private final AtomicReference<IDatabaseManager> dbManagerAR = new AtomicReference<Object>(null);

    public MonitorEventConsumer(String consumerName, BlockingQueue<Event> blockingQueue, IDatabaseManager dbManager) {
        this.consumerName = consumerName;
        this.blockingQueue = blockingQueue;
        this.dbManagerAR.set(dbManager);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Event ev = this.blockingQueue.take();
                    this.consumeEvent(ev);
                }
            }
            catch (InterruptedException ie) {
                logger.error("Interrupted", (Throwable)ie);
                continue;
            }
            break;
        }
    }

    public void consumeEvent(Event event) {
        try {
            String[] stringArray = event.getPropertyNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String propertyName = stringArray[n2];
                logger.debug(String.valueOf(propertyName) + " = " + event.getProperty(propertyName));
                ++n2;
            }
            IDatabaseManager dbManager = this.getDatabaseManager();
            Boolean internalEvent = (Boolean)event.getProperty("_IS_INTERNAL_EVENT");
            if (internalEvent != null && internalEvent.booleanValue()) {
                if (event.getProperty("_INTERNAL_EVENT_TYPE").equals("_INTERNAL_EVENT_PROCESS_STARTED")) {
                    String exchangeID = (String)event.getProperty("_INTERNAL_EVENT_REFERRING_ID");
                    Long processId = (Long)event.getProperty("_INTERNAL_EVENT_PROCESS_ID");
                    if (exchangeID != null && processId != null) {
                        dbManager.relateProcessToServiceInstance(exchangeID, processId);
                    }
                }
                return;
            }
            String exchangeID = (String)event.getProperty("EXCHANGE_ID");
            String correlationID = (String)event.getProperty("EP.CORRELATION_ID");
            String status = (String)event.getProperty("STATUS");
            String sender = (String)event.getProperty("EP.SPAGIC_SENDER");
            String target = (String)event.getProperty("EP.SPAGIC_TARGET");
            String inBody = (String)event.getProperty("INBODY");
            String outBody = (String)event.getProperty("OUTBODY");
            String faultBody = (String)event.getProperty("FAULTBODY");
            String errorMsg = (String)event.getProperty("ERROR");
            Service senderService = dbManager.getServiceById(sender);
            if (senderService == null) {
                logger.debug("Sender service: " + sender + " not found");
                return;
            }
            Service targetService = dbManager.getServiceById(target);
            if (targetService == null) {
                logger.debug("Target service: " + target + " not found");
                return;
            }
            if (inBody == null) {
                logger.warn("Input body not found");
                return;
            }
            ServiceInstance senderServiceInstance = dbManager.getServiceInstanceByCorrelationId(sender, correlationID);
            ServiceInstance targetServiceInstance = dbManager.getServiceInstanceByCorrelationId(target, correlationID);
            if (status == "DONE") {
                Date endDate = new Date();
                if (senderServiceInstance != null) {
                    senderServiceInstance.setEnddate(endDate);
                    senderServiceInstance.setState(1);
                    dbManager.updateServiceInstance(senderServiceInstance);
                }
                if (targetServiceInstance != null) {
                    targetServiceInstance.setEnddate(endDate);
                    targetServiceInstance.setState(1);
                    dbManager.updateServiceInstance(targetServiceInstance);
                }
            } else if (status == "ACTIVE") {
                if (outBody != null) {
                    if (senderServiceInstance == null || targetServiceInstance == null) {
                        logger.warn("Service instances not found");
                        return;
                    }
                    senderServiceInstance.setResponse(outBody);
                    senderServiceInstance.setState(1);
                    dbManager.updateServiceInstance(senderServiceInstance);
                } else {
                    if (senderServiceInstance == null) {
                        if (senderService.isMonitorEnabled().booleanValue()) {
                            senderServiceInstance = dbManager.createServiceInstance(sender, String.valueOf(exchangeID) + "-0", correlationID, targetServiceInstance, null, null);
                        } else {
                            logger.debug("Sender service: " + sender + " not monitored");
                        }
                    }
                    if (targetServiceInstance == null) {
                        if (targetService.isMonitorEnabled().booleanValue()) {
                            targetServiceInstance = dbManager.createServiceInstance(target, exchangeID, correlationID, null, inBody, null);
                        } else {
                            logger.debug("Target service: " + target + " not monitored");
                        }
                        if (senderServiceInstance != null) {
                            senderServiceInstance.setTargetServiceInstance(targetServiceInstance);
                            dbManager.updateServiceInstance(senderServiceInstance);
                        }
                    }
                }
            } else if (status == "ERROR") {
                if (senderServiceInstance == null || targetServiceInstance == null) {
                    logger.error("Service instances not found");
                    return;
                }
                Date endDate = new Date();
                senderServiceInstance.setState(2);
                senderServiceInstance.setEnddate(endDate);
                senderServiceInstance.setResponse(outBody);
                senderServiceInstance.setError(faultBody != null ? faultBody : errorMsg);
                dbManager.updateServiceInstance(senderServiceInstance);
                targetServiceInstance.setState(2);
                targetServiceInstance.setEnddate(endDate);
                dbManager.updateServiceInstance(targetServiceInstance);
            } else {
                logger.warn("Unknown state: " + status);
            }
        }
        catch (Throwable th) {
            logger.error("Error monitoring event", th);
        }
    }

    public IDatabaseManager getDatabaseManager() {
        return this.dbManagerAR.get();
    }
}

