/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.components.xslt;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.eclipse.ebpm.core.BaseSpagicService;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.eclipse.ebpm.util.resources.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XsltComponent
extends BaseSpagicService {
    protected Logger logger = LoggerFactory.getLogger(XsltComponent.class);
    private TransformerFactory transformerFactory;
    public IResource xslt = null;

    public void init() {
        try {
            this.xslt = this.propertyConfigurator.getResource("xslt");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(" Cannot instantiate XsltComponent Component", e);
        }
    }

    public TransformerFactory getTransformerFactory() {
        this.logger.debug("XSLT Transformer::getTranformerFactory::->start");
        if (this.transformerFactory == null) {
            this.logger.debug("XSLT Transformer::TransformerFactory is null::create one");
            this.transformerFactory = TransformerFactory.newInstance();
            this.logger.debug("XSLT Transformer::TransformerFactory created");
        }
        this.logger.debug("XSLT Transformer::getTransformerFactory::transformerFactory " + (this.transformerFactory != null ? "transformerFactory is not null " : "transformerFactory IS NULL"));
        return this.transformerFactory;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    public Source getXsltSource() throws Exception {
        this.logger.debug("XSLT Transformer::getXsltSource::->start");
        this.logger.debug("XSLT Transformer::getXsltSource::xsltSource is null create it ");
        StreamSource xsltSource = new StreamSource(this.xslt.openStream());
        this.logger.debug("XSLT Transformer::getXsltSource::xsltSource created ");
        this.logger.debug("XSLT Transformer::getXsltSource::xsltSource " + (xsltSource != null ? "XSLT Source is not null " : "xsltSource IS NULL"));
        return xsltSource;
    }

    public boolean run(Exchange exchange, Message in, Message out) throws Exception {
        try {
            Transformer transformer = this.getTransformerFactory().newTransformer(this.getXsltSource());
            Document inDocument = DocumentHelper.parseText((String)in.getBodyText());
            DocumentSource source = new DocumentSource(inDocument);
            DocumentResult result = new DocumentResult();
            transformer.transform((Source)source, (Result)result);
            Document transformedDoc = result.getDocument();
            out.setBody(transformedDoc.getRootElement().asXML());
            return true;
        }
        catch (Throwable e) {
            this.logger.error(e.getMessage(), e);
            e.fillInStackTrace();
            throw new Exception();
        }
    }
}

