/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.messaging.api;

import java.util.HashMap;
import java.util.Map;

public enum Pattern {
    InOnly,
    RobustInOnly,
    InOut,
    InOptionalOut;

    protected static final Map<String, Pattern> map;

    static {
        map = new HashMap<String, Pattern>();
        Pattern[] patternArray = Pattern.values();
        int n = patternArray.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern mep = patternArray[n2];
            String uri = mep.getWsdlUri();
            map.put(uri, mep);
            String name = uri.substring(uri.lastIndexOf(47) + 1);
            map.put("http://www.w3.org/2004/08/wsdl/" + name, mep);
            map.put("http://www.w3.org/2006/01/wsdl/" + name, mep);
            ++n2;
        }
    }

    public String getWsdlUri() {
        switch (this) {
            case InOnly: {
                return "http://www.w3.org/ns/wsdl/in-only";
            }
            case InOptionalOut: {
                return "http://www.w3.org/ns/wsdl/in-opt-out";
            }
            case InOut: {
                return "http://www.w3.org/ns/wsdl/in-out";
            }
            case RobustInOnly: {
                return "http://www.w3.org/ns/wsdl/robust-in-only";
            }
        }
        throw new IllegalArgumentException("Unknown message exchange pattern: " + (Object)((Object)this));
    }

    public static Pattern fromWsdlUri(String wsdlUri) {
        return map.get(wsdlUri);
    }
}

