/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.jms.activemq;

import java.util.ArrayList;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.provider.generic.GenericContainerInstantiator;
import org.eclipse.ecf.provider.jms.activemq.container.ActiveMQJMSServerContainer;
import org.eclipse.ecf.provider.jms.container.JMSContainerConfig;
import org.eclipse.ecf.provider.jms.identity.JMSID;

public class ActiveMQJMSServerContainerInstantiator
extends GenericContainerInstantiator {
    protected static final String[] jmsIntents = new String[]{"JMS"};

    public IContainer createInstance(ContainerTypeDescription description, Object[] args) throws ContainerCreateException {
        try {
            Integer ka = new Integer(30000);
            String name = null;
            if (args.length == 0) {
                throw new ContainerCreateException("no server id provided for creation");
            }
            name = (String)args[0];
            JMSID serverID = (JMSID)IDFactory.getDefault().createID("ecf.namespace.jmsid", name);
            if (args.length > 1) {
                ka = this.getIntegerFromArg(args[1]);
            }
            if (ka == null) {
                ka = new Integer(30000);
            }
            ActiveMQJMSServerContainer server = new ActiveMQJMSServerContainer(new JMSContainerConfig(serverID, ka.intValue(), null));
            server.start();
            return server;
        }
        catch (Exception e) {
            throw new ContainerCreateException("Exception creating activemq server container", (Throwable)e);
        }
    }

    public String[] getSupportedIntents(ContainerTypeDescription description) {
        ArrayList<String> results = new ArrayList<String>();
        int i = 0;
        while (i < genericProviderIntents.length) {
            results.add(genericProviderIntents[i]);
            ++i;
        }
        i = 0;
        while (i < jmsIntents.length) {
            results.add(jmsIntents[i]);
            ++i;
        }
        return results.toArray(new String[0]);
    }
}

