/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.http.adapters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ebpm.connectors.http.adapters.IHTTPOutputProtocolAdapter;
import org.eclipse.ebpm.connectors.http.adapters.SpagicJettyHTTPExchange;
import org.eclipse.ebpm.core.ExchangeUtils;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.soap.api.InterceptorChain;
import org.eclipse.ebpm.soap.api.InterceptorProvider;
import org.eclipse.ebpm.soap.api.Message;
import org.eclipse.ebpm.soap.api.model.Binding;
import org.eclipse.ebpm.soap.bindings.soap.SoapVersion;
import org.eclipse.ebpm.util.properties.PropertyConfigurator;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;

public class SOAPProtocolOutputAdapter
implements IHTTPOutputProtocolAdapter {
    private Map<InterceptorProvider.Phase, InterceptorChain> chains = new HashMap<InterceptorProvider.Phase, InterceptorChain>();

    @Override
    public String getAdapterId() {
        return "SOAP";
    }

    protected String getLocationUri(Exchange exchange, org.eclipse.ebpm.messaging.api.Message inMsg, PropertyConfigurator pc) {
        if (inMsg.getHeader("locationURI") != null) {
            return (String)inMsg.getHeader("locationURI");
        }
        return pc.getString("locationURI");
    }

    @Override
    public void fillJettyExchange(Exchange nmrExchange, SpagicJettyHTTPExchange jettyExchange, PropertyConfigurator pc, Object binding) {
        Binding soapBinding = (Binding)binding;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Message soapMessage = soapBinding.createMessage();
        boolean mustSetOperationHeader = pc.getBoolean("mustSetOperation", Boolean.valueOf(false));
        pc.getString("request.contentType", null);
        String operationName = null;
        if (mustSetOperationHeader) {
            operationName = pc.getString("operation");
            nmrExchange.setProperty("mustSetOperation", (Object)mustSetOperationHeader);
            nmrExchange.setProperty("SOAPAction", (Object)operationName);
        }
        soapMessage.setContent(Exchange.class, (Object)nmrExchange);
        soapMessage.setContent(org.eclipse.ebpm.messaging.api.Message.class, (Object)nmrExchange.getIn(false));
        soapMessage.setContent(OutputStream.class, (Object)baos);
        nmrExchange.setProperty(Message.class.getName(), (Object)soapMessage);
        if (pc.getBoolean("isSendFaultsToTarget", Boolean.valueOf(false)).booleanValue()) {
            soapMessage.put((Object)"sendFaultsToTarget", (Object)"true");
        }
        InterceptorChain phaseOut = this.getChain(InterceptorProvider.Phase.ClientOut, soapBinding);
        phaseOut.doIntercept(soapMessage);
        jettyExchange.setMethod("POST");
        org.eclipse.ebpm.messaging.api.Message inMsg = nmrExchange.getIn(false);
        jettyExchange.setURL(this.getLocationUri(nmrExchange, inMsg, pc));
        jettyExchange.setRequestContent((Buffer)new ByteArrayBuffer(baos.toByteArray()));
        for (Map.Entry entry : soapMessage.getTransportHeaders().entrySet()) {
            jettyExchange.addRequestHeader((String)entry.getKey(), (String)entry.getValue());
        }
        SoapVersion soapVersion = (SoapVersion)soapMessage.get(SoapVersion.class);
        String msgContentType = (String)soapMessage.get((Object)"Content-Type");
        if (msgContentType != null && msgContentType.trim().length() != 0) {
            jettyExchange.setRequestContentType(msgContentType);
        } else {
            jettyExchange.setRequestContentType(soapVersion.getSoapMimeType());
        }
    }

    @Override
    public void handleException(Exchange nmrExchange, SpagicJettyHTTPExchange jettyExchange, Throwable t, PropertyConfigurator pc, Object binding) {
        if (pc.getBoolean("isSendFaultsToTarget", Boolean.valueOf(false)).booleanValue()) {
            org.eclipse.ebpm.messaging.api.Message out = nmrExchange.getOut(true);
            out.setBody("<ERROR>" + new String(ExchangeUtils.getStringFromException((Throwable)t)) + "</ERROR>");
            nmrExchange.setOut(out);
        } else {
            nmrExchange.setError((Exception)t);
        }
    }

    @Override
    public void handleResponse(Exchange nmrExchange, SpagicJettyHTTPExchange jettyExchange, PropertyConfigurator pc, Object binding) {
        try {
            Binding soapBinding = (Binding)binding;
            Message soapMessageRequest = (Message)nmrExchange.getProperty(Message.class.getName());
            nmrExchange.setProperty(Message.class.getName(), null);
            Message soapMessageResponse = soapBinding.createMessage(soapMessageRequest);
            soapMessageResponse.setContent(Exchange.class, (Object)nmrExchange);
            soapMessageResponse.setContent(InputStream.class, (Object)new ByteArrayInputStream(jettyExchange.getResponse()));
            HttpFields responseFields = jettyExchange.getResponseFields();
            Enumeration enumF = responseFields.getFieldNames();
            while (enumF.hasMoreElements()) {
                String key = (String)enumF.nextElement();
                String value = responseFields.getStringField(key);
                if (!key.equalsIgnoreCase("Content-Type")) continue;
                soapMessageResponse.put((Object)"Content-Type", (Object)value);
            }
            soapMessageResponse.put((Object)"Encoding", (Object)"utf-8");
            InterceptorChain phaseOut = this.getChain(InterceptorProvider.Phase.ClientIn, soapBinding);
            if (pc.getBoolean("isSendFaultsToTarget", Boolean.valueOf(false)).booleanValue()) {
                soapMessageResponse.put((Object)"sendFaultsToTarget", (Object)"true");
            }
            phaseOut.doIntercept(soapMessageResponse);
        }
        catch (Exception e) {
            if (pc.getBoolean("isSendFaultsToTarget", Boolean.valueOf(false)).booleanValue()) {
                org.eclipse.ebpm.messaging.api.Message out = nmrExchange.getOut(true);
                out.setBody("<ERROR>" + new String(ExchangeUtils.getStringFromException((Throwable)e)) + "</ERROR>");
                return;
            }
            throw new RuntimeException(e);
        }
    }

    protected InterceptorChain getChain(InterceptorProvider.Phase phase, Binding<?> binding) {
        InterceptorChain chain = this.chains.get(phase);
        if (chain == null) {
            chain = binding.getInterceptorChain(phase);
            this.chains.put(phase, chain);
        }
        return chain;
    }

    @Override
    public void setProperty(Map<String, String> map) {
    }
}

