/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.http.adapters;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.ebpm.connectors.http.adapters.IHTTPInputProtocolAdapter;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.security.SecurityToken;
import org.eclipse.ebpm.soap.api.InterceptorChain;
import org.eclipse.ebpm.soap.api.InterceptorProvider;
import org.eclipse.ebpm.soap.api.Message;
import org.eclipse.ebpm.soap.api.model.Binding;
import org.eclipse.ebpm.soap.bindings.soap.SoapFault;
import org.eclipse.ebpm.soap.bindings.soap.SoapVersion;
import org.eclipse.ebpm.util.properties.PropertyConfigurator;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SOAPInputProtocolAdapter
implements IHTTPInputProtocolAdapter {
    private Map<InterceptorProvider.Phase, InterceptorChain> chains = new HashMap<InterceptorProvider.Phase, InterceptorChain>();

    @Override
    public String getAdapterId() {
        return "SOAP";
    }

    @Override
    public Exchange createExchange(HttpServletRequest request, String mep, String sender, String target, PropertyConfigurator pc, Object binding) throws Exception {
        Binding soapBinding = (Binding)binding;
        String method = request.getMethod();
        Message soapMessage = soapBinding.createMessage();
        soapMessage.put((Object)"Content-Type", (Object)request.getContentType());
        Map headers = soapMessage.getTransportHeaders();
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = request.getHeader(name);
            headers.put(name, value);
        }
        headers.put("REQUEST_URI", request.getRequestURL().toString());
        headers.put("CONTENT_TYPE", request.getContentType());
        headers.put("REQUEST_METHOD", method);
        ServletInputStream temp = request.getInputStream();
        if (temp != null) {
            soapMessage.setContent(InputStream.class, (Object)request.getInputStream());
        }
        request.setAttribute(Message.class.getName(), (Object)soapMessage);
        soapMessage.put((Object)"SPAGIC_SENDER", (Object)sender);
        if (target != null) {
            soapMessage.put((Object)"SPAGIC_TARGET", (Object)target);
        }
        InterceptorChain phase = this.getChain(InterceptorProvider.Phase.ServerIn, soapBinding);
        phase.doIntercept(soapMessage);
        Exchange exchange = (Exchange)soapMessage.getContent(Exchange.class);
        Map soapHeaders = soapMessage.getSoapHeaders();
        for (QName soapHeaderQName : soapHeaders.keySet()) {
            System.out.println(" QName " + soapHeaderQName);
            if (!soapHeaderQName.getLocalPart().equalsIgnoreCase("spagic-target-service")) continue;
            DocumentFragment aSoapHeader = (DocumentFragment)soapHeaders.get(soapHeaderQName);
            String targetServiceId = aSoapHeader.getTextContent();
            exchange.setProperty("SPAGIC_TARGET", (Object)targetServiceId);
            org.eclipse.ebpm.messaging.api.Message inMessage = exchange.getIn();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource source = new InputSource(new StringReader(inMessage.getBodyText()));
            Document document = builder.parse(source);
            Element payloadElement = document.getDocumentElement();
            NodeList nl = payloadElement.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node node = nl.item(i);
                String nodeName = node.getNodeName();
                if (nodeName.equals("spagic:message")) {
                    Node messageElement = node;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    SOAPInputProtocolAdapter.nodeToStream(messageElement.getFirstChild(), baos);
                    inMessage.setBodyText(baos.toString());
                } else if (nodeName.equals("spagic:properties")) {
                    Node propertiesElement = node;
                    NamedNodeMap nnm = propertiesElement.getAttributes();
                    int j = 0;
                    while (j < nnm.getLength()) {
                        Node nodeProp = nnm.item(j);
                        inMessage.setHeader(nodeProp.getNodeName(), (Object)nodeProp.getNodeValue());
                        ++j;
                    }
                } else if (nodeName.equals("spagic:security")) {
                    Element securityElement = (Element)node;
                    SecurityToken st = new SecurityToken();
                    st.setCommonName(securityElement.getAttribute("CN"));
                    st.setOrganizationalUnit(securityElement.getAttribute("OU"));
                    st.setOrganization(securityElement.getAttribute("O"));
                    st.setLocality(securityElement.getAttribute("L"));
                    st.setState(securityElement.getAttribute("ST"));
                    st.setCountry(securityElement.getAttribute("C"));
                    Element propElement = (Element)securityElement.getFirstChild();
                    if (propElement != null) {
                        NamedNodeMap nnm = propElement.getAttributes();
                        int nodeInd = 0;
                        while (nodeInd < nnm.getLength()) {
                            Node nodeProp = nnm.item(nodeInd);
                            st.addProperty(nodeProp.getNodeName(), nodeProp.getNodeValue());
                            ++nodeInd;
                        }
                    }
                    SecurityToken.saveInMessage((SecurityToken)st, (org.eclipse.ebpm.messaging.api.Message)inMessage);
                }
                ++i;
            }
        }
        return exchange;
    }

    public static void nodeToStream(Node element, OutputStream out) {
        try {
            DOMSource source = new DOMSource(element);
            StreamResult result = new StreamResult(out);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(source, result);
        }
        catch (Exception exception) {}
    }

    @Override
    public void sendAccepted(Exchange exchange, HttpServletRequest request, HttpServletResponse response, PropertyConfigurator pc, Object binding) throws Exception {
        response.setStatus(202);
    }

    @Override
    public void sendError(Exchange exchange, Exception error, HttpServletRequest request, HttpServletResponse response, PropertyConfigurator pc, Object binding) throws Exception {
        Binding soapBinding = (Binding)binding;
        response.setStatus(500);
        Message soapMessageIn = (Message)request.getAttribute(Message.class.getName());
        Message soapMessageOut = soapBinding.createMessage(soapMessageIn);
        soapMessageOut.setContent(OutputStream.class, (Object)response.getOutputStream());
        soapMessageOut.setContent(Exchange.class, (Object)exchange);
        soapMessageOut.put(SoapVersion.class, (Object)((SoapVersion)soapMessageIn.get(SoapVersion.class)));
        InterceptorChain phase = this.getChain(InterceptorProvider.Phase.ServerOutFault, soapBinding);
        SoapFault soapFault = error instanceof SoapFault ? (SoapFault)error : new SoapFault(error);
        soapMessageOut.setContent(Exception.class, (Object)soapFault);
        phase.doIntercept(soapMessageOut);
    }

    @Override
    public void sendFault(Exchange exchange, org.eclipse.ebpm.messaging.api.Message fault, HttpServletRequest request, HttpServletResponse response, PropertyConfigurator pc, Object binding) throws Exception {
        Binding soapBinding = (Binding)binding;
        response.setStatus(500);
        Message soapMessageIn = (Message)request.getAttribute(Message.class.getName());
        Message soapMessageOut = soapBinding.createMessage(soapMessageIn);
        SoapVersion version = (SoapVersion)soapMessageIn.get(SoapVersion.class);
        soapMessageOut.setContent(OutputStream.class, (Object)response.getOutputStream());
        soapMessageOut.setContent(Exchange.class, (Object)exchange);
        soapMessageOut.setContent(org.eclipse.ebpm.messaging.api.Message.class, (Object)fault);
        soapMessageOut.put(SoapVersion.class, (Object)version);
        InterceptorChain phase = this.getChain(InterceptorProvider.Phase.ServerOutFault, soapBinding);
        QName code = (QName)fault.getHeader("spagic.soap.fault.code");
        String reason = (String)fault.getHeader("spagic.soap.fault.reason");
        SoapFault soapFault = new SoapFault(code, reason, null, null, fault.getBody());
        soapMessageOut.setContent(Exception.class, (Object)soapFault);
        response.setContentType(version.getSoapMimeType());
        phase.doIntercept(soapMessageOut);
    }

    @Override
    public void sendOut(Exchange exchange, org.eclipse.ebpm.messaging.api.Message out, HttpServletRequest request, HttpServletResponse response, PropertyConfigurator pc, Object binding) throws Exception {
        Binding soapBinding = (Binding)binding;
        response.setStatus(200);
        Message soapMessageIn = (Message)request.getAttribute(Message.class.getName());
        Message soapMessageOut = soapBinding.createMessage(soapMessageIn);
        soapMessageOut.put(HttpServletResponse.class, (Object)response);
        soapMessageOut.setContent(OutputStream.class, (Object)response.getOutputStream());
        soapMessageOut.setContent(Exchange.class, (Object)exchange);
        soapMessageOut.setContent(org.eclipse.ebpm.messaging.api.Message.class, (Object)out);
        SoapVersion version = (SoapVersion)soapMessageIn.get(SoapVersion.class);
        soapMessageOut.put(SoapVersion.class, (Object)version);
        response.setContentType(version.getSoapMimeType());
        InterceptorChain phase = this.getChain(InterceptorProvider.Phase.ServerOut, soapBinding);
        phase.doIntercept(soapMessageOut);
    }

    protected InterceptorChain getChain(InterceptorProvider.Phase phase, Binding<?> binding) {
        InterceptorChain chain = this.chains.get(phase);
        if (chain == null) {
            chain = binding.getInterceptorChain(phase);
            this.chains.put(phase, chain);
        }
        return chain;
    }

    @Override
    public void setProperty(Map<String, String> map) {
    }
}

