/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.comm.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.ecf.provider.comm.tcp.IClientSocketFactory;
import org.eclipse.ecf.provider.comm.tcp.IServerSocketFactory;

public class SocketFactory
implements IClientSocketFactory,
IServerSocketFactory {
    protected static SocketFactory defaultFactory;
    protected static SocketFactory factory;

    static {
        factory = null;
    }

    public Socket createSocket(String name, int port, int timeout) throws IOException {
        if (factory != null) {
            return factory.createSocket(name, port, timeout);
        }
        Socket s = new Socket();
        s.connect(new InetSocketAddress(name, port), timeout);
        return s;
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        if (factory != null) {
            return factory.createServerSocket(port, backlog);
        }
        return new ServerSocket(port, backlog);
    }

    public static synchronized SocketFactory getSocketFactory() {
        return factory;
    }

    public static synchronized SocketFactory getDefaultSocketFactory() {
        if (defaultFactory == null) {
            defaultFactory = new SocketFactory();
        }
        return defaultFactory;
    }

    public static synchronized void setSocketFactory(SocketFactory fact) {
        if (!fact.equals(defaultFactory)) {
            factory = fact;
        }
    }
}

