/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.metadb.model;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.eclipse.ebpm.metadb.model.Component;
import org.eclipse.ebpm.metadb.model.Property;
import org.eclipse.ebpm.metadb.model.ServiceInstance;
import org.eclipse.ebpm.metadb.model.SpagicNode;

@Entity
@Table(name="service")
public class Service
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE)
    @Column(name="id_service")
    private String idService;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date enddate;
    @Column(name="monitor_enabled")
    private Boolean monitorEnabled;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date startdate;
    private int state;
    @ManyToMany(mappedBy="services")
    private List<Property> properties;
    @ManyToOne
    @JoinColumn(name="id_component")
    private Component component;
    @OneToMany(mappedBy="service")
    private List<ServiceInstance> serviceInstances;
    @ManyToMany
    @JoinTable(name="service_node", joinColumns={@JoinColumn(name="id_service")}, inverseJoinColumns={@JoinColumn(name="id_node")})
    private List<SpagicNode> spagicNodes;

    public Service() {
    }

    public Service(String idService, Component component, Date startdate) {
        this.idService = idService;
        this.component = component;
        this.startdate = startdate;
    }

    public Service(String idService, Component component, int state, Boolean monitorEnabled, Date startdate, Date enddate, List<Property> properties, List<ServiceInstance> serviceInstances) {
        this.idService = idService;
        this.component = component;
        this.state = state;
        this.monitorEnabled = monitorEnabled;
        this.startdate = startdate;
        this.enddate = enddate;
        this.properties = properties;
        this.serviceInstances = serviceInstances;
    }

    public String getIdService() {
        return this.idService;
    }

    public void setIdService(String idService) {
        this.idService = idService;
    }

    public Date getEnddate() {
        return this.enddate;
    }

    public void setEnddate(Date enddate) {
        this.enddate = enddate;
    }

    public Boolean isMonitorEnabled() {
        return this.monitorEnabled;
    }

    public void setMonitorEnabled(Boolean monitorEnabled) {
        this.monitorEnabled = monitorEnabled;
    }

    public Date getStartdate() {
        return this.startdate;
    }

    public void setStartdate(Date startdate) {
        this.startdate = startdate;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public List<ServiceInstance> getServiceInstances() {
        return this.serviceInstances;
    }

    public void setServiceInstances(List<ServiceInstance> serviceInstances) {
        this.serviceInstances = serviceInstances;
    }

    public List<SpagicNode> getSpagicNodes() {
        return this.spagicNodes;
    }

    public void setSpagicNodes(List<SpagicNode> spagicNodes) {
        this.spagicNodes = spagicNodes;
    }
}

