/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.messaging.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.eclipse.ebpm.messaging.api.Pattern;
import org.eclipse.ebpm.messaging.api.Status;
import org.eclipse.ebpm.messaging.api.Type;
import org.eclipse.ebpm.messaging.core.MessageImpl;
import org.eclipse.ebpm.messaging.core.util.ExchangeUtils;

public class ExchangeImpl
implements Exchange {
    private static final long serialVersionUID = 5453128544624717320L;
    private String id;
    private Status status;
    private Pattern pattern;
    private QName operation;
    private Map<String, Object> properties;
    private Message in;
    private Message out;
    private Message fault;
    private Exception error;

    public ExchangeImpl(String id, Pattern pattern) {
        this.id = id;
        this.status = Status.Active;
        this.pattern = pattern;
    }

    public ExchangeImpl(Pattern pattern) {
        this.id = UUID.randomUUID().toString();
        this.status = Status.Active;
        this.pattern = pattern;
    }

    private ExchangeImpl() {
    }

    public String getId() {
        return this.id;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public QName getOperation() {
        return this.operation;
    }

    public void setOperation(QName operation) {
        this.operation = operation;
    }

    public Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(name, value);
    }

    public Object removeProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.remove(name);
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Message getIn() {
        return this.getIn(true);
    }

    public Message getIn(boolean lazyCreate) {
        if (this.in == null && lazyCreate) {
            this.in = this.createMessage();
        }
        return this.in;
    }

    public void setIn(Message message) {
        this.in = message;
    }

    public Message getOut() {
        return this.getOut(true);
    }

    public Message getOut(boolean lazyCreate) {
        if (this.out == null && lazyCreate && this.pattern != Pattern.InOnly && this.pattern != Pattern.RobustInOnly) {
            this.out = this.createMessage();
        }
        return this.out;
    }

    public void setOut(Message message) {
        this.out = message;
    }

    public Message getFault() {
        return this.getFault(true);
    }

    public Message getFault(boolean lazyCreate) {
        if (this.fault == null && lazyCreate && this.pattern != Pattern.InOnly) {
            this.fault = this.createMessage();
        }
        return this.fault;
    }

    public void setFault(Message message) {
        this.fault = message;
    }

    public Message getMessage(Type type) {
        return this.getMessage(type, true);
    }

    public Message getMessage(Type type, boolean lazyCreate) {
        switch (type) {
            case In: {
                return this.getIn(lazyCreate);
            }
            case Out: {
                return this.getOut(lazyCreate);
            }
            case Fault: {
                return this.getFault(lazyCreate);
            }
        }
        throw new IllegalArgumentException();
    }

    public void setMessage(Type type, Message message) {
        switch (type) {
            case In: {
                this.setIn(message);
                break;
            }
            case Out: {
                this.setOut(message);
                break;
            }
            case Fault: {
                this.setFault(message);
            }
        }
    }

    protected Message createMessage() {
        return new MessageImpl();
    }

    public Exception getError() {
        return this.error;
    }

    public void setError(Exception error) {
        this.error = error;
        this.status = Status.Error;
    }

    public void copyFrom(Exchange exchange) {
        this.error = exchange.getError();
        if (exchange.getIn(false) != null) {
            this.in = exchange.getIn().copy();
        }
        if (exchange.getOut(false) != null) {
            this.out = exchange.getOut().copy();
        }
        if (exchange.getFault(false) != null) {
            this.fault = exchange.getFault().copy();
        }
        this.pattern = exchange.getPattern();
        this.properties = new HashMap<String, Object>(exchange.getProperties());
    }

    public Exchange copy() {
        ExchangeImpl copy = new ExchangeImpl();
        copy.copyFrom(this);
        return copy;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    public String display(boolean displayContent) {
        return ExchangeUtils.display(this, displayContent);
    }

    public String toString() {
        return this.display(false);
    }
}

