/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.management.resources;

import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.ebpm.core.BaseSpagicService;
import org.eclipse.ebpm.datasource.DataSource;
import org.eclipse.ebpm.datasource.IDataSourceManager;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;

public class GetResourceService
extends BaseSpagicService {
    protected final AtomicReference<IDataSourceManager> datasourceManager = new AtomicReference<Object>(null);

    public IDataSourceManager getDataSourceManager() {
        return this.datasourceManager.get();
    }

    public void setDataSourceManager(IDataSourceManager dsm) {
        this.datasourceManager.set(dsm);
    }

    public void unsetDataSourceManager(IDataSourceManager dsManager) {
        this.datasourceManager.compareAndSet(dsManager, null);
    }

    public boolean run(Exchange exchange, Message in, Message out) throws Exception {
        Document doc = DocumentHelper.createDocument();
        Element rootElement = doc.addElement("DATASOURCES");
        Set ids = this.getDataSourceManager().getRegisteredDatasourcesIDs();
        javax.sql.DataSource ds = null;
        for (String id : ids) {
            ds = this.getDataSourceManager().getDataSource(id);
            Element dsElement = rootElement.addElement("DATASOURCE");
            dsElement.addAttribute("name", id);
            if (!(ds instanceof DataSource)) continue;
            dsElement.addAttribute("driver", ((DataSource)ds).getDriverClassName());
            dsElement.addAttribute("user", ((DataSource)ds).getUsername());
            dsElement.addAttribute("url", ((DataSource)ds).getUrl());
            dsElement.addAttribute("password", ((DataSource)ds).getPassword());
        }
        out.setBody(doc.asXML());
        return true;
    }
}

