/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.Message;
import javax.mail.search.SearchTerm;

public final class AndTerm
extends SearchTerm {
    protected SearchTerm[] terms;
    private static final long serialVersionUID = -3583274505380989582L;

    public AndTerm(SearchTerm t1, SearchTerm t2) {
        this.terms = new SearchTerm[2];
        this.terms[0] = t1;
        this.terms[1] = t2;
    }

    public AndTerm(SearchTerm[] t) {
        this.terms = new SearchTerm[t.length];
        int i = 0;
        while (i < t.length) {
            this.terms[i] = t[i];
            ++i;
        }
    }

    public SearchTerm[] getTerms() {
        return (SearchTerm[])this.terms.clone();
    }

    @Override
    public boolean match(Message msg) {
        int i = 0;
        while (i < this.terms.length) {
            if (!this.terms[i].match(msg)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AndTerm)) {
            return false;
        }
        AndTerm at = (AndTerm)obj;
        if (at.terms.length != this.terms.length) {
            return false;
        }
        int i = 0;
        while (i < this.terms.length) {
            if (!this.terms[i].equals(at.terms[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        int i = 0;
        while (i < this.terms.length) {
            hash += this.terms[i].hashCode();
            ++i;
        }
        return hash;
    }
}

