/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.soap.interceptors.mime;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.ebpm.soap.api.Fault;
import org.eclipse.ebpm.soap.api.InterceptorChain;
import org.eclipse.ebpm.soap.api.Message;
import org.eclipse.ebpm.soap.core.AbstractInterceptor;

public class AttachmentsOutInterceptor
extends AbstractInterceptor {
    public static final String PIPE_ATTACHMENT_STREAM = "PipeAttachmentStream";
    public static final String SOAP_PART_ID = "soap-request";

    @Override
    public void handleMessage(Message message) {
        if (message.getAttachments().size() == 0) {
            return;
        }
        OutputStream os = message.getContent(OutputStream.class);
        if (os == null) {
            throw new NullPointerException("OutputStream content not found");
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            message.setContent(OutputStream.class, baos);
            message.put("Content-Type", "multipart/related; type=\"text/xml\"; start=\"<soap-request>\"");
            InterceptorChain chain = message.get(InterceptorChain.class);
            chain.doIntercept(message);
            this.writeMultipartMessage(message, os, baos.toByteArray());
        }
        catch (MessagingException e) {
            throw new Fault(e);
        }
        catch (IOException e) {
            throw new Fault(e);
        }
    }

    protected boolean getBoolean(Message message, String name, boolean def) {
        Object b = message.get(name);
        if (b instanceof Boolean) {
            return (Boolean)b;
        }
        if (b != null) {
            return Boolean.parseBoolean(b.toString());
        }
        return def;
    }

    private void writeMultipartMessage(Message message, OutputStream out, byte[] data) throws MessagingException, IOException {
        MimeMultipart parts = new MimeMultipart("related; type=\"text/xml\"; start=\"<soap-request>\"");
        Session session = Session.getDefaultInstance((Properties)new Properties(), null);
        MimeMessage mime = new MimeMessage(session);
        MimeBodyPart soapPart = new MimeBodyPart();
        soapPart.setContentID("<soap-request>");
        soapPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(data, "text/xml")));
        soapPart.setHeader("Content-Transfer-Encoding", "binary");
        soapPart.setHeader("Content-Type", "text/xml; charset=UTF-8");
        parts.addBodyPart((BodyPart)soapPart);
        for (Map.Entry<String, DataHandler> entry : message.getAttachments().entrySet()) {
            String id = entry.getKey();
            DataHandler dh = entry.getValue();
            MimeBodyPart part = new MimeBodyPart();
            part.setDataHandler(dh);
            part.setContentID(id);
            part.setHeader("Content-Transfer-Encoding", "binary");
            part.setHeader("Content-Type", "application/octet-stream");
            parts.addBodyPart((BodyPart)part);
        }
        mime.setContent((Multipart)parts);
        mime.setHeader("Content-Type", parts.getContentType());
        HttpServletResponse httpResponse = message.get(HttpServletResponse.class);
        if (httpResponse != null) {
            httpResponse.setContentType(null);
            httpResponse.setContentType(parts.getContentType());
        }
        mime.saveChanges();
        Enumeration headersEnum = mime.getAllHeaders();
        ArrayList<String> headersList = new ArrayList<String>();
        while (headersEnum.hasMoreElements()) {
            String tmp = ((Header)headersEnum.nextElement()).getName();
            headersList.add(tmp);
        }
        String[] headers = headersList.toArray(new String[0]);
        FilterOutputStream os = new FilterOutputStream(out){
            private int nb;
            {
                this.nb = 0;
            }

            @Override
            public void write(int b) throws IOException {
                if (++this.nb > 2) {
                    super.write(b);
                }
            }
        };
        mime.writeTo((OutputStream)os, headers);
    }
}

