/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.soap.bindings.soap.interceptors;

import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.soap.api.Message;
import org.eclipse.ebpm.soap.api.model.Operation;
import org.eclipse.ebpm.soap.bindings.soap.model.SoapOperation;
import org.eclipse.ebpm.soap.core.AbstractInterceptor;

public class SoapActionOutOperationInterceptor
extends AbstractInterceptor {
    @Override
    public void handleMessage(Message message) {
        Operation operation = message.get(Operation.class);
        Exchange nmrExchange = message.getContent(Exchange.class);
        if (!(operation instanceof SoapOperation)) {
            Boolean mustSetByExchange = (Boolean)nmrExchange.getProperty("mustSetOperation");
            if (mustSetByExchange != null && mustSetByExchange.booleanValue()) {
                message.getTransportHeaders().put("SOAPAction", (String)nmrExchange.getProperty("SOAPAction"));
            } else {
                message.getTransportHeaders().put("SOAPAction", "");
            }
            return;
        }
        SoapOperation cfr_ignored_0 = (SoapOperation)operation;
        String soapAction = ((SoapOperation)operation).getSoapAction();
        if (soapAction != null) {
            if (!soapAction.startsWith("\"") || !soapAction.endsWith("\"")) {
                soapAction = "\"" + soapAction + "\"";
            }
        } else {
            soapAction = "\"\"";
        }
        message.getTransportHeaders().put("SOAPAction", soapAction);
    }
}

