/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.soap.bindings.soap.interceptors;

import java.util.ArrayList;
import org.eclipse.ebpm.soap.api.Message;
import org.eclipse.ebpm.soap.api.model.Binding;
import org.eclipse.ebpm.soap.api.model.Operation;
import org.eclipse.ebpm.soap.bindings.soap.model.SoapBinding;
import org.eclipse.ebpm.soap.bindings.soap.model.SoapOperation;
import org.eclipse.ebpm.soap.core.AbstractInterceptor;

public class SoapActionInOperationInterceptor
extends AbstractInterceptor {
    @Override
    public void handleMessage(Message message) {
        if (message.get(Operation.class) != null) {
            return;
        }
        String soapAction = message.getTransportHeaders().get("SOAPAction");
        if (soapAction != null) {
            if ((soapAction = soapAction.trim()).startsWith("\"") && soapAction.endsWith("\"")) {
                soapAction = soapAction.substring(1, soapAction.length() - 1);
            }
            if (soapAction.length() > 0) {
                SoapBinding binding = (SoapBinding)message.get(Binding.class);
                ArrayList<SoapOperation> matching = new ArrayList<SoapOperation>();
                for (SoapOperation operation : binding.getOperations()) {
                    if (!soapAction.equals(operation.getSoapAction())) continue;
                    matching.add(operation);
                }
                if (matching.size() == 1) {
                    message.put(Operation.class, (Operation)matching.get(0));
                }
            }
        }
    }
}

