/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.soap.bindings.http.interceptors;

import java.io.InputStream;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.ebpm.soap.api.Fault;
import org.eclipse.ebpm.soap.api.Message;
import org.eclipse.ebpm.soap.api.model.Binding;
import org.eclipse.ebpm.soap.api.model.Operation;
import org.eclipse.ebpm.soap.api.model.wsdl2.Wsdl2Message;
import org.eclipse.ebpm.soap.bindings.http.interceptors.IriDecoderHelper;
import org.eclipse.ebpm.soap.bindings.http.model.Wsdl2HttpBinding;
import org.eclipse.ebpm.soap.bindings.http.model.Wsdl2HttpMessage;
import org.eclipse.ebpm.soap.bindings.http.model.Wsdl2HttpOperation;
import org.eclipse.ebpm.soap.core.AbstractInterceptor;
import org.w3c.dom.Document;

public class HttpDecoderInterceptor
extends AbstractInterceptor {
    private final boolean server;

    public HttpDecoderInterceptor(boolean server) {
        this.server = server;
    }

    @Override
    public void handleMessage(Message message) {
        String serialization;
        Wsdl2HttpMessage httpMessage;
        Operation operation = message.get(Operation.class);
        if (!(operation instanceof Wsdl2HttpOperation)) {
            return;
        }
        Wsdl2HttpBinding httpBinding = (Wsdl2HttpBinding)message.get(Binding.class);
        Wsdl2HttpOperation httpOperation = (Wsdl2HttpOperation)operation;
        if (this.server) {
            httpMessage = (Wsdl2HttpMessage)httpOperation.getInput();
            serialization = httpOperation.getHttpInputSerialization();
        } else {
            httpMessage = (Wsdl2HttpMessage)httpOperation.getOutput();
            serialization = httpOperation.getHttpOutputSerialization();
        }
        if (httpMessage.getContentModel() == Wsdl2Message.ContentModel.ELEMENT || httpMessage.getContentModel() == Wsdl2Message.ContentModel.ANY) {
            if ("application/x-www-form-urlencoded".equals(serialization)) {
                this.normalizeUrlEncoded(message, httpBinding, httpOperation, httpMessage);
            } else if ("multipart/form-data".equals(serialization)) {
                this.normalizeFormData(message);
            } else {
                this.normalizeXml(message);
            }
        } else if (httpMessage.getContentModel() == Wsdl2Message.ContentModel.NONE) {
            if (message.getContent(Source.class) != null) {
                throw new Fault("No content allowed");
            }
        } else {
            throw new Fault("Unsupported content model: " + (Object)((Object)httpMessage.getContentModel()));
        }
    }

    private void normalizeXml(Message message) {
    }

    private void normalizeFormData(Message message) {
    }

    private void normalizeUrlEncoded(Message message, Wsdl2HttpBinding binding, Wsdl2HttpOperation httpOperation, Wsdl2HttpMessage httpMessage) {
        InputStream is = message.getContent(InputStream.class);
        String uri = message.getTransportHeaders().get("REQUEST_URI");
        String loc = IriDecoderHelper.combine(binding.getLocation(), httpOperation.getHttpLocation());
        List<IriDecoderHelper.Param> params = IriDecoderHelper.decode(uri, loc, is);
        Document doc = IriDecoderHelper.buildDocument(httpMessage.getElementDeclaration(), params);
        message.setContent(Source.class, new DOMSource(doc));
    }
}

