/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class HTTPProtocolConstants {
    public static final String HTTP_CONTENT_TRANSFER_ENC = "Content-Transfer-Encoding";
    public static final String HTTP_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String _HTTP_BODY = "HTTP-BODY";
    public static final String _HTTP_ERR = "HTTP-ERROR";
    public static final String HTTP_ATTACH_CONTENT_TYPE_HEADER_SUFFIX = "-content_type";
    public static final String HTTP_HV_RELATED = "related; type=\"text/xml\"; start=\"<soap-request>\"";
    public static final String HTTP_HV_FORMDATA = "form-data";
    public static final String HTTP_HV_APPL_URL_ENC = "application/x-www-form-urlencoded";
    public static final String HTTP_HV_ENC_8BIT = "8bit";
    public static final String HTTP_HV_ENC_BIN = "binary";
    public static final String HTTP_HV_TEXT_XML = "text/xml";
    public static final String HTTP_HV_TEXT_XML_UTF8 = "text/xml; charset=UTF-8";
    public static final String HTTP_HV_APPL_OCTET = "application/octet-stream";
    public static final String HTTPPLAIN_CFG_CONTENT = "contentType";
    public static final String HTTPPLAIN_CFG_METHOD = "method";
    public static final String HTTPPLAIN_CFG_PARAMS = "params";
    public static final String HTTPPLAIN_CFG_MULTIPART_POLICY = "multipartPolicy";
    public static final String HTTPPLAIN_CFG_ERROR_POLICY = "errorPolicy";
    public static final String _UTF8_ = "UTF-8";
    public static final String HTTP_CONTENT_TYPE = "Content-Type";

    public static String createXMLBody(String body) {
        String xmlBody = null;
        try {
            Document document = DocumentHelper.createDocument();
            document.setXMLEncoding(_UTF8_);
            Element message = document.addElement(_HTTP_BODY);
            message.addCDATA(body);
            xmlBody = message.asXML();
        }
        catch (Exception exception) {}
        return xmlBody;
    }

    public static String createXMLError(int code, String body) {
        String xmlErr = null;
        try {
            Document document = DocumentHelper.createDocument();
            document.setXMLEncoding(_UTF8_);
            Element message = document.addElement(_HTTP_ERR);
            message.addAttribute("code", "" + code);
            message.addCDATA(body);
            xmlErr = message.asXML();
        }
        catch (Exception exception) {}
        return xmlErr;
    }

    public static String convertStreamToString(InputStream is) {
        StringBuilder sb;
        block13: {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            sb = new StringBuilder();
            String line = null;
            try {
                try {
                    int numLine = 0;
                    while ((line = reader.readLine()) != null) {
                        if (numLine > 0) {
                            sb.append("\n");
                        }
                        sb.append(line);
                        ++numLine;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public static boolean isXML(InputStream is) {
        boolean isxml = false;
        try {
            SAXReader reader = new SAXReader();
            reader.read(is);
            isxml = true;
        }
        catch (Exception exception) {}
        return isxml;
    }
}

