/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.mail.utils;

import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;

public class MailConnectionConfiguration {
    private String host;
    private String password;
    private String protocol;
    private String username;
    private boolean startTLS = false;
    private String folderName = "INBOX";
    private int port = -1;

    public MailConnectionConfiguration() {
    }

    public MailConnectionConfiguration(String host, String password, String protocol, String username, boolean startTLS, String folderName, int port) {
        this.host = host;
        this.password = password;
        this.protocol = protocol;
        this.username = username;
        this.startTLS = startTLS;
        this.folderName = folderName;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProtocol() {
        return this.protocol.toLowerCase();
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isSecureProtocol() {
        return this.protocol.equalsIgnoreCase("smtps") || this.protocol.equalsIgnoreCase("pop3s") || this.protocol.equalsIgnoreCase("imaps");
    }

    public Authenticator getAuthenticator() {
        return new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                PasswordAuthentication pa = new PasswordAuthentication(MailConnectionConfiguration.this.getUsername(), MailConnectionConfiguration.this.getPassword());
                return pa;
            }
        };
    }

    public boolean isStartTLS() {
        return this.startTLS;
    }

    public void setStartTLS(boolean startTLS) {
        this.startTLS = startTLS;
    }
}

