/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.invm.common;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.ebpm.client.api.ClientMessage;

public class Response
implements Future<ClientMessage> {
    private static long sleepInterval;
    private ClientMessage cm;

    public Response(long sleepInterval) {
        Response.sleepInterval = sleepInterval;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClientMessage get() throws InterruptedException, ExecutionException {
        do {
            Thread.sleep(sleepInterval);
        } while (this.cm == null);
        return this.cm;
    }

    @Override
    public ClientMessage get(long duration, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long limit = TimeUnit.MILLISECONDS.convert(duration, unit);
        long currentTime = 0L;
        do {
            Thread.sleep(sleepInterval);
            currentTime += sleepInterval;
            if (this.cm == null) continue;
            return this.cm;
        } while (currentTime < limit);
        throw new TimeoutException();
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.cm != null;
    }

    public void setResponse(ClientMessage cm) {
        this.cm = cm;
    }
}

