/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.jms.endpoints;

import java.util.Dictionary;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSession;
import org.eclipse.ebpm.connectors.jms.endpoints.TextListener;
import org.eclipse.ebpm.connectors.jms.marshaler.DefaultConsumerMarshaler;
import org.eclipse.ebpm.connectors.jms.marshaler.JmsConsumerMarshaler;
import org.eclipse.ebpm.core.AbstractSpagicConnector;
import org.eclipse.ebpm.jms.connectionfactory.ConnectionFactory;
import org.eclipse.ebpm.jms.connectionfactory.IConnectionFactoryManager;
import org.eclipse.ebpm.util.properties.PropertyConfigurator;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsConsumerEndpoint
extends AbstractSpagicConnector {
    protected final AtomicReference<IConnectionFactoryManager> connectionFactoryManager = new AtomicReference<Object>(null);
    private JmsConsumerMarshaler marshaler = new DefaultConsumerMarshaler();
    private boolean pubSubDomain;
    protected String connectionFactoryName;
    private ConnectionFactory connectionFactory;
    private Connection queueConnection;
    private Session session;
    private MessageConsumer receiver;
    private MessageListener listener;
    protected Logger logger = LoggerFactory.getLogger(JmsConsumerEndpoint.class);
    private Destination destination;
    private String destinationName;
    private String messageSelector;

    public void init() {
        this.connectionFactoryName = this.propertyConfigurator.getString("connectionFactoryName");
        try {
            this.connectionFactory = this.getConnectionFactoryManager().getConnectionFactory(this.connectionFactoryName);
        }
        catch (Exception e) {
            this.logger.warn(e.getMessage());
        }
        this.pubSubDomain = this.propertyConfigurator.getBoolean("pubSubDomain");
        this.destinationName = this.propertyConfigurator.getString("destinationName");
    }

    public IConnectionFactoryManager getConnectionFactoryManager() {
        return this.connectionFactoryManager.get();
    }

    public void setConnectionFactoryManager(IConnectionFactoryManager cfm) {
        this.connectionFactoryManager.set(cfm);
    }

    public void unsetConnectionFactoryManager(IConnectionFactoryManager cfm) {
        this.connectionFactoryManager.compareAndSet(cfm, null);
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public boolean isPubSubDomain() {
        return this.pubSubDomain;
    }

    public void setPubSubDomain(boolean pubSubDomain) {
        this.pubSubDomain = pubSubDomain;
    }

    public JmsConsumerMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(JmsConsumerMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public void start() throws Exception {
        this.validate();
        if (this.getConnectionFactory() == null) {
            return;
        }
        try {
            this.queueConnection = this.connectionFactory.createConnection();
            this.session = this.queueConnection.createSession(false, 1);
            this.destination = this.connectionFactory.getDestination(this.pubSubDomain, this.destinationName);
            this.receiver = this.pubSubDomain ? ((TopicSession)this.session).createSubscriber((Topic)this.destination) : ((QueueSession)this.session).createReceiver((Queue)this.destination);
            this.queueConnection.start();
            this.listener = new TextListener(this, this.getMarshaler());
            this.receiver.setMessageListener(this.listener);
            super.start();
        }
        catch (Exception e) {
            this.logger.error("Unable to start JMS connector", (Throwable)e);
            this.stop();
        }
    }

    public void stop() throws Exception {
        block20: {
            block18: {
                block16: {
                    if (this.receiver != null) {
                        try {
                            try {
                                this.receiver.close();
                            }
                            catch (JMSException e1) {
                                this.logger.error("Problems during JMS connector shutdown", (Throwable)e1);
                                this.receiver = null;
                                break block16;
                            }
                        }
                        catch (Throwable throwable) {
                            this.receiver = null;
                            throw throwable;
                        }
                        this.receiver = null;
                    }
                }
                if (this.session != null) {
                    try {
                        try {
                            this.session.close();
                        }
                        catch (JMSException e1) {
                            this.logger.error("Problems during JMS connector shutdown", (Throwable)e1);
                            this.session = null;
                            break block18;
                        }
                    }
                    catch (Throwable throwable) {
                        this.session = null;
                        throw throwable;
                    }
                    this.session = null;
                }
            }
            if (this.queueConnection != null) {
                try {
                    try {
                        this.queueConnection.stop();
                        this.queueConnection.close();
                    }
                    catch (JMSException e1) {
                        this.logger.error("Problems during JMS connector shutdown", (Throwable)e1);
                        this.queueConnection = null;
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    this.queueConnection = null;
                    throw throwable;
                }
                this.queueConnection = null;
            }
        }
        super.stop();
    }

    public void validate() {
        if (this.destination == null && this.destinationName == null) {
            throw new RuntimeException("destination or destinationName is required");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleInternalEvent(Event event) {
        this.logger.info("JMSConsumerEndpoint[" + this.getSpagicId() + "] handle internal Event Start Event [" + event + "]");
        String evType = (String)event.getProperty("_INTERNAL_EVENT_TYPE");
        if (evType.equalsIgnoreCase("_INTERNAL_EVENT_CF_DEPLOYED")) {
            String id = (String)event.getProperty("_INTERNAL_EVENT_REFERRING_ID");
            this.logger.info("JMSConsumerEndpoint[" + this.getSpagicId() + "]::ConnectionFactory [" + id + "] Registered on ConnectionFactoryManager");
            if (id.equals(this.connectionFactoryName)) {
                this.logger.info("JMSConsumerEndpoint[" + this.getSpagicId() + "]:: Reacting to ConnectionFactory[" + id + "] registration");
                JmsConsumerEndpoint jmsConsumerEndpoint = this;
                synchronized (jmsConsumerEndpoint) {
                    try {
                        this.setConnectionFactory(this.getConnectionFactoryManager().getConnectionFactory(this.connectionFactoryName));
                        this.start();
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            this.logger.info("JMSConsumerEndpoint[" + this.getSpagicId() + "]:: Discard ConnectionFactory[" + id + "] registration, interested in [" + this.connectionFactoryName + "]");
            return;
        }
        if (evType.equalsIgnoreCase("_INTERNAL_EVENT_CF_UNDEPLOYED")) {
            String id = (String)event.getProperty("_INTERNAL_EVENT_REFERRING_ID");
            this.logger.info("JMSConsumerEndpoint[" + this.getSpagicId() + "]::ConnectionFactory [" + id + "] UnRegistered on ConnectionFactoryManager");
            if (id.equals(this.connectionFactoryName)) {
                this.logger.info("JMSConsumerEndpoint[" + this.getSpagicId() + "]::Reacting to ConnectionFactory[" + id + "] UnRegistration");
                JmsConsumerEndpoint jmsConsumerEndpoint = this;
                synchronized (jmsConsumerEndpoint) {
                    try {
                        this.stop();
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            this.logger.info("JMSConsumerEndpoint[" + this.getSpagicId() + "]::Discard ConnectionFactory[" + id + "] UnRegistration, interested in [" + this.connectionFactoryName + "]");
            return;
        }
    }

    protected void activate(ComponentContext componentContext) {
        Dictionary propertiesDictionary = componentContext.getProperties();
        this.propertyConfigurator = new PropertyConfigurator(propertiesDictionary);
        this.spagicId = this.propertyConfigurator.getString("spagic.id");
        IConnectionFactoryManager cfManager = this.getConnectionFactoryManager();
        cfManager.registerForNotification(this.getSpagicId());
        super.activate(componentContext);
    }
}

