/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.TimerTask;
import javax.sql.DataSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.ebpm.connectors.jdbc.JDBCPoller;
import org.eclipse.ebpm.connectors.jdbc.PollingParameters;
import org.eclipse.ebpm.connectors.jdbc.StatementElement;
import org.eclipse.ebpm.core.routing.IMessageRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingTask
extends TimerTask {
    protected Logger log = LoggerFactory.getLogger(JDBCPoller.class);
    private static final String KEY_QUERY = "SELECT VALUE FROM KEY_VALUES WHERE ID=? FOR UPDATE";
    private static final String KEY_INSERT = "INSERT INTO KEY_VALUES (ID,VALUE) VALUES (?,?)";
    private static final String KEY_UPDATE = "UPDATE KEY_VALUES SET VALUE=? WHERE ID=?";
    private PollingParameters pollingParams;
    private DataSource datasource;
    private DataSource keyDatasource;
    private JDBCPoller poller;
    private String target = null;
    private boolean initialized = false;

    public DataSource getDatasource() {
        return this.datasource;
    }

    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }

    public String getKeyCreationStatement() {
        return this.pollingParams.keyCreationStatement;
    }

    public PollingTask(PollingParameters pollingParams, JDBCPoller poller, String target) throws Exception {
        this.pollingParams = pollingParams;
        this.poller = poller;
        this.target = target;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initializeKey() {
        Connection keyConnection;
        block18: {
            if (this.initialized) {
                return;
            }
            keyConnection = null;
            keyConnection = this.openKeyConnection();
            if (keyConnection != null) break block18;
            if (keyConnection == null) return;
            try {
                keyConnection.setAutoCommit(true);
                keyConnection.close();
                return;
            }
            catch (SQLException sQLException) {
                this.log.error("Unable to close key connection");
            }
            return;
        }
        try {
            try {
                keyConnection.setAutoCommit(false);
                this.updateConditionKey(keyConnection, null, null);
                this.log.debug("Table for keys already existing");
                try {
                    this.getConditionKey(keyConnection, this.pollingParams.commPointID);
                    keyConnection.commit();
                    this.log.debug("Row for condition key already existing");
                    this.initialized = true;
                }
                catch (ConditionKeyNotFoundException conditionKeyNotFoundException) {
                    this.insertConditionKey(keyConnection, this.pollingParams.initialKeyValue, this.pollingParams.commPointID);
                    this.log.debug("Row for condition key created");
                    this.initialized = true;
                }
            }
            catch (Exception exception) {
                this.log.debug("Trying to create table for keys");
                try {
                    this.createConditionKeyTable(keyConnection, this.pollingParams.initialKeyValue, this.pollingParams.commPointID);
                    this.initialized = true;
                }
                catch (Exception exception2) {
                    this.log.debug("Unable to create table for keys");
                }
                if (keyConnection == null) return;
                try {
                    keyConnection.setAutoCommit(true);
                    keyConnection.close();
                    return;
                }
                catch (SQLException sQLException) {
                    this.log.error("Unable to close key connection");
                }
                return;
            }
        }
        catch (Throwable throwable) {
            if (keyConnection == null) throw throwable;
            try {
                keyConnection.setAutoCommit(true);
                keyConnection.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                this.log.error("Unable to close key connection");
            }
            throw throwable;
        }
        if (keyConnection == null) return;
        try {
            keyConnection.setAutoCommit(true);
            keyConnection.close();
            return;
        }
        catch (SQLException sQLException) {
            this.log.error("Unable to close key connection");
        }
    }

    protected Connection openConnection() throws ClassNotFoundException, SQLException {
        Connection conn = null;
        if (this.datasource == null) {
            this.log.debug("Lookup of datasource: " + this.pollingParams.datasourceName);
            try {
                try {
                    this.datasource = this.poller.getDataSourceManager().getDataSource(this.pollingParams.datasourceName);
                }
                catch (Exception exception) {
                    this.log.warn("Datasource " + this.pollingParams.datasourceName + " not available. Polling not executed.");
                    return null;
                }
            }
            catch (Exception e) {
                this.log.error("Error during lookup of datasource", (Throwable)e);
                try {
                    this.log.error("Deactivating polling task for JDBC Poller");
                    this.cancel();
                    this.poller = null;
                }
                catch (Exception exception) {
                    this.log.error("Error deactivating component JDBC Poller");
                }
            }
        }
        conn = this.datasource.getConnection();
        return conn;
    }

    @Override
    public void run() {
        block18: {
            try {
                IMessageRouter router = this.poller.getMessageRouter();
                if (!router.isServiceRegistered(this.target)) {
                    this.log.warn("Target Service [" + this.target + "] is not Registered, cannot fire message");
                    return;
                }
            }
            catch (Throwable th) {
                this.log.error("Error during polling ", th);
                return;
            }
            this.initializeKey();
            if (!this.initialized) {
                return;
            }
            this.log.debug("Entering pollDatabase");
            Connection conn = null;
            try {
                try {
                    conn = this.openConnection();
                    conn.setAutoCommit(false);
                    this.executeStatement(conn, this.pollingParams.rootStatement);
                }
                catch (Exception ex) {
                    this.log.error("Error executing statement", (Throwable)ex);
                    try {
                        if (conn != null && !conn.isClosed()) {
                            conn.setAutoCommit(true);
                            conn.close();
                        }
                        break block18;
                    }
                    catch (Exception ex2) {
                        this.log.error("Error closing connection", (Throwable)ex2);
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null && !conn.isClosed()) {
                        conn.setAutoCommit(true);
                        conn.close();
                    }
                }
                catch (Exception ex) {
                    this.log.error("Error closing connection", (Throwable)ex);
                }
                throw throwable;
            }
            try {
                if (conn != null && !conn.isClosed()) {
                    conn.setAutoCommit(true);
                    conn.close();
                }
            }
            catch (Exception ex) {
                this.log.error("Error closing connection", (Throwable)ex);
            }
        }
        this.log.debug("Exiting pollDatabase");
    }

    protected String handleBinary(Object value) {
        if (value != null) {
            return new String(Base64.encodeBase64((byte[])((byte[])value)));
        }
        this.log.debug("BinaryValue is Null returning empty string");
        return "";
    }

    protected String handleBlob(Blob aBlob) {
        block4: {
            this.log.debug("Handling BLOB");
            if (aBlob != null) break block4;
            this.log.info("Handling BLOB->Blob is null return an empty string");
            return "null";
        }
        try {
            int inByte;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.log.debug("Calling Blog get Binary Stream");
            InputStream inputStream = aBlob.getBinaryStream();
            this.log.debug("Writing BLOB TO Temporary Array");
            while ((inByte = inputStream.read()) != -1) {
                byteArrayOutputStream.write(inByte);
            }
            byteArrayOutputStream.flush();
            byte[] returnBytes = byteArrayOutputStream.toByteArray();
            this.log.debug("BLOB Readed in bytearray of length[" + returnBytes.length + "]");
            byteArrayOutputStream.close();
            return this.handleBinary(returnBytes);
        }
        catch (Exception e) {
            this.log.error("Error managing a BLOB", (Throwable)e);
            return "null";
        }
    }

    protected void executeStatement(Connection conn, StatementElement currentStatement) throws Exception {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String conditionKey = null;
        String keyValue = null;
        this.log.debug("Executing statement " + currentStatement.getSql());
        try {
            stmt = conn.prepareStatement(currentStatement.getSql());
            conditionKey = this.getConditionKey(conn, this.pollingParams.commPointID);
            stmt.setString(1, conditionKey);
            rs = stmt.executeQuery();
            ResultSetMetaData metadata = rs.getMetaData();
            int columnCount = metadata.getColumnCount();
            String[] columnNames = new String[columnCount];
            String[] resultValues = new String[columnCount];
            int i = 0;
            while (i < columnCount) {
                columnNames[i] = metadata.getColumnName(i + 1);
                ++i;
            }
            int messageCount = 0;
            StringBuffer collectionMessageString = new StringBuffer();
            int numMex = 0;
            while (rs.next()) {
                keyValue = rs.getString(this.pollingParams.keyColumn);
                int i2 = 0;
                while (i2 < columnCount) {
                    this.log.debug("Analyze type of column(" + (i2 + 1) + ")");
                    this.log.debug(" Column [" + (i2 + 1) + "] has type [" + JDBCPoller.getJdbcTypeName(metadata.getColumnType(i2 + 1)) + "]");
                    if (metadata.getColumnType(i2 + 1) == -2) {
                        this.log.debug("Treat column(" + (i2 + 1) + ") as BINARY");
                        resultValues[i2] = this.handleBinary(rs.getObject(i2 + 1));
                    } else if (metadata.getColumnType(i2 + 1) == 2004) {
                        this.log.debug("Treat column(" + (i2 + 1) + ") as BLOB");
                        resultValues[i2] = this.handleBlob(rs.getBlob(i2 + 1));
                    } else {
                        this.log.debug("Treat column(" + (i2 + 1) + ") as normal get Column using rs.getString");
                        resultValues[i2] = rs.getString(i2 + 1);
                    }
                    ++i2;
                }
                this.buildStartMessageString(currentStatement.getName(), columnNames, resultValues, collectionMessageString);
                this.buildBodyMessageString(currentStatement.getName(), columnNames, resultValues, collectionMessageString);
                StatementElement[] subQueries = currentStatement.getSubQueries();
                if (subQueries != null) {
                    int i3 = 0;
                    while (i3 < subQueries.length) {
                        StringBuffer subStatementResult = this.executeSubStatement(conn, subQueries[i3], columnNames, resultValues);
                        if (subStatementResult != null) {
                            collectionMessageString.append(subStatementResult);
                        }
                        ++i3;
                    }
                }
                this.buildEndMessageString(currentStatement.getName(), columnNames, resultValues, collectionMessageString);
                if (this.pollingParams.rowsInMessage == ++messageCount) {
                    this.poller.sendMessage(collectionMessageString);
                    messageCount = 0;
                    collectionMessageString = new StringBuffer();
                }
                if (this.pollingParams.maxMessagesPerUnit > 0 && ++numMex >= this.pollingParams.maxMessagesPerUnit) break;
            }
            if (collectionMessageString.length() != 0) {
                this.poller.sendMessage(collectionMessageString);
            }
        }
        catch (Throwable throwable) {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                finally {
                    if (keyValue != null) {
                        this.updateConditionKey(conn, this.pollingParams.commPointID, keyValue);
                    } else {
                        conn.commit();
                    }
                }
            }
            throw throwable;
        }
        try {
            if (rs != null) {
                rs.close();
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            finally {
                if (keyValue != null) {
                    this.updateConditionKey(conn, this.pollingParams.commPointID, keyValue);
                } else {
                    conn.commit();
                }
            }
        }
    }

    protected StringBuffer executeSubStatement(Connection conn, StatementElement currentStatement, String[] parentColumnNames, String[] parentResultValues) throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        this.log.debug("Preparing statement " + currentStatement.getSql());
        try {
            int i;
            String originalStatement;
            String modifiedStatement = originalStatement = currentStatement.getSql();
            while (modifiedStatement.indexOf(64) != -1) {
                int atIndex = modifiedStatement.indexOf(64);
                int endIndex = modifiedStatement.indexOf(32, atIndex);
                if (endIndex == -1) {
                    endIndex = modifiedStatement.length();
                }
                String parameterName = modifiedStatement.substring(atIndex + 1, endIndex);
                String parameterValue = null;
                i = 0;
                while (i < parentColumnNames.length) {
                    if (parameterName.equalsIgnoreCase(parentColumnNames[i])) {
                        parameterValue = parentResultValues[i];
                        break;
                    }
                    ++i;
                }
                if (parameterValue != null) {
                    modifiedStatement = modifiedStatement.replaceFirst("@" + parameterName, "'" + parameterValue + "'");
                    continue;
                }
                this.log.error("Unable to retrieve parameter value for parameter " + parameterName);
                return null;
            }
            this.log.debug("Executing statement " + modifiedStatement);
            stmt = conn.prepareStatement(modifiedStatement);
            rs = stmt.executeQuery();
            ResultSetMetaData metadata = rs.getMetaData();
            int columnCount = metadata.getColumnCount();
            String[] columnNames = new String[columnCount];
            String[] resultValues = new String[columnCount];
            i = 0;
            while (i < columnCount) {
                columnNames[i] = metadata.getColumnName(i + 1);
                ++i;
            }
            StringBuffer childRowsMessageString = new StringBuffer();
            while (rs.next()) {
                int i2 = 0;
                while (i2 < columnCount) {
                    resultValues[i2] = rs.getString(i2 + 1);
                    ++i2;
                }
                this.buildStartMessageString(currentStatement.getName(), columnNames, resultValues, childRowsMessageString);
                this.buildBodyMessageString(currentStatement.getName(), columnNames, resultValues, childRowsMessageString);
                StatementElement[] subQueries = currentStatement.getSubQueries();
                if (subQueries != null) {
                    int i3 = 0;
                    while (i3 < subQueries.length) {
                        StringBuffer subMessage = this.executeSubStatement(conn, subQueries[i3], columnNames, resultValues);
                        if (subMessage != null) {
                            childRowsMessageString.append(subMessage);
                        }
                        ++i3;
                    }
                }
                this.buildEndMessageString(currentStatement.getName(), columnNames, resultValues, childRowsMessageString);
            }
            StringBuffer stringBuffer = childRowsMessageString;
            return stringBuffer;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    protected void insertConditionKey(Connection conn, String initialKeyValue, String commPointID) throws Exception {
        PreparedStatement insertStmt = null;
        try {
            insertStmt = conn.prepareStatement(KEY_INSERT);
            insertStmt.setString(1, commPointID);
            insertStmt.setString(2, initialKeyValue);
            insertStmt.executeUpdate();
        }
        finally {
            if (insertStmt != null) {
                insertStmt.close();
            }
        }
    }

    protected void createConditionKeyTable(Connection conn, String initialKeyValue, String commPointID) throws Exception {
        Statement stmt = null;
        try {
            String keyCreationStatement = this.getKeyCreationStatement();
            this.log.debug("Key Creation statement[" + keyCreationStatement + "]");
            stmt = conn.prepareStatement(keyCreationStatement);
            try {
                stmt.executeUpdate();
                this.log.debug("Table for keys created");
                this.insertConditionKey(conn, initialKeyValue, commPointID);
                this.log.debug("Row for condition keyColumn created");
            }
            catch (Exception ex1) {
                this.log.error("Unable to create table for keys", (Throwable)ex1);
                throw ex1;
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    protected Connection openKeyConnection() throws SQLException {
        Connection conn = null;
        if (this.keyDatasource == null) {
            this.log.debug("Lookup of datasource: " + this.pollingParams.keyDatasourceName);
            try {
                try {
                    this.keyDatasource = this.poller.getDataSourceManager().getDataSource(this.pollingParams.keyDatasourceName);
                }
                catch (Exception exception) {
                    this.log.warn("Datasource " + this.pollingParams.datasourceName + " not available. Polling not executed.");
                    return null;
                }
            }
            catch (Exception e) {
                this.log.error("Error during lookup of datasource", (Throwable)e);
                try {
                    this.log.error("Deactivating component JDBC Poller");
                    this.cancel();
                    this.poller = null;
                }
                catch (Exception exception) {
                    this.log.error("Error deactivating component JDBC Poller");
                }
            }
        }
        conn = this.keyDatasource.getConnection();
        return conn;
    }

    protected String getConditionKey(Connection conn, String commPointID) throws Exception {
        String result;
        block11: {
            result = null;
            PreparedStatement selectStmt = null;
            ResultSet rs = null;
            try {
                selectStmt = conn.prepareStatement(KEY_QUERY);
                selectStmt.setString(1, commPointID);
                rs = selectStmt.executeQuery();
                if (rs.next()) {
                    result = rs.getString(1);
                    break block11;
                }
                conn.rollback();
                throw new ConditionKeyNotFoundException("Condition key not found");
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                finally {
                    if (selectStmt != null) {
                        selectStmt.close();
                    }
                }
            }
        }
        return result;
    }

    protected void updateConditionKey(Connection conn, String commPointID, String currentKeyValue) throws Exception {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = conn.prepareStatement(KEY_UPDATE);
                stmt.setString(1, currentKeyValue);
                stmt.setString(2, commPointID);
                stmt.executeUpdate();
                conn.commit();
            }
            catch (Exception e) {
                conn.rollback();
                this.log.info("Impossible to update Key Value table due to: ", (Throwable)e);
                throw e;
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    protected StringBuffer buildStartMessageString(String statementName, String[] columnNames, String[] columnValues, StringBuffer result) {
        if (this.pollingParams.rowNameAsAttribute) {
            result.append("<row name=\"");
            result.append(StringEscapeUtils.escapeXml((String)statementName));
            result.append("\">");
        } else {
            result.append("<");
            result.append(StringEscapeUtils.escapeXml((String)statementName));
            result.append(">");
        }
        return result;
    }

    protected StringBuffer buildBodyMessageString(String statementName, String[] columnNames, String[] columnValues, StringBuffer result) {
        if (this.pollingParams.columnNameAsAttribute) {
            int count = columnNames.length;
            int i = 0;
            while (i < count) {
                result.append("<column name=\"");
                result.append(StringEscapeUtils.escapeXml((String)columnNames[i]));
                result.append("\"");
                if (this.pollingParams.valueAsAttribute) {
                    result.append(" value=\"");
                    result.append(StringEscapeUtils.escapeXml((String)columnValues[i]));
                    result.append("\"/>");
                } else {
                    result.append(">");
                    result.append(StringEscapeUtils.escapeXml((String)columnValues[i]));
                    result.append("</column>");
                }
                ++i;
            }
        } else {
            int count = columnNames.length;
            int i = 0;
            while (i < count) {
                result.append("<");
                result.append(StringEscapeUtils.escapeXml((String)columnNames[i]));
                if (this.pollingParams.valueAsAttribute) {
                    result.append(" value=\"");
                    result.append(StringEscapeUtils.escapeXml((String)columnValues[i]));
                    result.append("\"/>");
                } else {
                    result.append(">");
                    result.append(StringEscapeUtils.escapeXml((String)columnValues[i]));
                    result.append("</");
                    result.append(StringEscapeUtils.escapeXml((String)columnNames[i]));
                    result.append(">");
                }
                ++i;
            }
        }
        return result;
    }

    protected StringBuffer buildEndMessageString(String statementName, String[] columnNames, String[] columnValues, StringBuffer result) {
        if (this.pollingParams.rowNameAsAttribute) {
            result.append("</row>");
        } else {
            result.append("</");
            result.append(StringEscapeUtils.escapeXml((String)statementName));
            result.append(">");
        }
        return result;
    }

    @Override
    public boolean cancel() {
        this.log.info("Deactivating polling task for JDBC Poller");
        this.poller = null;
        return super.cancel();
    }

    public class ConditionKeyNotFoundException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ConditionKeyNotFoundException(String message) {
            super(message);
        }
    }
}

