/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.model.entities;

import java.io.Serializable;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;


/**
 * The persistent class for the sbi_threshold_value database table.
 * 
 */
@Entity
@Table(name="SBI_THRESHOLD_VALUE")
public class SbiThresholdValue implements Serializable {
	private static final long serialVersionUID = 1L;

    @TableGenerator(name="trVId", table="ID_GEN",
            pkColumnName="ID_NAME", valueColumnName="ID_VAL",
            pkColumnValue="THRESHOLD_VALUE_ID", allocationSize=1)
	@Id
    @GeneratedValue(generator="trVId", strategy=GenerationType.TABLE) 
	@Column(name="ID_THRESHOLD_VALUE")
	private Integer idThresholdValue;

	@Column(name="COLOUR")
	private String colour;

	@Column(name="LABEL")
	private String label;

	@Column(name="MAX_CLOSED")
	private int maxClosed;

	@Column(name="MAX_VALUE")
	private double maxValue;

	@Column(name="MIN_CLOSED")
	private int minClosed;

	@Column(name="MIN_VALUE")
	private double minValue;

	@Column(name="POSITION")
	private int position;

	@Column(name="TH_VALUE")
	private double thValue;

	//bi-directional many-to-one association to SbiAlarm
	@OneToMany(mappedBy="sbiThresholdValue",fetch=FetchType.LAZY)
	private Set<SbiAlarm> sbiAlarms;

	//bi-directional many-to-one association to SbiDomain
    @ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="SEVERITY_ID")
	private SbiDomain sbiDomain;

	//bi-directional many-to-one association to SbiThreshold
    @ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="THRESHOLD_ID")
	private SbiThreshold sbiThreshold;

    public SbiThresholdValue() {
    }

	public int getIdThresholdValue() {
		return this.idThresholdValue;
	}

	public void setIdThresholdValue(int idThresholdValue) {
		this.idThresholdValue = idThresholdValue;
	}

	public String getColour() {
		return this.colour;
	}

	public void setColour(String colour) {
		this.colour = colour;
	}

	public String getLabel() {
		return this.label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public int getMaxClosed() {
		return this.maxClosed;
	}

	public void setMaxClosed(int maxClosed) {
		this.maxClosed = maxClosed;
	}

	public double getMaxValue() {
		return this.maxValue;
	}

	public void setMaxValue(double maxValue) {
		this.maxValue = maxValue;
	}

	public int getMinClosed() {
		return this.minClosed;
	}

	public void setMinClosed(int minClosed) {
		this.minClosed = minClosed;
	}

	public double getMinValue() {
		return this.minValue;
	}

	public void setMinValue(double minValue) {
		this.minValue = minValue;
	}

	public int getPosition() {
		return this.position;
	}

	public void setPosition(int position) {
		this.position = position;
	}

	public double getThValue() {
		return this.thValue;
	}

	public void setThValue(double thValue) {
		this.thValue = thValue;
	}

	public Set<SbiAlarm> getSbiAlarms() {
		return this.sbiAlarms;
	}

	public void setSbiAlarms(Set<SbiAlarm> sbiAlarms) {
		this.sbiAlarms = sbiAlarms;
	}
	
	public SbiDomain getSbiDomain() {
		return this.sbiDomain;
	}

	public void setSbiDomain(SbiDomain sbiDomain) {
		this.sbiDomain = sbiDomain;
	}
	
	public SbiThreshold getSbiThreshold() {
		return this.sbiThreshold;
	}

	public void setSbiThreshold(SbiThreshold sbiThreshold) {
		this.sbiThreshold = sbiThreshold;
	}
	
}