/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import org.eclipse.wst.xml.xpath2.processor.DOMLoader;
import org.eclipse.wst.xml.xpath2.processor.DOMLoaderException;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XercesLoader
implements DOMLoader {
    private static final String NONVALIDATING_LOAD_DTD_GRAMMAR = "http://apache.org/xml/features/nonvalidating/load-dtd-grammar";
    public static final String NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    public static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    public static final String SCHEMA_VALIDATION_FEATURE = "http://apache.org/xml/features/validation/schema";
    public static final String SCHEMA_FULL_CHECKING_FEATURE = "http://apache.org/xml/features/validation/schema-full-checking";
    public static final String DYNAMIC_VALIDATION_FEATURE = "http://apache.org/xml/features/validation/dynamic";
    public static final String LOAD_EXTERNAL_DTD_FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String DOCUMENT_IMPLEMENTATION_PROPERTY = "http://apache.org/xml/properties/dom/document-class-name";
    public static final String DOCUMENT_PSVI_IMPLEMENTATION = "org.apache.xerces.dom.PSVIDocumentImpl";
    boolean _validating = false;
    Schema _schema = null;

    public XercesLoader() {
    }

    public XercesLoader(Schema schema) {
        this._schema = schema;
    }

    public Document load(InputStream in) throws DOMLoaderException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setAttribute(SCHEMA_VALIDATION_FEATURE, this._validating);
        factory.setAttribute(LOAD_EXTERNAL_DTD_FEATURE, true);
        factory.setAttribute(NONVALIDATING_LOAD_DTD_GRAMMAR, true);
        factory.setAttribute(DOCUMENT_IMPLEMENTATION_PROPERTY, DOCUMENT_PSVI_IMPLEMENTATION);
        if (this._schema != null) {
            factory.setSchema(this._schema);
        } else {
            factory.setValidating(this._validating);
        }
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (this._validating) {
                builder.setErrorHandler(new ErrorHandler(){

                    public void fatalError(SAXParseException e) throws SAXException {
                        throw e;
                    }

                    public void error(SAXParseException e) throws SAXParseException {
                        throw e;
                    }

                    public void warning(SAXParseException e) throws SAXParseException {
                        throw e;
                    }
                });
            }
            return builder.parse(in);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            throw new DOMLoaderException("Parser configuration exception: " + e.getMessage());
        }
        catch (IOException e) {
            throw new DOMLoaderException("IO exception: " + e.getMessage());
        }
        return null;
    }

    public void set_validating(boolean x) {
        this._validating = x;
    }
}

