/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.servicewidgets.detailtabs;

import java.util.Date;
import org.eclipse.ebam.designers.exception.WizardException;
import org.eclipse.ebam.designers.swtutils.SWTUtils;
import org.eclipse.ebam.designers.wizards.pages.servicewidgets.ServicesDetailComposite;
import org.eclipse.ebam.model.entities.Service;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDetailTabItem
extends CTabItem {
    private ServicesDetailComposite servicesDetailComposite;
    private Text nameText;
    private Spinner stateSpinner;
    private Button monitorEnabledCheck;
    private Button startDateButton;
    private Button endDateButton;
    private boolean inserting = true;
    public static final int tabIndex = 0;
    private static Logger logger = LoggerFactory.getLogger(ServiceDetailTabItem.class);

    public ServiceDetailTabItem(CTabFolder parent, int style, ServicesDetailComposite alComposite) {
        super(parent, style);
        this.servicesDetailComposite = alComposite;
    }

    public void drawComp(CTabFolder folder) {
        logger.debug("IN");
        Composite detailComposite = new Composite((Composite)folder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        detailComposite.setLayout((Layout)gridLayout);
        GridData gridName = SWTUtils.setGridLayoutData(768, 2);
        SWTUtils.drawLabel(detailComposite, "Name", 0, null);
        this.nameText = SWTUtils.drawText(detailComposite, 2048, gridName);
        SWTUtils.drawLabel(detailComposite, "State", 0, null);
        this.stateSpinner = SWTUtils.drawSpinner(detailComposite, 2048, gridName, -100000, 100000, 2);
        SWTUtils.drawLabel(detailComposite, "Monitor Enabled", 0, null);
        this.monitorEnabledCheck = SWTUtils.drawButton(detailComposite, 32, "Monitor Enabled", gridName);
        SWTUtils.drawLabel(detailComposite, "Start Date", 0, null);
        this.startDateButton = SWTUtils.drawDateTime(detailComposite, 2048, gridName);
        SWTUtils.drawLabel(detailComposite, "End Date", 0, null);
        this.endDateButton = SWTUtils.drawDateTime(detailComposite, 2048, gridName);
        this.setControl((Control)detailComposite);
        logger.debug("OUT");
    }

    public void fillEmptyValues() {
        this.setInserting(true);
        this.nameText.setText("");
        this.monitorEnabledCheck.setSelection(false);
        this.stateSpinner.setSelection(0);
        this.startDateButton.setText("");
        this.startDateButton.setData(null);
        this.endDateButton.setText("");
        this.endDateButton.setData(null);
    }

    public void fillServiceValues(Service service) throws WizardException {
        String name = service.getName() != null ? service.getName() : "";
        this.nameText.setText(name);
        double state = service.getState();
        Integer maxInt = SWTUtils.convertValueForSpinner(state);
        this.stateSpinner.setSelection(maxInt.intValue());
        boolean monitorEnabled = service.getMonitorEnabled() != null && service.getMonitorEnabled().equals("T");
        this.monitorEnabledCheck.setSelection(monitorEnabled);
        Date startDate = service.getStartdate();
        if (startDate != null) {
            this.startDateButton.setData((Object)startDate);
            String dateString = SWTUtils.convertDateToString(startDate);
            this.startDateButton.setText(dateString);
        } else {
            this.startDateButton.setText("");
            this.startDateButton.setData(null);
        }
        Date endDate = service.getEnddate();
        if (endDate != null) {
            this.endDateButton.setData((Object)endDate);
            String dateString = SWTUtils.convertDateToString(endDate);
            this.endDateButton.setText(dateString);
        } else {
            this.endDateButton.setText("");
            this.endDateButton.setData(null);
        }
        logger.debug("OUT");
    }

    public void recoverSavingInformations(Service service) throws WizardException {
        logger.debug("IN");
        String name = this.nameText.getText();
        boolean monitoEnabled = this.monitorEnabledCheck.getSelection();
        String valueS = this.stateSpinner.getText();
        valueS = valueS.replaceAll(",", ".");
        Double val = Double.valueOf(valueS);
        Date startDate = null;
        if (this.startDateButton.getData() != null) {
            startDate = (Date)this.startDateButton.getData();
        }
        Date endDate = null;
        if (this.endDateButton.getData() != null) {
            endDate = (Date)this.endDateButton.getData();
        }
        service.setName(name);
        service.setState(val.doubleValue());
        service.setMonitorEnabled(monitoEnabled ? "T" : "F");
        service.setStartdate(startDate);
        service.setEnddate(endDate);
    }

    public void disableFields() {
        this.nameText.setEnabled(false);
        this.stateSpinner.setEnabled(false);
        this.monitorEnabledCheck.setEnabled(false);
        this.startDateButton.setEnabled(false);
        this.endDateButton.setEnabled(false);
    }

    public void enableFields(boolean insert) {
        this.nameText.setEnabled(true);
        this.stateSpinner.setEnabled(true);
        this.monitorEnabledCheck.setEnabled(true);
        this.startDateButton.setEnabled(true);
        this.endDateButton.setEnabled(true);
    }

    public ServicesDetailComposite getServicesDetailComposite() {
        return this.servicesDetailComposite;
    }

    public void setServicesDetailComposite(ServicesDetailComposite servicesDetailComposite) {
        this.servicesDetailComposite = servicesDetailComposite;
    }

    public Text getNameText() {
        return this.nameText;
    }

    public void setNameText(Text nameText) {
        this.nameText = nameText;
    }

    public boolean isInserting() {
        return this.inserting;
    }

    public void setInserting(boolean inserting) {
        this.inserting = inserting;
    }
}

