/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.alarmwidgets.detailtabs;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.ebam.designers.wizards.pages.alarmwidgets.AlarmsDetailComposite;
import org.eclipse.ebam.emf.SbiAlarmContactsTransactions;
import org.eclipse.ebam.model.entities.SbiAlarm;
import org.eclipse.ebam.model.entities.SbiAlarmContact;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlarmContactsTabItem
extends CTabItem {
    Table contactsTable = null;
    AlarmsDetailComposite alarmsDetailComposite = null;
    List<SbiAlarmContact> contacts = null;
    public static final int tabIndex = 2;
    public static final int NAME = 0;
    public static final int E_MAIL = 1;
    public static final int CELL = 2;
    public static final int RESOURCES = 3;
    private static Logger logger = LoggerFactory.getLogger(AlarmContactsTabItem.class);

    public AlarmContactsTabItem(CTabFolder parent, int style, AlarmsDetailComposite alarmsDetailComposite1) {
        super(parent, style);
        this.alarmsDetailComposite = alarmsDetailComposite1;
    }

    public void drawComp(CTabFolder folder) {
        logger.debug("IN");
        Composite detailComposite = new Composite((Composite)folder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        detailComposite.setLayout((Layout)gridLayout);
        this.contactsTable = new Table(detailComposite, 68132);
        this.contactsTable.setLinesVisible(true);
        this.contactsTable.setHeaderVisible(true);
        GridData g = new GridData(1808);
        this.contactsTable.setLayoutData((Object)g);
        this.contactsTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AlarmContactsTabItem.this.addContactsSelection(event);
            }
        });
        String[] titles = new String[]{"       Nome      ", "       E-Mail     ", "      Cellulare    ", "     Risorse     "};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(this.contactsTable, 0);
            column.setText(titles[i]);
            ++i;
        }
        List<SbiAlarmContact> contacts = this.retrieveContacts();
        int i2 = 0;
        while (i2 < contacts.size()) {
            SbiAlarmContact sac = contacts.get(i2);
            TableItem item = new TableItem(this.contactsTable, 0);
            item.setText(0, sac.getName() != null ? sac.getName() : "");
            item.setText(1, sac.getEmail() != null ? sac.getEmail() : "");
            item.setText(2, sac.getMobile() != null ? sac.getMobile() : "");
            item.setText(3, sac.getResources() != null ? sac.getResources() : "");
            item.setData((Object)sac.getAlarmContactId());
            ++i2;
        }
        i2 = 0;
        while (i2 < titles.length) {
            this.contactsTable.getColumn(i2).pack();
            ++i2;
        }
        this.contactsTable.redraw();
        this.setControl((Control)detailComposite);
        logger.debug("OUT");
    }

    private List<SbiAlarmContact> retrieveContacts() {
        logger.debug("IN");
        SbiAlarmContactsTransactions alConctTransactions = new SbiAlarmContactsTransactions();
        try {
            this.contacts = alConctTransactions.getSbiAlarmContactList();
        }
        catch (Exception exception) {
            logger.error("error in retrieving contacts");
            return null;
        }
        logger.debug("OUT");
        return this.contacts;
    }

    public void fillAlarmValues(SbiAlarm sbiAlarm) {
        logger.debug("IN");
        Vector<Integer> ids = new Vector<Integer>();
        Set alContacts = sbiAlarm.getSbiAlarmContacts();
        if (alContacts == null) {
            return;
        }
        for (SbiAlarmContact sbiAlarmContact : alContacts) {
            ids.add(sbiAlarmContact.getAlarmContactId());
        }
        TableItem[] items = this.contactsTable.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            Integer id = (Integer)item.getData();
            if (ids.contains(id)) {
                item.setChecked(true);
            } else {
                item.setChecked(false);
            }
            ++i;
        }
        this.contactsTable.redraw();
        logger.debug("OUT");
    }

    public void addContactsSelection(Event event) {
    }

    public void recoverSavingInformations(SbiAlarm sbiAlarm) {
        logger.debug("IN");
        Vector<Integer> ids = new Vector<Integer>();
        TableItem[] tableItems = this.contactsTable.getItems();
        int i = 0;
        while (i < tableItems.length) {
            TableItem tableItem = tableItems[i];
            boolean checked = tableItem.getChecked();
            if (checked) {
                ids.add((Integer)tableItem.getData());
            }
            ++i;
        }
        HashSet<SbiAlarmContact> toAdd = new HashSet<SbiAlarmContact>();
        for (SbiAlarmContact sbiAlarmContact : this.contacts) {
            if (!ids.contains(sbiAlarmContact.getAlarmContactId())) continue;
            toAdd.add(sbiAlarmContact);
        }
        sbiAlarm.setSbiAlarmContacts(toAdd);
        logger.debug("OUT");
    }

    public void disableFields() {
        this.contactsTable.setEnabled(false);
    }

    public void enableFields() {
        this.contactsTable.setEnabled(true);
    }

    public Table getContactsTable() {
        return this.contactsTable;
    }

    public void setContactsTable(Table contactsTable) {
        this.contactsTable = contactsTable;
    }

    public AlarmsDetailComposite getAlarmsDetailComposite() {
        return this.alarmsDetailComposite;
    }

    public void setAlarmsDetailComposite(AlarmsDetailComposite alarmsDetailComposite) {
        this.alarmsDetailComposite = alarmsDetailComposite;
    }

    public void fillEmptyValues() {
        TableItem[] items = this.contactsTable.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem type = items[i];
            type.setChecked(false);
            ++i;
        }
    }
}

