/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ProgramElement;
import org.eclipse.wst.jsdt.internal.compiler.parser.Scanner;

public abstract class Statement
extends ProgramElement {
    private String optionalLeadingComment = null;

    Statement(AST ast) {
        super(ast);
    }

    public String getLeadingComment() {
        return this.optionalLeadingComment;
    }

    public void setLeadingComment(String comment) {
        if (comment != null) {
            char[] source = comment.toCharArray();
            Scanner scanner = this.ast.scanner;
            scanner.resetTo(0, source.length);
            scanner.setSource(source);
            try {
                int token;
                boolean onlyOneComment = false;
                while ((token = scanner.getNextToken()) != 55) {
                    switch (token) {
                        case 1001: 
                        case 1002: 
                        case 1003: {
                            if (onlyOneComment) {
                                throw new IllegalArgumentException();
                            }
                            onlyOneComment = true;
                            break;
                        }
                        default: {
                            onlyOneComment = false;
                        }
                    }
                }
                if (!onlyOneComment) {
                    throw new IllegalArgumentException();
                }
            }
            catch (InvalidInputException invalidInputException) {
                throw new IllegalArgumentException();
            }
        }
        this.checkModifiable();
        this.optionalLeadingComment = comment;
    }

    void copyLeadingComment(Statement source) {
        this.setLeadingComment(source.getLeadingComment());
    }

    int memSize() {
        int size = 44 + Statement.stringSize(this.getLeadingComment());
        return size;
    }
}

