/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script;

import com.ibm.icu.util.TimeZone;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ICompiledScript;
import org.eclipse.birt.core.script.IScriptContext;
import org.eclipse.birt.core.script.IScriptEngine;
import org.eclipse.birt.core.script.IScriptEngineFactory;
import org.eclipse.birt.core.script.ScriptEngineFactoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptContext
implements IScriptContext {
    private Locale locale;
    private TimeZone timeZone;
    private ClassLoader applicationClassLoader;
    private ScriptContext parent;
    private Object scope;
    private Map<String, Object> attributes;
    private Map<String, IScriptEngine> engines;
    private Map<String, IScriptContext> scriptContexts;

    public ScriptContext() {
        this(null, null, null);
    }

    private ScriptContext(ScriptContext scriptContext, Object scope, Map<String, Object> attributes) {
        this.engines = scriptContext == null ? new HashMap<String, IScriptEngine>() : scriptContext.engines;
        this.attributes = new HashMap<String, Object>();
        if (attributes != null) {
            this.attributes.putAll(attributes);
        }
        this.parent = scriptContext;
        this.scriptContexts = new HashMap<String, IScriptContext>();
        this.scope = scope;
    }

    public ClassLoader getApplicationClassLoader() {
        if (this.parent != null) {
            return this.parent.getApplicationClassLoader();
        }
        return this.applicationClassLoader;
    }

    public void setApplicationClassLoader(ClassLoader loader) {
        if (this.parent != null) {
            this.parent.setApplicationClassLoader(loader);
        } else {
            this.applicationClassLoader = loader;
            Collection<IScriptEngine> engineSet = this.engines.values();
            for (IScriptEngine engine : engineSet) {
                engine.setApplicationClassLoader(loader);
            }
        }
    }

    public ScriptContext newContext(Object scope) {
        return this.newContext(scope, null);
    }

    public ScriptContext newContext(Object scope, Map<String, Object> attributes) {
        ScriptContext scriptContext = new ScriptContext(this, scope, attributes);
        return scriptContext;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        if (attributes != null) {
            for (Map.Entry<String, Object> attribute : attributes.entrySet()) {
                this.setAttribute(attribute.getKey(), attribute.getValue());
            }
        }
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
        for (IScriptContext context : this.scriptContexts.values()) {
            context.setAttribute(name, value);
        }
    }

    @Override
    public void removeAttribute(String name) {
        this.attributes.remove(name);
        for (IScriptContext context : this.scriptContexts.values()) {
            context.removeAttribute(name);
        }
    }

    public ICompiledScript compile(String language, String fileName, int lineNo, String script) throws BirtException {
        assert (language != null);
        IScriptEngine engine = this.getScriptEngine(language);
        return engine.compile(this, fileName, lineNo, script);
    }

    public Object evaluate(ICompiledScript script) throws BirtException {
        IScriptEngine engine = this.getScriptEngine(script.getLanguage());
        return engine.evaluate(this, script);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        Collection<IScriptEngine> engineSet = this.engines.values();
        for (IScriptEngine engine : engineSet) {
            engine.setLocale(locale);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        Collection<IScriptEngine> engineSet = this.engines.values();
        for (IScriptEngine engine : engineSet) {
            engine.setTimeZone(timeZone);
        }
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void close() {
        Collection<IScriptContext> contexts = this.scriptContexts.values();
        for (IScriptContext context : contexts) {
            for (String attrName : this.attributes.keySet()) {
                context.removeAttribute(attrName);
            }
        }
        this.scriptContexts.clear();
        this.attributes.clear();
        if (this.parent == null) {
            Collection<IScriptEngine> engineSet = this.engines.values();
            for (IScriptEngine engine : engineSet) {
                engine.close();
            }
            this.engines.clear();
        }
    }

    public IScriptEngine getScriptEngine(String scriptName) throws BirtException {
        if (scriptName == null) {
            throw new NullPointerException();
        }
        if (this.engines.containsKey(scriptName)) {
            return this.engines.get(scriptName);
        }
        IScriptEngineFactory factory = ScriptEngineFactoryManager.getInstance().getScriptEngineFactory(scriptName);
        if (factory == null) {
            throw new BirtException("No such script extension : " + scriptName);
        }
        return this.createEngine(factory);
    }

    public ScriptContext getParent() {
        return this.parent;
    }

    private IScriptEngine createEngine(IScriptEngineFactory factory) throws BirtException {
        IScriptEngine scriptEngine = factory.createScriptEngine();
        scriptEngine.setLocale(this.locale);
        scriptEngine.setTimeZone(this.timeZone);
        scriptEngine.setApplicationClassLoader(this.getApplicationClassLoader());
        this.engines.put(factory.getScriptLanguage(), scriptEngine);
        return scriptEngine;
    }

    public Object getScopeObject() {
        return this.scope;
    }

    public IScriptContext getScriptContext(String language) {
        return this.scriptContexts.get(language);
    }

    public void setScriptContext(String language, IScriptContext scriptContext) {
        this.scriptContexts.put(language, scriptContext);
    }
}

