/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.presentation.aggregation.layout;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis.AxisFault;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.context.BaseAttributeBean;
import org.eclipse.birt.report.context.BirtContext;
import org.eclipse.birt.report.presentation.aggregation.BirtBaseFragment;
import org.eclipse.birt.report.presentation.aggregation.control.ToolbarFragment;
import org.eclipse.birt.report.presentation.aggregation.layout.ReportFragment;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.ReportEngineService;
import org.eclipse.birt.report.service.actionhandler.BirtGetReportletActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtRenderReportActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtRunReportActionHandler;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.utility.BirtUtility;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class FramesetFragment
extends BirtBaseFragment {
    protected void build() {
        this.addChild(new ToolbarFragment());
        this.addChild(new ReportFragment());
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, BirtException {
        BaseAttributeBean attrBean = (BaseAttributeBean)request.getAttribute("attributeBean");
        if (attrBean != null && !attrBean.isShowParameterPage() && !this.__checkHTMLFormat(request)) {
            this.doPreService(request, response);
            this.doService(request, response);
            this.doPostService(request, response);
        } else {
            super.doPreService(request, response);
            super.doService(request, response);
            String target = super.doPostService(request, response);
            if (target != null && target.length() > 0) {
                RequestDispatcher rd = request.getRequestDispatcher(target);
                rd.include((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    protected boolean __checkHTMLFormat(HttpServletRequest request) {
        BaseAttributeBean bean = (BaseAttributeBean)request.getAttribute("attributeBean");
        assert (bean != null);
        return "html".equalsIgnoreCase(bean.getFormat());
    }

    protected void doPreService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        BaseAttributeBean attrBean = (BaseAttributeBean)request.getAttribute("attributeBean");
        String format = attrBean.getFormat();
        String emitterId = attrBean.getEmitterId();
        String openType = ParameterAccessor.getOpenType(request);
        if ("pdf".equalsIgnoreCase(format)) {
            response.setContentType("application/pdf");
        } else {
            String mimeType = ParameterAccessor.getEmitterMimeType(emitterId);
            if (mimeType == null) {
                mimeType = ReportEngineService.getInstance().getMIMEType(format);
            }
            if (mimeType != null && mimeType.length() > 0) {
                response.setContentType(mimeType);
            } else {
                response.setContentType("application/octet-stream");
            }
        }
        String filename = ParameterAccessor.getExportFilename(new BirtContext(request, response), format, emitterId);
        response.setHeader("Content-Disposition", openType + "; filename=\"" + filename + "\"");
    }

    protected void doService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, BirtException {
        BaseAttributeBean attrBean = (BaseAttributeBean)request.getAttribute("attributeBean");
        assert (attrBean != null);
        Object out = response.getOutputStream();
        BirtContext context = new BirtContext(request, response);
        GetUpdatedObjectsResponse upResponse = new GetUpdatedObjectsResponse();
        Operation op = null;
        try {
            File file = new File(attrBean.getReportDocumentName());
            if (!file.exists()) {
                BirtRunReportActionHandler runReport = new BirtRunReportActionHandler(context, op, upResponse);
                runReport.execute();
            }
            if (attrBean.isDocumentProcessing()) {
                AxisFault fault = new AxisFault();
                fault.setFaultReason(BirtResources.getMessage("birt.viewer.generalException.DOCUMENT_FILE_PROCESSING"));
                throw fault;
            }
            boolean isPrint = false;
            if ("print".equalsIgnoreCase(attrBean.getAction())) {
                isPrint = true;
                out = new ByteArrayOutputStream();
            }
            if (ParameterAccessor.isGetReportlet(request)) {
                BirtGetReportletActionHandler renderReportlet = new BirtGetReportletActionHandler(context, op, upResponse, (OutputStream)out);
                renderReportlet.execute();
            } else {
                BirtRenderReportActionHandler renderReport = new BirtRenderReportActionHandler(context, op, upResponse, (OutputStream)out);
                renderReport.execute();
            }
            if (isPrint) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(((ByteArrayOutputStream)out).toByteArray());
                BirtUtility.doPrintAction(inputStream, request, response);
            }
        }
        catch (RemoteException e) {
            response.setContentType("text/html; charset=utf-8");
            BirtUtility.appendErrorMessage((OutputStream)response.getOutputStream(), e);
        }
    }

    protected String doPostService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        return null;
    }
}

