/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.internal.ui.palette.editparts.IPaletteStackEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.PinnablePaletteStackFigure;
import org.eclipse.gef.palette.PaletteListener;
import org.eclipse.gef.palette.PaletteStack;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.editparts.IPinnableEditPart;
import org.eclipse.gef.ui.palette.editparts.PaletteEditPart;

public class PinnablePaletteStackEditPart
extends PaletteEditPart
implements IPaletteStackEditPart,
IPinnableEditPart {
    private PaletteListener paletteListener = new PaletteListener(){

        public void activeToolChanged(PaletteViewer palette, ToolEntry tool) {
            if (!PinnablePaletteStackEditPart.this.getStackFigure().isPinnedOpen() && PinnablePaletteStackEditPart.this.getStack().getChildren().contains(tool) && !PinnablePaletteStackEditPart.this.getStack().getActiveEntry().equals(tool)) {
                PinnablePaletteStackEditPart.this.getStack().setActiveEntry(tool);
            }
            if (!PinnablePaletteStackEditPart.this.getStackFigure().isPinnedOpen()) {
                PinnablePaletteStackEditPart.this.getStackFigure().setExpanded(false);
            }
        }
    };

    public PinnablePaletteStackEditPart(PaletteStack model) {
        super(model);
    }

    public void activate() {
        this.checkActiveEntrySync();
        this.getPaletteViewer().addPaletteListener(this.paletteListener);
        super.activate();
    }

    private void activeEntryChanged(Object oldValue, Object newValue) {
        GraphicalEditPart part = null;
        IFigure oldFigure = null;
        IFigure newFigure = null;
        int index = -1;
        if (oldValue != null && (part = (GraphicalEditPart)this.getViewer().getEditPartRegistry().get(oldValue)) != null) {
            oldFigure = part.getFigure();
            index = this.getModelChildren().indexOf(part.getModel());
        }
        if (newValue != null) {
            part = (GraphicalEditPart)this.getViewer().getEditPartRegistry().get(newValue);
            newFigure = part.getFigure();
        }
        this.getStackFigure().activeEntryChanged(oldFigure, index, newFigure);
    }

    private void checkActiveEntrySync() {
        if (this.getStackFigure().getActiveFigure() == null) {
            this.activeEntryChanged(null, this.getStack().getActiveEntry());
        }
    }

    public IFigure createFigure() {
        return new PinnablePaletteStackFigure();
    }

    private PinnablePaletteStackFigure getStackFigure() {
        return (PinnablePaletteStackFigure)this.getFigure();
    }

    public void deactivate() {
        this.getPaletteViewer().removePaletteListener(this.paletteListener);
        super.deactivate();
    }

    public void eraseTargetFeedback(Request request) {
        Iterator children = this.getChildren().iterator();
        while (children.hasNext()) {
            PaletteEditPart part = (PaletteEditPart)children.next();
            part.eraseTargetFeedback(request);
        }
        super.eraseTargetFeedback(request);
    }

    public IFigure getContentPane() {
        return this.getStackFigure().getContentPane();
    }

    protected void removeChildVisual(EditPart childEditPart) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        this.getStackFigure().getContentPane(child).remove(child);
    }

    protected void addChild(EditPart childEP, int index) {
        index = this.updateIndexBasedOnActiveFigure(index, childEP);
        super.addChild(childEP, index);
    }

    protected void reorderChild(EditPart childEP, int index) {
        IFigure childFigure = ((GraphicalEditPart)childEP).getFigure();
        if (childFigure == this.getStackFigure().getActiveFigure()) {
            List children = this.getChildren();
            children.remove(childEP);
            children.add(index, childEP);
        } else {
            this.removeChildVisual(childEP);
            List children = this.getChildren();
            children.remove(childEP);
            children.add(index, childEP);
            index = this.updateIndexBasedOnActiveFigure(index, childEP);
            this.addChildVisual(childEP, index);
        }
    }

    private int updateIndexBasedOnActiveFigure(int index, EditPart childEP) {
        int i = 0;
        while (i < index) {
            Object ep = this.getChildren().get(i);
            if (((GraphicalEditPart)ep).getFigure() == this.getStackFigure().getActiveFigure()) {
                return index - 1;
            }
            ++i;
        }
        return index;
    }

    private PaletteStack getStack() {
        return (PaletteStack)this.getModel();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("Active Entry")) {
            this.activeEntryChanged(event.getOldValue(), event.getNewValue());
        } else {
            super.propertyChange(event);
        }
    }

    protected void refreshChildren() {
        super.refreshChildren();
        this.checkActiveEntrySync();
    }

    protected void refreshVisuals() {
        this.getStackFigure().setLayoutMode(this.getLayoutSetting());
    }

    public void openMenu() {
        this.setExpanded(true);
    }

    public void setExpanded(boolean value) {
        this.getStackFigure().setExpanded(value);
    }

    public boolean isExpanded() {
        return this.getStackFigure().isExpanded();
    }

    public boolean canBePinned() {
        return this.isExpanded();
    }

    public boolean isPinnedOpen() {
        return this.getStackFigure().isPinnedOpen();
    }

    public void setPinnedOpen(boolean pinned) {
        this.getStackFigure().setPinned(pinned);
    }

    public PaletteEditPart getActiveEntry() {
        return (PaletteEditPart)this.getViewer().getEditPartRegistry().get(this.getStack().getActiveEntry());
    }
}

