/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context;

import java.util.List;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.IdClassReference;
import org.eclipse.jpt.core.internal.context.PrimaryKeyTextRangeResolver;
import org.eclipse.jpt.core.internal.jpa1.context.AbstractPrimaryKeyValidator;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericEntityPrimaryKeyValidator
extends AbstractPrimaryKeyValidator {
    public GenericEntityPrimaryKeyValidator(Entity entity, PrimaryKeyTextRangeResolver textRangeResolver) {
        super(entity, textRangeResolver);
    }

    protected Entity entity() {
        return (Entity)this.typeMapping();
    }

    @Override
    protected IdClassReference idClassReference() {
        return this.entity().getIdClassReference();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        if (!this.entity().isRoot()) {
            this.validatePrimaryKeyForNonRoot(messages, reporter);
        } else {
            this.validatePrimaryKeyForRoot(messages, reporter);
        }
    }

    protected void validatePrimaryKeyForNonRoot(List<IMessage> messages, IReporter reporter) {
        this.validateNonRootEntityDoesNotSpecifyIdClass(messages, reporter);
        this.validateNonRootEntityDoesNotSpecifyPrimaryKeyAttributes(messages, reporter);
    }

    protected void validatePrimaryKeyForRoot(List<IMessage> messages, IReporter reporter) {
        this.validatePrimaryKeyIsNotRedefined(messages, reporter);
        this.validateIdClassIsUsedIfNecessary(messages, reporter);
        if (!this.definesPrimaryKey(this.typeMapping())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_NO_PK", new String[0], this.entity(), this.textRangeResolver().getTypeMappingTextRange()));
        }
        this.validateOneOfIdClassOrEmbeddedIdIsUsed(messages, reporter);
        this.validateOneEmbeddedId(messages, reporter);
        this.validateMapsIdMappings(messages, reporter);
        if (this.specifiesIdClass()) {
            this.validateIdClass(this.idClassReference().getIdClass(), messages, reporter);
        }
    }

    protected void validateNonRootEntityDoesNotSpecifyIdClass(List<IMessage> messages, IReporter reporter) {
        if (this.idClassReference().isSpecified()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_NON_ROOT_ID_CLASS_SPECIFIED", new String[0], this.entity(), this.textRangeResolver().getIdClassTextRange()));
        }
    }

    protected void validateNonRootEntityDoesNotSpecifyPrimaryKeyAttributes(List<IMessage> messages, IReporter reporter) {
        for (AttributeMapping each : this.getPrimaryKeyMappingsDefinedLocally(this.typeMapping())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_NON_ROOT_ID_ATTRIBUTE_SPECIFIED", new String[0], each, this.textRangeResolver().getAttributeMappingTextRange(each.getName())));
        }
    }
}

