/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.core.JpaDataSource;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaPlatform;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JpaResourceModel;
import org.eclipse.jpt.core.JpaResourceModelListener;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.JpaRootContextNode;
import org.eclipse.jpt.core.internal.AbstractJpaNode;
import org.eclipse.jpt.core.internal.SynchronousJpaProjectUpdater;
import org.eclipse.jpt.core.internal.resource.java.binary.BinaryPersistentTypeCache;
import org.eclipse.jpt.core.internal.resource.java.source.SourceCompilationUnit;
import org.eclipse.jpt.core.internal.utility.PlatformTools;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.jpa2.JpaProject2_0;
import org.eclipse.jpt.core.jpa2.context.JpaRootContextNode2_0;
import org.eclipse.jpt.core.jpa2.resource.java.JavaResourcePersistentType2_0;
import org.eclipse.jpt.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePackageFragmentRoot;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentTypeCache;
import org.eclipse.jpt.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.db.Catalog;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.Database;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.SchemaContainer;
import org.eclipse.jpt.utility.CommandExecutor;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.BitTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.ThreadLocalCommandExecutor;
import org.eclipse.jpt.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.utility.internal.iterables.SubIterableWrapper;
import org.eclipse.jpt.utility.internal.iterables.TransformationIterable;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.wst.common.internal.emf.resource.ReferencedResource;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJpaProject
extends AbstractJpaNode
implements JpaProject2_0 {
    protected final IProject project;
    protected final JpaPlatform jpaPlatform;
    protected final Vector<JpaFile> jpaFiles = new Vector();
    protected final Vector<JavaResourceCompilationUnit> externalJavaResourceCompilationUnits = new Vector();
    protected final JavaResourcePersistentTypeCache externalJavaResourcePersistentTypeCache;
    protected final JpaResourceModelListener resourceModelListener;
    protected final JpaRootContextNode rootContextNode;
    protected JpaProject.Updater updater;
    protected final JpaDataSource dataSource;
    protected String userOverrideDefaultCatalog;
    protected String userOverrideDefaultSchema;
    protected boolean discoversAnnotatedClasses;
    protected final ThreadLocalCommandExecutor modifySharedDocumentCommandExecutor;
    protected String metamodelSourceFolderName;
    protected static final Filter<IPackageFragmentRoot> SOURCE_PACKAGE_FRAGMENT_ROOT_FILTER = new Filter<IPackageFragmentRoot>(){

        public boolean accept(IPackageFragmentRoot pfr) {
            try {
                return this.accept_(pfr);
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }

        private boolean accept_(IPackageFragmentRoot pfr) throws JavaModelException {
            return pfr.exists() && pfr.getKind() == 1;
        }
    };

    protected AbstractJpaProject(JpaProject.Config config) {
        super(null);
        if (config.getProject() == null || config.getJpaPlatform() == null) {
            throw new NullPointerException();
        }
        this.project = config.getProject();
        this.jpaPlatform = config.getJpaPlatform();
        this.dataSource = this.getJpaFactory().buildJpaDataSource(this, config.getConnectionProfileName());
        this.userOverrideDefaultCatalog = config.getUserOverrideDefaultCatalog();
        this.userOverrideDefaultSchema = config.getUserOverrideDefaultSchema();
        this.discoversAnnotatedClasses = config.discoverAnnotatedClasses();
        this.modifySharedDocumentCommandExecutor = this.buildModifySharedDocumentCommandExecutor();
        this.resourceModelListener = this.buildResourceModelListener();
        InitialResourceProxyVisitor visitor = this.buildInitialResourceProxyVisitor();
        visitor.visitProject(this.project);
        this.externalJavaResourcePersistentTypeCache = this.buildExternalJavaResourcePersistentTypeCache();
        if (this.isJpa2_0Compatible()) {
            this.metamodelSourceFolderName = ((JpaProject2_0.Config)config).getMetamodelSourceFolderName();
            if (this.metamodelSoureFolderNameIsInvalid()) {
                this.metamodelSourceFolderName = null;
            }
        }
        this.rootContextNode = this.buildRootContextNode();
        this.setUpdater_(new SynchronousJpaProjectUpdater(this));
        this.externalJavaResourcePersistentTypeCache.addResourceModelListener(this.resourceModelListener);
    }

    @Override
    protected boolean requiresParent() {
        return false;
    }

    @Override
    public IResource getResource() {
        return this.project;
    }

    protected ThreadLocalCommandExecutor buildModifySharedDocumentCommandExecutor() {
        return new ThreadLocalCommandExecutor();
    }

    protected JpaResourceModelListener buildResourceModelListener() {
        return new DefaultResourceModelListener();
    }

    protected InitialResourceProxyVisitor buildInitialResourceProxyVisitor() {
        return new InitialResourceProxyVisitor();
    }

    protected JavaResourcePersistentTypeCache buildExternalJavaResourcePersistentTypeCache() {
        return new BinaryPersistentTypeCache(this.jpaPlatform.getAnnotationProvider());
    }

    protected JpaRootContextNode buildRootContextNode() {
        return this.getJpaFactory().buildRootContextNode(this);
    }

    @Override
    protected void addNonUpdateAspectNamesTo(Set<String> nonUpdateAspectNames) {
        super.addNonUpdateAspectNamesTo(nonUpdateAspectNames);
        nonUpdateAspectNames.add("externalJavaResourceCompilationUnits");
    }

    @Override
    public JpaProject getJpaProject() {
        return this;
    }

    @Override
    public String getName() {
        return this.project.getName();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public IJavaProject getJavaProject() {
        return JavaCore.create((IProject)this.project);
    }

    @Override
    public JpaPlatform getJpaPlatform() {
        return this.jpaPlatform;
    }

    protected Iterable<JavaResourceCompilationUnit> getCombinedJavaResourceCompilationUnits() {
        return new CompositeIterable(new Iterable[]{this.getInternalJavaResourceCompilationUnits(), this.getExternalJavaResourceCompilationUnits()});
    }

    @Override
    public JpaDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public ConnectionProfile getConnectionProfile() {
        return this.dataSource.getConnectionProfile();
    }

    @Override
    public Catalog getDefaultDbCatalog() {
        String catalog = this.getDefaultCatalog();
        return catalog == null ? null : this.getDbCatalog(catalog);
    }

    @Override
    public String getDefaultCatalog() {
        String catalog = this.getUserOverrideDefaultCatalog();
        return catalog != null ? catalog : this.getDatabaseDefaultCatalog();
    }

    protected String getDatabaseDefaultCatalog() {
        Database db = this.getDatabase();
        return db == null ? null : db.getDefaultCatalogIdentifier();
    }

    @Override
    public SchemaContainer getDefaultDbSchemaContainer() {
        String catalog = this.getDefaultCatalog();
        return catalog != null ? this.getDbCatalog(catalog) : this.getDatabase();
    }

    @Override
    public Schema getDefaultDbSchema() {
        SchemaContainer sc = this.getDefaultDbSchemaContainer();
        return sc == null ? null : sc.getSchemaForIdentifier(this.getDefaultSchema());
    }

    @Override
    public String getDefaultSchema() {
        String schema = this.getUserOverrideDefaultSchema();
        if (schema != null) {
            return schema;
        }
        String catalog = this.getDefaultCatalog();
        if (catalog == null) {
            return this.getDatabaseDefaultSchema();
        }
        Catalog dbCatalog = this.getDbCatalog(catalog);
        if (dbCatalog != null) {
            return dbCatalog.getDefaultSchemaIdentifier();
        }
        return this.getDatabaseDefaultSchema();
    }

    protected String getDatabaseDefaultSchema() {
        Database db = this.getDatabase();
        return db == null ? null : db.getDefaultSchemaIdentifier();
    }

    @Override
    public String getUserOverrideDefaultCatalog() {
        return this.userOverrideDefaultCatalog;
    }

    @Override
    public void setUserOverrideDefaultCatalog(String catalog) {
        String old = this.userOverrideDefaultCatalog;
        this.userOverrideDefaultCatalog = catalog;
        JptCorePlugin.setUserOverrideDefaultCatalog(this.project, catalog);
        this.firePropertyChanged("userOverrideDefaultCatalog", old, catalog);
    }

    @Override
    public String getUserOverrideDefaultSchema() {
        return this.userOverrideDefaultSchema;
    }

    @Override
    public void setUserOverrideDefaultSchema(String schema) {
        String old = this.userOverrideDefaultSchema;
        this.userOverrideDefaultSchema = schema;
        JptCorePlugin.setUserOverrideDefaultSchema(this.project, schema);
        this.firePropertyChanged("userOverrideDefaultSchema", old, schema);
    }

    @Override
    public boolean discoversAnnotatedClasses() {
        return this.discoversAnnotatedClasses;
    }

    @Override
    public void setDiscoversAnnotatedClasses(boolean discoversAnnotatedClasses) {
        boolean old = this.discoversAnnotatedClasses;
        this.discoversAnnotatedClasses = discoversAnnotatedClasses;
        JptCorePlugin.setDiscoverAnnotatedClasses(this.project, discoversAnnotatedClasses);
        this.firePropertyChanged("discoversAnnotatedClasses", old, discoversAnnotatedClasses);
    }

    @Override
    public Iterator<JpaFile> jpaFiles() {
        return this.getJpaFiles().iterator();
    }

    protected Iterable<JpaFile> getJpaFiles() {
        return new LiveCloneIterable(this.jpaFiles);
    }

    @Override
    public int jpaFilesSize() {
        return this.jpaFiles.size();
    }

    protected Iterable<JpaFile> getJpaFiles(final IContentType contentType) {
        return new FilteringIterable<JpaFile>(this.getJpaFiles()){

            protected boolean accept(JpaFile jpaFile) {
                return jpaFile.getContentType().isKindOf(contentType);
            }
        };
    }

    @Override
    public JpaFile getJpaFile(IFile file) {
        for (JpaFile jpaFile : this.getJpaFiles()) {
            if (!jpaFile.getFile().equals((Object)file)) continue;
            return jpaFile;
        }
        return null;
    }

    protected boolean addJpaFile(IFile file) {
        JpaFile jpaFile = this.addJpaFile_(file);
        if (jpaFile != null) {
            this.fireItemAdded("jpaFiles", jpaFile);
            return true;
        }
        return false;
    }

    protected JpaFile addJpaFile_(IFile file) {
        if (!this.getJavaProject().isOnClasspath((IResource)file)) {
            return null;
        }
        JpaFile jpaFile = null;
        try {
            jpaFile = this.getJpaPlatform().buildJpaFile(this, file);
        }
        catch (Exception e) {
            JptCorePlugin.log(e);
        }
        if (jpaFile == null) {
            return null;
        }
        jpaFile.getResourceModel().addResourceModelListener(this.resourceModelListener);
        this.jpaFiles.add(jpaFile);
        return jpaFile;
    }

    protected boolean removeJpaFile(IFile file) {
        JpaFile jpaFile = this.getJpaFile(file);
        if (jpaFile != null) {
            this.removeJpaFile(jpaFile);
            return true;
        }
        return false;
    }

    protected void removeJpaFile(JpaFile jpaFile) {
        jpaFile.getResourceModel().removeResourceModelListener(this.resourceModelListener);
        if (!this.removeItemFromCollection(jpaFile, this.jpaFiles, "jpaFiles")) {
            throw new IllegalArgumentException(jpaFile.toString());
        }
    }

    protected JavaResourcePersistentType buildPersistableExternalJavaResourcePersistentType(String typeName) {
        IType jdtType = this.findType(typeName);
        return jdtType == null ? null : this.buildPersistableExternalJavaResourcePersistentType(jdtType);
    }

    protected IType findType(String typeName) {
        try {
            return this.getJavaProject().findType(typeName);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    protected JavaResourcePersistentType buildPersistableExternalJavaResourcePersistentType(IType jdtType) {
        JavaResourcePersistentType jrpt = this.buildExternalJavaResourcePersistentType(jdtType);
        return jrpt != null && jrpt.isPersistable() ? jrpt : null;
    }

    protected JavaResourcePersistentType buildExternalJavaResourcePersistentType(IType jdtType) {
        return jdtType.isBinary() ? this.buildBinaryExternalJavaResourcePersistentType(jdtType) : this.buildSourceExternalJavaResourcePersistentType(jdtType);
    }

    protected JavaResourcePersistentType buildBinaryExternalJavaResourcePersistentType(IType jdtType) {
        return this.externalJavaResourcePersistentTypeCache.addPersistentType(jdtType);
    }

    protected JavaResourcePersistentType buildSourceExternalJavaResourcePersistentType(IType jdtType) {
        JavaResourceCompilationUnit jrcu = this.getExternalJavaResourceCompilationUnit(jdtType.getCompilationUnit());
        String jdtTypeName = jdtType.getFullyQualifiedName('.');
        Iterator<JavaResourcePersistentType> stream = jrcu.persistentTypes();
        while (stream.hasNext()) {
            JavaResourcePersistentType jrpt = stream.next();
            if (!jrpt.getQualifiedName().equals(jdtTypeName)) continue;
            return jrpt;
        }
        return null;
    }

    @Override
    public JavaResourcePersistentTypeCache getExternalJavaResourcePersistentTypeCache() {
        return this.externalJavaResourcePersistentTypeCache;
    }

    @Override
    public Iterator<JavaResourceCompilationUnit> externalJavaResourceCompilationUnits() {
        return this.getExternalJavaResourceCompilationUnits().iterator();
    }

    protected Iterable<JavaResourceCompilationUnit> getExternalJavaResourceCompilationUnits() {
        return new LiveCloneIterable(this.externalJavaResourceCompilationUnits);
    }

    @Override
    public int externalJavaResourceCompilationUnitsSize() {
        return this.externalJavaResourceCompilationUnits.size();
    }

    protected JavaResourceCompilationUnit getExternalJavaResourceCompilationUnit(ICompilationUnit jdtCompilationUnit) {
        for (JavaResourceCompilationUnit jrcu : this.getExternalJavaResourceCompilationUnits()) {
            if (!jrcu.getCompilationUnit().equals(jdtCompilationUnit)) continue;
            return jrcu;
        }
        return this.addExternalJavaResourceCompilationUnit(jdtCompilationUnit);
    }

    protected JavaResourceCompilationUnit addExternalJavaResourceCompilationUnit(ICompilationUnit jdtCompilationUnit) {
        JavaResourceCompilationUnit jrcu = this.buildJavaResourceCompilationUnit(jdtCompilationUnit);
        this.addItemToCollection(jrcu, this.externalJavaResourceCompilationUnits, "externalJavaResourceCompilationUnits");
        jrcu.addResourceModelListener(this.resourceModelListener);
        return jrcu;
    }

    protected JavaResourceCompilationUnit buildJavaResourceCompilationUnit(ICompilationUnit jdtCompilationUnit) {
        return new SourceCompilationUnit(jdtCompilationUnit, this.jpaPlatform.getAnnotationProvider(), this.jpaPlatform.getAnnotationEditFormatter(), (CommandExecutor)this.modifySharedDocumentCommandExecutor);
    }

    protected boolean removeExternalJavaResourceCompilationUnit(IFile file) {
        for (JavaResourceCompilationUnit jrcu : this.getExternalJavaResourceCompilationUnits()) {
            if (!jrcu.getFile().equals((Object)file)) continue;
            this.removeExternalJavaResourceCompilationUnit(jrcu);
            return true;
        }
        return false;
    }

    protected void removeExternalJavaResourceCompilationUnit(JavaResourceCompilationUnit jrcu) {
        jrcu.removeResourceModelListener(this.resourceModelListener);
        this.removeItemFromCollection(jrcu, this.externalJavaResourceCompilationUnits, "externalJavaResourceCompilationUnits");
    }

    @Override
    public JpaRootContextNode getRootContextNode() {
        return this.rootContextNode;
    }

    @Override
    public IFile convertToPlatformFile(String fileName) {
        return JptCorePlugin.getPlatformFile(this.project, fileName);
    }

    @Override
    public JpaXmlResource getPersistenceXmlResource() {
        return (JpaXmlResource)this.getResourceModel("META-INF/persistence.xml", JptCorePlugin.PERSISTENCE_XML_CONTENT_TYPE);
    }

    @Override
    public JpaXmlResource getDefaultOrmXmlResource() {
        return this.getMappingFileXmlResource("META-INF/orm.xml");
    }

    @Override
    public JpaXmlResource getMappingFileXmlResource(String fileName) {
        return (JpaXmlResource)this.getResourceModel(fileName, JptCorePlugin.MAPPING_FILE_CONTENT_TYPE);
    }

    protected JpaResourceModel getResourceModel(String fileName, IContentType contentType) {
        IFile file = this.convertToPlatformFile(fileName);
        return file.exists() ? this.getResourceModel(file, contentType) : null;
    }

    protected JpaResourceModel getResourceModel(IFile file, IContentType contentType) {
        JpaFile jpaFile = this.getJpaFile(file);
        return jpaFile == null ? null : jpaFile.getResourceModel(contentType);
    }

    @Override
    public Iterator<String> annotatedJavaSourceClassNames() {
        return this.getAnnotatedJavaSourceClassNames().iterator();
    }

    protected Iterable<String> getAnnotatedJavaSourceClassNames() {
        return new TransformationIterable<JavaResourcePersistentType, String>(this.getInternalAnnotatedSourceJavaResourcePersistentTypes()){

            protected String transform(JavaResourcePersistentType jrpType) {
                return jrpType.getQualifiedName();
            }
        };
    }

    protected Iterable<JavaResourcePersistentType> getInternalAnnotatedSourceJavaResourcePersistentTypes() {
        return new FilteringIterable<JavaResourcePersistentType>(this.getInternalSourceJavaResourcePersistentTypes()){

            protected boolean accept(JavaResourcePersistentType jrpType) {
                return jrpType.isPersistable() && jrpType.isAnnotated();
            }
        };
    }

    @Override
    public Iterator<String> mappedJavaSourceClassNames() {
        return this.getMappedJavaSourceClassNames().iterator();
    }

    protected Iterable<String> getMappedJavaSourceClassNames() {
        return new TransformationIterable<JavaResourcePersistentType, String>(this.getInternalMappedSourceJavaResourcePersistentTypes()){

            protected String transform(JavaResourcePersistentType jrpType) {
                return jrpType.getQualifiedName();
            }
        };
    }

    protected Iterable<JavaResourcePersistentType> getInternalMappedSourceJavaResourcePersistentTypes() {
        return new FilteringIterable<JavaResourcePersistentType>(this.getInternalAnnotatedSourceJavaResourcePersistentTypes()){

            protected boolean accept(JavaResourcePersistentType jrpType) {
                return jrpType.isMapped();
            }
        };
    }

    protected Iterable<JavaResourcePersistentType2_0> getInternalSourceJavaResourcePersistentTypes2_0() {
        return new SubIterableWrapper(this.getInternalSourceJavaResourcePersistentTypes());
    }

    protected Iterable<JavaResourcePersistentType> getInternalSourceJavaResourcePersistentTypes() {
        return new CompositeIterable(this.getInternalSourceJavaResourcePersistentTypeSets());
    }

    protected Iterable<Iterable<JavaResourcePersistentType>> getInternalSourceJavaResourcePersistentTypeSets() {
        return new TransformationIterable<JavaResourceCompilationUnit, Iterable<JavaResourcePersistentType>>(this.getInternalJavaResourceCompilationUnits()){

            protected Iterable<JavaResourcePersistentType> transform(final JavaResourceCompilationUnit compilationUnit) {
                return new Iterable<JavaResourcePersistentType>(){

                    @Override
                    public Iterator<JavaResourcePersistentType> iterator() {
                        return compilationUnit.persistentTypes();
                    }
                };
            }
        };
    }

    protected Iterable<JavaResourceCompilationUnit> getInternalJavaResourceCompilationUnits() {
        return new TransformationIterable<JpaFile, JavaResourceCompilationUnit>(this.getJavaSourceJpaFiles()){

            protected JavaResourceCompilationUnit transform(JpaFile jpaFile) {
                return (JavaResourceCompilationUnit)jpaFile.getResourceModel();
            }
        };
    }

    protected Iterable<JpaFile> getJavaSourceJpaFiles() {
        return this.getJpaFiles(JptCorePlugin.JAVA_SOURCE_CONTENT_TYPE);
    }

    @Override
    public JavaResourcePersistentType getJavaResourcePersistentType(String typeName) {
        for (JavaResourcePersistentType jrpType : this.getPersistableJavaResourcePersistentTypes()) {
            if (!jrpType.getQualifiedName().equals(typeName)) continue;
            return jrpType;
        }
        return this.buildPersistableExternalJavaResourcePersistentType(typeName);
    }

    protected Iterable<JavaResourcePersistentType> getPersistableJavaResourcePersistentTypes() {
        return new FilteringIterable<JavaResourcePersistentType>(this.getJavaResourcePersistentTypes()){

            protected boolean accept(JavaResourcePersistentType jrpType) {
                return jrpType.isPersistable();
            }
        };
    }

    protected Iterable<JavaResourcePersistentType> getJavaResourcePersistentTypes() {
        return new CompositeIterable(this.getJavaResourcePersistentTypeSets());
    }

    protected Iterable<Iterable<JavaResourcePersistentType>> getJavaResourcePersistentTypeSets() {
        return new TransformationIterable<JavaResourceNode.Root, Iterable<JavaResourcePersistentType>>(this.getJavaResourceNodeRoots()){

            protected Iterable<JavaResourcePersistentType> transform(final JavaResourceNode.Root root) {
                return new Iterable<JavaResourcePersistentType>(){

                    @Override
                    public Iterator<JavaResourcePersistentType> iterator() {
                        return root.persistentTypes();
                    }
                };
            }
        };
    }

    protected Iterable<JavaResourceNode.Root> getJavaResourceNodeRoots() {
        return new CompositeIterable(new Iterable[]{this.getInternalJavaResourceCompilationUnits(), this.getInternalJavaResourcePackageFragmentRoots(), this.getExternalJavaResourceCompilationUnits(), Collections.singleton(this.externalJavaResourcePersistentTypeCache)});
    }

    @Override
    public JavaResourcePackageFragmentRoot getJavaResourcePackageFragmentRoot(String jarFileName) {
        return this.getJavaResourcePackageFragmentRoot(this.getProject().getFile(jarFileName));
    }

    protected JavaResourcePackageFragmentRoot getJavaResourcePackageFragmentRoot(IFile jarFile) {
        for (JavaResourcePackageFragmentRoot pfr : this.getInternalJavaResourcePackageFragmentRoots()) {
            if (!pfr.getFile().equals((Object)jarFile)) continue;
            return pfr;
        }
        return null;
    }

    protected Iterable<JavaResourcePackageFragmentRoot> getInternalJavaResourcePackageFragmentRoots() {
        return new TransformationIterable<JpaFile, JavaResourcePackageFragmentRoot>(this.getJarJpaFiles()){

            protected JavaResourcePackageFragmentRoot transform(JpaFile jpaFile) {
                return (JavaResourcePackageFragmentRoot)jpaFile.getResourceModel();
            }
        };
    }

    protected Iterable<JpaFile> getJarJpaFiles() {
        return this.getJpaFiles(JptCorePlugin.JAR_CONTENT_TYPE);
    }

    @Override
    public Iterable<JavaResourcePersistentType2_0> getGeneratedMetamodelTopLevelTypes() {
        if (this.metamodelSourceFolderName == null) {
            return EmptyIterable.instance();
        }
        final IPackageFragmentRoot genSourceFolder = this.getMetamodelPackageFragmentRoot();
        return new FilteringIterable<JavaResourcePersistentType2_0>(this.getInternalSourceJavaResourcePersistentTypes2_0()){

            protected boolean accept(JavaResourcePersistentType2_0 jrpt) {
                return jrpt.isGeneratedMetamodelTopLevelType(genSourceFolder);
            }
        };
    }

    @Override
    public JavaResourcePersistentType2_0 getGeneratedMetamodelTopLevelType(IFile file) {
        JavaResourceCompilationUnit jrcu = this.getJavaResourceCompilationUnit(file);
        if (jrcu == null) {
            return null;
        }
        Iterator<JavaResourcePersistentType> types = jrcu.persistentTypes();
        if (!types.hasNext()) {
            return null;
        }
        JavaResourcePersistentType2_0 jrpt = (JavaResourcePersistentType2_0)types.next();
        return jrpt.isGeneratedMetamodelTopLevelType() ? jrpt : null;
    }

    protected JavaResourceCompilationUnit getJavaResourceCompilationUnit(IFile file) {
        return (JavaResourceCompilationUnit)this.getResourceModel(file, JptCorePlugin.JAVA_SOURCE_CONTENT_TYPE);
    }

    @Override
    public String getMetamodelSourceFolderName() {
        return this.metamodelSourceFolderName;
    }

    @Override
    public void setMetamodelSourceFolderName(String metamodelSourceFolderName) {
        String old = this.metamodelSourceFolderName;
        this.metamodelSourceFolderName = metamodelSourceFolderName;
        if (this.attributeValueHasChanged(old, metamodelSourceFolderName)) {
            JptCorePlugin.setMetamodelSourceFolderName(this.project, metamodelSourceFolderName);
            this.firePropertyChanged("metamodelSourceFolderName", old, metamodelSourceFolderName);
            if (metamodelSourceFolderName == null) {
                this.disposeMetamodel();
            } else {
                this.initializeMetamodel();
            }
        }
    }

    @Override
    public void initializeMetamodel() {
        if (this.isJpa2_0Compatible()) {
            ((JpaRootContextNode2_0)this.rootContextNode).initializeMetamodel();
        }
    }

    @Override
    public void synchronizeMetamodel() {
        if (this.isJpa2_0Compatible() && this.metamodelSourceFolderName != null) {
            ((JpaRootContextNode2_0)this.rootContextNode).synchronizeMetamodel();
        }
    }

    @Override
    public void disposeMetamodel() {
        if (this.isJpa2_0Compatible()) {
            ((JpaRootContextNode2_0)this.rootContextNode).disposeMetamodel();
        }
    }

    @Override
    public IPackageFragmentRoot getMetamodelPackageFragmentRoot() {
        return this.getJavaProject().getPackageFragmentRoot((IResource)this.getMetaModelSourceFolder());
    }

    protected IFolder getMetaModelSourceFolder() {
        return this.getProject().getFolder(this.metamodelSourceFolderName);
    }

    protected void checkMetamodelSourceFolderName() {
        if (this.metamodelSoureFolderNameIsInvalid()) {
            this.setMetamodelSourceFolderName(null);
        }
    }

    protected boolean metamodelSoureFolderNameIsInvalid() {
        return !this.metamodelSourceFolderNameIsValid();
    }

    protected boolean metamodelSourceFolderNameIsValid() {
        return CollectionTools.contains(this.getJavaSourceFolderNames(), (Object)this.metamodelSourceFolderName);
    }

    @Override
    public Iterable<String> getJavaSourceFolderNames() {
        try {
            return this.getJavaSourceFolderNames_();
        }
        catch (JavaModelException ex) {
            JptCorePlugin.log(ex);
            return EmptyIterable.instance();
        }
    }

    protected Iterable<String> getJavaSourceFolderNames_() throws JavaModelException {
        return new TransformationIterable<IPackageFragmentRoot, String>(this.getJavaSourceFolders()){

            protected String transform(IPackageFragmentRoot pfr) {
                try {
                    return this.transform_(pfr);
                }
                catch (JavaModelException javaModelException) {
                    return "Error: " + pfr.getPath();
                }
            }

            private String transform_(IPackageFragmentRoot pfr) throws JavaModelException {
                return pfr.getUnderlyingResource().getProjectRelativePath().toString();
            }
        };
    }

    protected Iterable<IPackageFragmentRoot> getJavaSourceFolders() throws JavaModelException {
        return new FilteringIterable(this.getPackageFragmentRoots(), SOURCE_PACKAGE_FRAGMENT_ROOT_FILTER);
    }

    protected Iterable<IPackageFragmentRoot> getPackageFragmentRoots() throws JavaModelException {
        return new ArrayIterable((Object[])this.getJavaProject().getPackageFragmentRoots());
    }

    @Override
    public void javaElementChanged(ElementChangedEvent event) {
        this.processJavaDelta(event.getDelta());
    }

    protected void processJavaDelta(IJavaElementDelta delta) {
        switch (delta.getElement().getElementType()) {
            case 1: {
                this.processJavaModelDelta(delta);
                break;
            }
            case 2: {
                this.processJavaProjectDelta(delta);
                break;
            }
            case 3: {
                this.processJavaPackageFragmentRootDelta(delta);
                break;
            }
            case 4: {
                this.processJavaPackageFragmentDelta(delta);
                break;
            }
            case 5: {
                this.processJavaCompilationUnitDelta(delta);
                break;
            }
        }
    }

    protected void processJavaDeltaChildren(IJavaElementDelta delta) {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta child = iJavaElementDeltaArray[n2];
            this.processJavaDelta(child);
            ++n2;
        }
    }

    protected boolean deltaFlagIsSet(IJavaElementDelta delta, int flag) {
        return delta.getKind() == 4 && BitTools.flagIsSet((int)delta.getFlags(), (int)flag);
    }

    protected void processJavaModelDelta(IJavaElementDelta delta) {
        this.processJavaDeltaChildren(delta);
    }

    protected void processJavaProjectDelta(IJavaElementDelta delta) {
        this.processJavaDeltaChildren(delta);
        if (this.classpathHasChanged(delta)) {
            this.rebuild((IJavaProject)delta.getElement());
        }
    }

    protected void rebuild(IJavaProject javaProject) {
        if (javaProject.equals(this.getJavaProject())) {
            this.removeDeadJpaFiles();
            this.checkMetamodelSourceFolderName();
            this.update(this.getInternalJavaResourceCompilationUnits());
        } else {
            this.update(this.getExternalJavaResourceCompilationUnits());
        }
    }

    protected void removeDeadJpaFiles() {
        for (JpaFile jpaFile : this.getJpaFiles()) {
            if (!this.jpaFileIsDead(jpaFile)) continue;
            this.removeJpaFile(jpaFile);
        }
    }

    protected boolean jpaFileIsDead(JpaFile jpaFile) {
        return !this.jpaFileIsAlive(jpaFile);
    }

    protected boolean jpaFileIsAlive(JpaFile jpaFile) {
        IFile file = jpaFile.getFile();
        return this.getJavaProject().isOnClasspath((IResource)file) && file.exists();
    }

    protected boolean classpathHasChanged(IJavaElementDelta delta) {
        return this.deltaFlagIsSet(delta, 0x200000);
    }

    protected void update(Iterable<JavaResourceCompilationUnit> javaResourceCompilationUnits) {
        for (JavaResourceCompilationUnit javaResourceCompilationUnit : javaResourceCompilationUnits) {
            javaResourceCompilationUnit.synchronizeWithJavaSource();
        }
    }

    protected void processJavaPackageFragmentRootDelta(IJavaElementDelta delta) {
        this.processJavaDeltaChildren(delta);
        if (!this.classpathEntryHasBeenAdded(delta)) {
            this.classpathEntryHasBeenRemoved(delta);
        }
    }

    protected boolean classpathEntryHasBeenAdded(IJavaElementDelta delta) {
        return this.deltaFlagIsSet(delta, 64);
    }

    protected boolean classpathEntryHasBeenRemoved(IJavaElementDelta delta) {
        return this.deltaFlagIsSet(delta, 128);
    }

    protected void processJavaPackageFragmentDelta(IJavaElementDelta delta) {
        this.processJavaDeltaChildren(delta);
    }

    protected void processJavaCompilationUnitDelta(IJavaElementDelta delta) {
        if (this.javaCompilationUnitDeltaIsRelevant(delta)) {
            ICompilationUnit compilationUnit = (ICompilationUnit)delta.getElement();
            for (JavaResourceCompilationUnit jrcu : this.getCombinedJavaResourceCompilationUnits()) {
                if (!jrcu.getCompilationUnit().equals(compilationUnit)) continue;
                jrcu.synchronizeWithJavaSource();
                break;
            }
        }
    }

    protected boolean javaCompilationUnitDeltaIsRelevant(IJavaElementDelta delta) {
        if (BitTools.onlyFlagIsSet((int)delta.getFlags(), (int)65536)) {
            return false;
        }
        return delta.getKind() == 4;
    }

    @Override
    public Iterator<IMessage> validationMessages(IReporter reporter) {
        ArrayList<IMessage> messages = new ArrayList<IMessage>();
        this.validate(messages, reporter);
        return messages.iterator();
    }

    protected void validate(List<IMessage> messages, IReporter reporter) {
        if (reporter.isCancelled()) {
            throw new ValidationCancelledException();
        }
        this.validateConnection(messages);
        this.rootContextNode.validate(messages, reporter);
    }

    protected void validateConnection(List<IMessage> messages) {
        String cpName = this.dataSource.getConnectionProfileName();
        if (StringTools.stringIsEmpty((String)cpName)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(2, "PROJECT_NO_CONNECTION", this));
            return;
        }
        ConnectionProfile cp = this.dataSource.getConnectionProfile();
        if (cp == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(2, "PROJECT_INVALID_CONNECTION", new String[]{cpName}, this));
            return;
        }
        if (cp.isInactive()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(2, "PROJECT_INACTIVE_CONNECTION", new String[]{cpName}, this));
        }
    }

    @Override
    public void dispose() {
        this.updater.stop();
        this.dataSource.dispose();
        for (JpaFile jpaFile : this.getJpaFiles()) {
            jpaFile.getResourceModel().removeResourceModelListener(this.resourceModelListener);
        }
    }

    @Override
    public void projectChanged(IResourceDelta delta) {
        if (delta.getResource().equals((Object)this.getProject())) {
            this.internalProjectChanged(delta);
        } else {
            this.externalProjectChanged(delta);
        }
    }

    protected void internalProjectChanged(IResourceDelta delta) {
        ResourceDeltaVisitor resourceDeltaVisitor = this.buildInternalResourceDeltaVisitor();
        resourceDeltaVisitor.visitDelta(delta);
        if (resourceDeltaVisitor.encounteredSignificantChange()) {
            this.resolveInternalJavaTypes();
        }
    }

    protected ResourceDeltaVisitor buildInternalResourceDeltaVisitor() {
        return new ResourceDeltaVisitor(){

            public boolean fileChangeIsSignificant(IFile file, int deltaKind) {
                return AbstractJpaProject.this.synchronizeJpaFiles(file, deltaKind);
            }
        };
    }

    protected boolean synchronizeJpaFiles(IFile file, int deltaKind) {
        switch (deltaKind) {
            case 1: {
                return this.addJpaFile(file);
            }
            case 2: {
                return this.removeJpaFile(file);
            }
            case 4: {
                return this.checkForChangedFileContent(file);
            }
            case 8: {
                break;
            }
            case 16: {
                break;
            }
        }
        return false;
    }

    protected boolean checkForChangedFileContent(IFile file) {
        JpaFile jpaFile = this.getJpaFile(file);
        if (jpaFile == null) {
            return this.addJpaFile(file);
        }
        if (jpaFile.getContentType().equals(PlatformTools.getContentType(file))) {
            return false;
        }
        this.removeJpaFile(jpaFile);
        this.addJpaFile(file);
        return true;
    }

    protected void resolveInternalJavaTypes() {
        for (JavaResourceCompilationUnit jrcu : this.getInternalJavaResourceCompilationUnits()) {
            jrcu.resolveTypes();
        }
    }

    protected void externalProjectChanged(IResourceDelta delta) {
        if (this.getJavaProject().isOnClasspath(delta.getResource())) {
            ResourceDeltaVisitor resourceDeltaVisitor = this.buildExternalResourceDeltaVisitor();
            resourceDeltaVisitor.visitDelta(delta);
            if (resourceDeltaVisitor.encounteredSignificantChange()) {
                this.update();
                this.resolveExternalJavaTypes();
                this.resolveInternalJavaTypes();
            }
        }
    }

    protected ResourceDeltaVisitor buildExternalResourceDeltaVisitor() {
        return new ResourceDeltaVisitor(){

            public boolean fileChangeIsSignificant(IFile file, int deltaKind) {
                return AbstractJpaProject.this.synchronizeExternalFiles(file, deltaKind);
            }
        };
    }

    protected boolean synchronizeExternalFiles(IFile file, int deltaKind) {
        switch (deltaKind) {
            case 1: {
                return this.externalFileAdded(file);
            }
            case 2: {
                return this.externalFileRemoved(file);
            }
            case 4: {
                break;
            }
            case 8: {
                break;
            }
            case 16: {
                break;
            }
        }
        return false;
    }

    protected boolean externalFileAdded(IFile file) {
        IContentType contentType = PlatformTools.getContentType(file);
        if (contentType == null) {
            return false;
        }
        if (contentType.equals(JptCorePlugin.JAVA_SOURCE_CONTENT_TYPE)) {
            return true;
        }
        return contentType.equals(JptCorePlugin.JAR_CONTENT_TYPE);
    }

    protected boolean externalFileRemoved(IFile file) {
        IContentType contentType = PlatformTools.getContentType(file);
        if (contentType == null) {
            return false;
        }
        if (contentType.equals(JptCorePlugin.JAVA_SOURCE_CONTENT_TYPE)) {
            return this.removeExternalJavaResourceCompilationUnit(file);
        }
        if (contentType.equals(JptCorePlugin.JAR_CONTENT_TYPE)) {
            return this.externalJavaResourcePersistentTypeCache.removePersistentTypes(file);
        }
        return false;
    }

    protected void resolveExternalJavaTypes() {
        for (JavaResourceCompilationUnit jrcu : this.getExternalJavaResourceCompilationUnits()) {
            jrcu.resolveTypes();
        }
    }

    @Override
    public void setThreadLocalModifySharedDocumentCommandExecutor(CommandExecutor commandExecutor) {
        this.modifySharedDocumentCommandExecutor.set(commandExecutor);
    }

    @Override
    public CommandExecutor getModifySharedDocumentCommandExecutor() {
        return this.modifySharedDocumentCommandExecutor;
    }

    protected void synchronizeContextModel(JpaResourceModel jpaResourceModel) {
        this.synchronizeContextModel();
    }

    @Override
    public void synchronizeContextModel() {
        this.update();
    }

    @Override
    public JpaProject.Updater getUpdater() {
        return this.updater;
    }

    @Override
    public void setUpdater(JpaProject.Updater updater) {
        if (updater == null) {
            throw new NullPointerException();
        }
        this.updater.stop();
        this.setUpdater_(updater);
    }

    protected void setUpdater_(JpaProject.Updater updater) {
        this.updater = updater;
        this.updater.start();
    }

    @Override
    public void update() {
        this.updater.update();
    }

    @Override
    public IStatus update(IProgressMonitor monitor) {
        this.update_(monitor);
        return Status.OK_STATUS;
    }

    protected void update_(IProgressMonitor monitor) {
        this.rootContextNode.update(monitor);
        this.rootContextNode.postUpdate();
    }

    @Override
    public void updateQuiesced() {
        this.synchronizeMetamodel();
    }

    protected class DefaultResourceModelListener
    implements JpaResourceModelListener {
        protected DefaultResourceModelListener() {
        }

        public void resourceModelChanged(JpaResourceModel jpaResourceModel) {
            AbstractJpaProject.this.synchronizeContextModel(jpaResourceModel);
        }

        public void resourceModelReverted(JpaResourceModel jpaResourceModel) {
            IFile file = WorkbenchResourceHelper.getFile((ReferencedResource)((JpaXmlResource)jpaResourceModel));
            AbstractJpaProject.this.removeJpaFile(file);
            AbstractJpaProject.this.addJpaFile(file);
        }

        public void resourceModelUnloaded(JpaResourceModel jpaResourceModel) {
            IFile file = WorkbenchResourceHelper.getFile((ReferencedResource)((JpaXmlResource)jpaResourceModel));
            AbstractJpaProject.this.removeJpaFile(file);
        }
    }

    protected class InitialResourceProxyVisitor
    implements IResourceProxyVisitor {
        protected InitialResourceProxyVisitor() {
        }

        protected void visitProject(IProject p) {
            try {
                p.accept((IResourceProxyVisitor)this, 0);
            }
            catch (CoreException ex) {
                throw new RuntimeException(ex);
            }
        }

        public boolean visit(IResourceProxy resource) {
            switch (resource.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 1: {
                    AbstractJpaProject.this.addJpaFile_((IFile)resource.requestResource());
                    return false;
                }
            }
            return false;
        }
    }

    protected abstract class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        protected boolean encounteredSignificantChange = false;

        protected ResourceDeltaVisitor() {
        }

        protected void visitDelta(IResourceDelta delta) {
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException ex) {
                throw new RuntimeException(ex);
            }
        }

        public boolean visit(IResourceDelta delta) {
            IResource res = delta.getResource();
            switch (res.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 1: {
                    this.fileChanged((IFile)res, delta.getKind());
                    return false;
                }
            }
            return false;
        }

        protected void fileChanged(IFile file, int deltaKind) {
            if (this.fileChangeIsSignificant(file, deltaKind)) {
                this.encounteredSignificantChange = true;
            }
        }

        protected abstract boolean fileChangeIsSignificant(IFile var1, int var2);

        protected boolean encounteredSignificantChange() {
            return this.encounteredSignificantChange;
        }
    }
}

