/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.utility;

import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.birt.report.engine.api.DataExtractionOption;
import org.eclipse.birt.report.engine.dataextraction.CSVDataExtractionOption;
import org.eclipse.birt.report.engine.dataextraction.CommonDataExtractionOption;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class DataExtractionParameterUtil {
    public static final String DEFAULT_SEP = ",";
    public static final String PARAM_EXPORT_ENCODING = "__exportencoding";
    public static final String PARAM_SEP = "__sep";
    public static final String PARAM_EXPORT_DATATYPE = "__exportdatatype";
    public static final String PARAM_RESULTSETNAME = "__resultsetname";
    public static final String PARAM_SELECTEDCOLUMNNUMBER = "__selectedcolumnnumber";
    public static final String PARAM_SELECTEDCOLUMN = "__selectedcolumn";
    public static final String PARAM_LOCALENEUTRAL = "__localeneutral";
    public static final String EXTRACTION_FORMAT_CSV = "csv";
    public static final String EXTRACTION_EXTENSION_CSV = "org.eclipse.birt.report.engine.dataextraction.csv";

    public static String getResultSetName(Map options) {
        if (options != null) {
            return (String)options.get(PARAM_RESULTSETNAME);
        }
        return null;
    }

    public static String[] getSelectedColumns(Map options) {
        if (options == null) {
            return null;
        }
        int columnCount = 0;
        try {
            String numStr = (String)options.get(PARAM_SELECTEDCOLUMNNUMBER);
            if (numStr != null) {
                columnCount = Integer.parseInt(numStr);
            }
        }
        catch (Exception exception) {
            columnCount = 0;
        }
        String[] columns = new String[columnCount];
        int i = 0;
        while (i < columnCount) {
            String columnName;
            String paramName = PARAM_SELECTEDCOLUMN + String.valueOf(i);
            columns[i] = columnName = (String)options.get(paramName);
            ++i;
        }
        return columns;
    }

    public static String getSep(Map options) {
        if (options == null) {
            return DEFAULT_SEP;
        }
        String sepKey = (String)options.get(PARAM_SEP);
        if (sepKey == null) {
            return DEFAULT_SEP;
        }
        String key = "viewer.sep." + sepKey;
        String sep = ParameterAccessor.getInitProp(key);
        if (sep == null || sep.length() <= 0) {
            return DEFAULT_SEP;
        }
        return sep;
    }

    public static String getExportEncoding(Map options) {
        if (options == null) {
            return "UTF-8";
        }
        String encoding = (String)options.get(PARAM_EXPORT_ENCODING);
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    public static boolean isExportDataType(Map options) {
        if (options == null) {
            return false;
        }
        String flag = (String)options.get(PARAM_EXPORT_DATATYPE);
        return "true".equalsIgnoreCase(flag);
    }

    public static boolean isLocaleNeutral(Map options) {
        if (options == null) {
            return false;
        }
        String flag = (String)options.get(PARAM_LOCALENEUTRAL);
        return "true".equalsIgnoreCase(flag);
    }

    public static DataExtractionOption createOptions(CommonDataExtractionOption extractOption, String[] columns, Locale locale, TimeZone timeZone, Map options) {
        if (extractOption == null) {
            extractOption = new CommonDataExtractionOption();
        }
        extractOption.setEncoding(DataExtractionParameterUtil.getExportEncoding(options));
        extractOption.setExportDataType(DataExtractionParameterUtil.isExportDataType(options));
        extractOption.setLocaleNeutralFormat(DataExtractionParameterUtil.isLocaleNeutral(options));
        extractOption.setLocale(locale);
        extractOption.setTimeZone(timeZone);
        extractOption.setSelectedColumns(columns);
        extractOption.setUserParameters(options);
        return extractOption;
    }

    public static DataExtractionOption createCSVOptions(String[] columns, Locale locale, TimeZone timeZone, Map options) {
        CSVDataExtractionOption extractOption = new CSVDataExtractionOption();
        DataExtractionParameterUtil.createOptions((CommonDataExtractionOption)extractOption, columns, locale, timeZone, options);
        extractOption.setSeparator(DataExtractionParameterUtil.getSep(options));
        return extractOption;
    }

    public static String[] getColumnNames(Collection columns) {
        if (columns != null && columns.size() > 0) {
            String[] columnNames = new String[columns.size()];
            Iterator iSelectedColumns = columns.iterator();
            int i = 0;
            while (iSelectedColumns.hasNext()) {
                columnNames[i] = ParameterAccessor.htmlDecode((String)iSelectedColumns.next());
                ++i;
            }
            return columnNames;
        }
        return null;
    }
}

