/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.viewers;

import java.net.URI;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIImages;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.p2.ui.model.IRepositoryElement;
import org.eclipse.equinox.internal.p2.ui.model.ProvElement;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class ProvElementLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public String getText(Object obj) {
        if (obj instanceof ProvElement) {
            return ((ProvElement)obj).getLabel(obj);
        }
        if (obj instanceof IProfile) {
            return ((IProfile)obj).getProfileId();
        }
        if (obj instanceof IInstallableUnit) {
            IInstallableUnit iu = (IInstallableUnit)obj;
            return iu.getId();
        }
        if (obj instanceof IRepository) {
            String name = ((IRepository)obj).getName();
            if (name != null && name.length() > 0) {
                return name;
            }
            return URIUtil.toUnencodedString((URI)((IRepository)obj).getLocation());
        }
        if (obj instanceof IRepositoryElement) {
            String name = ((IRepositoryElement)obj).getName();
            if (name != null && name.length() > 0) {
                return name;
            }
            return URIUtil.toUnencodedString((URI)((IRepositoryElement)obj).getLocation());
        }
        if (obj instanceof IArtifactKey) {
            IArtifactKey key = (IArtifactKey)obj;
            return String.valueOf(key.getId()) + " [" + key.getClassifier() + "]";
        }
        if (obj instanceof IProcessingStepDescriptor) {
            IProcessingStepDescriptor descriptor = (IProcessingStepDescriptor)obj;
            return descriptor.getProcessorId();
        }
        if (obj instanceof IRequiredCapability) {
            return ((IRequiredCapability)obj).getName();
        }
        return obj.toString();
    }

    public Image getImage(Object obj) {
        if (obj instanceof ProvElement) {
            return ((ProvElement)obj).getImage(obj);
        }
        if (obj instanceof IProfile) {
            return ProvUIImages.getImage("obj/profile_obj.gif");
        }
        if (obj instanceof IInstallableUnit) {
            return ProvUIImages.getImage("obj/iu_obj.gif");
        }
        if (obj instanceof IArtifactRepository) {
            return ProvUIImages.getImage("obj/artifact_repo_obj.gif");
        }
        if (obj instanceof IMetadataRepository) {
            return ProvUIImages.getImage("obj/metadata_repo_obj.gif");
        }
        if (obj instanceof IArtifactKey) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
        if (obj instanceof IRequirement) {
            return ProvUIImages.getImage("obj/iu_obj.gif");
        }
        return null;
    }

    public Image getColumnImage(Object element, int index) {
        if (index == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getText(element);
            }
            case 1: {
                Class<?> clazz;
                if (element instanceof IProfile) {
                    return ((IProfile)element).getProperty("org.eclipse.equinox.p2.name");
                }
                if (element instanceof IIUElement && ((IIUElement)element).shouldShowVersion()) {
                    return ((IIUElement)element).getIU().getVersion().toString();
                }
                try {
                    clazz = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                IInstallableUnit iu = (IInstallableUnit)ProvUI.getAdapter(element, clazz);
                if (iu != null) {
                    return iu.getVersion().toString();
                }
                if (element instanceof IRepository) {
                    return URIUtil.toUnencodedString((URI)((IRepository)element).getLocation());
                }
                if (element instanceof IRepositoryElement) {
                    return URIUtil.toUnencodedString((URI)((IRepositoryElement)element).getLocation());
                }
                if (element instanceof IArtifactKey) {
                    IArtifactKey key = (IArtifactKey)element;
                    return key.getVersion().toString();
                }
                if (!(element instanceof IRequiredCapability)) break;
                return ((IRequiredCapability)element).getRange().getMaximum().toString();
            }
        }
        return null;
    }
}

