/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.annotations.core;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jst.ws.annotations.core.AnnotationsCorePlugin;
import org.eclipse.jst.ws.annotations.core.AnnotationsManager;
import org.eclipse.jst.ws.annotations.core.initialization.IAnnotationAttributeInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationDefinition {
    private static final String ATT_CLASS = "class";
    private static final String ATT_NAME = "name";
    private static final String ATT_RESTRICTED_TO = "restrictedTo";
    private static final String RESTRICTED_TO_CLASS_ONLY = "CLASS_ONLY";
    private static final String RESTRICTED_TO_INTERFACE_ONLY = "INTERFACE_ONLY";
    private static final String RESTRICTED_TO_ENUM_ONLY = "ENUM_ONLY";
    private static final String ELEM_TARGET_FILTER = "targetFilter";
    private static final String ATT_TARGET = "target";
    private IConfigurationElement configurationElement;
    private String category;
    private String annotationClassName;
    private Class<? extends Annotation> annotationClass;
    private List<ElementType> targets;
    private String name;
    private IAnnotationAttributeInitializer annotationInitializer;
    private String restictedTo;
    private boolean interfaceOnly;
    private boolean classOnly;
    private boolean enumOnly;

    public AnnotationDefinition(IConfigurationElement configurationElement, String category) {
        this.configurationElement = configurationElement;
        this.category = category;
        this.annotationClassName = AnnotationsManager.getAttributeValue(configurationElement, ATT_CLASS);
        this.name = AnnotationsManager.getAttributeValue(configurationElement, ATT_NAME);
        this.restictedTo = AnnotationsManager.getAttributeValue(configurationElement, ATT_RESTRICTED_TO);
        this.classOnly = this.restictedTo.equals(RESTRICTED_TO_CLASS_ONLY);
        this.interfaceOnly = this.restictedTo.equals(RESTRICTED_TO_INTERFACE_ONLY);
        this.enumOnly = this.restictedTo.equals(RESTRICTED_TO_ENUM_ONLY);
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public String getAnnotationClassName() {
        return this.annotationClassName;
    }

    public boolean isClassOnly() {
        return this.classOnly;
    }

    public boolean isInterfaceOnly() {
        return this.interfaceOnly;
    }

    public boolean isEnumOnly() {
        return this.enumOnly;
    }

    public Class<? extends Annotation> getAnnotationClass() {
        if (this.annotationClass == null) {
            try {
                Class<?> aClass = Class.forName(this.annotationClassName);
                if (aClass.isAnnotation()) {
                    this.annotationClass = Class.forName(this.annotationClassName);
                }
            }
            catch (ClassNotFoundException cnfe) {
                AnnotationsCorePlugin.log(cnfe);
            }
        }
        return this.annotationClass;
    }

    public List<ElementType> getTargets() {
        if (this.targets == null) {
            Target target;
            this.targets = new LinkedList<ElementType>();
            Class<? extends Annotation> annotation = this.getAnnotationClass();
            if (annotation != null && (target = annotation.getAnnotation(Target.class)) != null) {
                this.targets.addAll(Arrays.asList(target.value()));
                List<ElementType> filteredTargets = this.getFilteredTargets(this.configurationElement);
                if (this.targets.containsAll(filteredTargets) && filteredTargets.size() < this.targets.size()) {
                    this.targets.removeAll(filteredTargets);
                }
            }
        }
        return this.targets;
    }

    public IAnnotationAttributeInitializer getAnnotationAttributeInitializer() {
        if (this.annotationInitializer == null) {
            try {
                IConfigurationElement configurationElement = AnnotationsManager.getAnnotationInitializerCache().get(this.getAnnotationClassName());
                if (configurationElement != null) {
                    this.annotationInitializer = (IAnnotationAttributeInitializer)configurationElement.createExecutableExtension(ATT_CLASS);
                }
            }
            catch (CoreException ce) {
                AnnotationsCorePlugin.log(ce.getStatus());
            }
        }
        return this.annotationInitializer;
    }

    private List<ElementType> getFilteredTargets(IConfigurationElement configurationElement) {
        ArrayList<ElementType> targets = new ArrayList<ElementType>(7);
        try {
            IConfigurationElement[] deprecatedTargets;
            IConfigurationElement[] iConfigurationElementArray = deprecatedTargets = configurationElement.getChildren(ELEM_TARGET_FILTER);
            int n = deprecatedTargets.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement deprecatedTargetElement = iConfigurationElementArray[n2];
                String target = AnnotationsManager.getAttributeValue(deprecatedTargetElement, ATT_TARGET);
                targets.add(ElementType.valueOf(target));
                ++n2;
            }
        }
        catch (IllegalArgumentException iae) {
            AnnotationsCorePlugin.log(iae);
        }
        return targets;
    }
}

