/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.integrate;

import java.util.ArrayList;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.StructureType;
import org.eclipse.birt.chart.factory.ActionEvaluatorAdapter;
import org.eclipse.birt.chart.integrate.SimpleActionHandle;
import org.eclipse.birt.chart.integrate.SimpleActionUtil;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.MultiURLValues;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.MultipleActions;

public class SimpleActionEvaluator
extends ActionEvaluatorAdapter {
    public String[] getActionExpressions(Action action, StructureSource source) {
        TooltipValue tv;
        String exp;
        if (action instanceof MultipleActions) {
            ArrayList<String> expList = new ArrayList<String>();
            for (Action subAction : ((MultipleActions)action).getActions()) {
                ActionType at = subAction.getType();
                if (at != ActionType.URL_REDIRECT_LITERAL || !(subAction.getValue() instanceof URLValue)) continue;
                String sa = ((URLValue)subAction.getValue()).getBaseUrl();
                SimpleActionHandle handle = SimpleActionUtil.deserializeAction(sa);
                expList.add(handle.getURI());
            }
            if (expList.size() > 0) {
                return expList.toArray(new String[expList.size()]);
            }
        } else if (ActionType.URL_REDIRECT_LITERAL.equals((Object)action.getType())) {
            ArrayList<String> expList = new ArrayList<String>();
            if (action.getValue() instanceof URLValue) {
                URLValue uv = (URLValue)action.getValue();
                String sa = uv.getBaseUrl();
                SimpleActionHandle handle = SimpleActionUtil.deserializeAction(sa);
                expList.add(handle.getURI());
            } else if (action.getValue() instanceof MultiURLValues) {
                for (URLValue uv : ((MultiURLValues)action.getValue()).getURLValues()) {
                    String sa = uv.getBaseUrl();
                    SimpleActionHandle handle = SimpleActionUtil.deserializeAction(sa);
                    expList.add(handle.getURI());
                }
            }
            if (expList.size() > 0) {
                return expList.toArray(new String[expList.size()]);
            }
        } else if (ActionType.SHOW_TOOLTIP_LITERAL.equals((Object)action.getType()) && StructureType.SERIES.equals(source.getType()) && (exp = (tv = (TooltipValue)action.getValue()).getText()) != null && exp.trim().length() > 0) {
            return new String[]{exp};
        }
        return null;
    }
}

